package jp.gr.java_conf.jaba2.xml.mathml.relaxer;

import org.w3c.dom.*;

/**
 * <b>MMtable</b> is generated by Relaxer based on MathML.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="mtable">
 *   <choice occurs="*">
 *     <ref label="mi"/>
 *     <ref label="mn"/>
 *     <ref label="mo"/>
 *     <ref label="mtext"/>
 *     <ref label="ms"/>
 *     <ref label="mspace"/>
 *     <ref label="mprescripts"/>
 *     <ref label="none"/>
 *     <ref label="mrow"/>
 *     <ref label="mfrac"/>
 *     <ref label="msqrt"/>
 *     <ref label="mroot"/>
 *     <ref label="mstyle"/>
 *     <ref label="merror"/>
 *     <ref label="mpadded"/>
 *     <ref label="mphantom"/>
 *     <ref label="mfenced"/>
 *     <ref label="msub"/>
 *     <ref label="msup"/>
 *     <ref label="msubsup"/>
 *     <ref label="munder"/>
 *     <ref label="mover"/>
 *     <ref label="munderover"/>
 *     <ref label="mmultiscripts"/>
 *     <ref label="mtable"/>
 *     <ref label="mtr"/>
 *     <ref label="mtd"/>
 *     <ref label="maligngroup"/>
 *     <ref label="malignmark"/>
 *     <ref label="maction"/>
 *     <ref label="ci"/>
 *     <ref label="cn"/>
 *     <ref label="apply"/>
 *     <ref label="fn"/>
 *     <ref label="lambda"/>
 *     <ref label="reln"/>
 *     <ref label="interval"/>
 *     <ref label="list"/>
 *     <ref label="matrix"/>
 *     <ref label="matrixrow"/>
 *     <ref label="set"/>
 *     <ref label="vector"/>
 *     <ref label="semantics"/>
 *   </choice>
 * </elementRule>
 * 
 * <tag name="mtable">
 *   <attribute name="align" type="string"/>
 *   <attribute name="rowalign" type="string"/>
 *   <attribute name="columnalign" type="string"/>
 *   <attribute name="groupalign" type="string"/>
 *   <attribute name="alignmentscope" type="string"/>
 *   <attribute name="rowspacing" type="string"/>
 *   <attribute name="columnspacing" type="string"/>
 *   <attribute name="rowlines" type="string"/>
 *   <attribute name="columnlines" type="string"/>
 *   <attribute name="frame" type="NMTOKEN">
 *     <enumeration value="none"/>
 *     <enumeration value="solid"/>
 *     <enumeration value="dashed"/>
 *   </attribute>
 *   <attribute name="framespacing" type="string"/>
 *   <attribute name="equalrows" type="string"/>
 *   <attribute name="equalcolumns" type="string"/>
 *   <attribute name="displaystyle" type="NMTOKEN">
 *     <enumeration value="true"/>
 *     <enumeration value="false"/>
 *   </attribute>
 *   <attribute name="class" type="string"/>
 *   <attribute name="style" type="string"/>
 *   <attribute name="id" type="ID"/>
 *   <attribute name="other" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="mtable"&gt;
 *   &lt;choice occurs="*"&gt;
 *     &lt;ref label="mi"/&gt;
 *     &lt;ref label="mn"/&gt;
 *     &lt;ref label="mo"/&gt;
 *     &lt;ref label="mtext"/&gt;
 *     &lt;ref label="ms"/&gt;
 *     &lt;ref label="mspace"/&gt;
 *     &lt;ref label="mprescripts"/&gt;
 *     &lt;ref label="none"/&gt;
 *     &lt;ref label="mrow"/&gt;
 *     &lt;ref label="mfrac"/&gt;
 *     &lt;ref label="msqrt"/&gt;
 *     &lt;ref label="mroot"/&gt;
 *     &lt;ref label="mstyle"/&gt;
 *     &lt;ref label="merror"/&gt;
 *     &lt;ref label="mpadded"/&gt;
 *     &lt;ref label="mphantom"/&gt;
 *     &lt;ref label="mfenced"/&gt;
 *     &lt;ref label="msub"/&gt;
 *     &lt;ref label="msup"/&gt;
 *     &lt;ref label="msubsup"/&gt;
 *     &lt;ref label="munder"/&gt;
 *     &lt;ref label="mover"/&gt;
 *     &lt;ref label="munderover"/&gt;
 *     &lt;ref label="mmultiscripts"/&gt;
 *     &lt;ref label="mtable"/&gt;
 *     &lt;ref label="mtr"/&gt;
 *     &lt;ref label="mtd"/&gt;
 *     &lt;ref label="maligngroup"/&gt;
 *     &lt;ref label="malignmark"/&gt;
 *     &lt;ref label="maction"/&gt;
 *     &lt;ref label="ci"/&gt;
 *     &lt;ref label="cn"/&gt;
 *     &lt;ref label="apply"/&gt;
 *     &lt;ref label="fn"/&gt;
 *     &lt;ref label="lambda"/&gt;
 *     &lt;ref label="reln"/&gt;
 *     &lt;ref label="interval"/&gt;
 *     &lt;ref label="list"/&gt;
 *     &lt;ref label="matrix"/&gt;
 *     &lt;ref label="matrixrow"/&gt;
 *     &lt;ref label="set"/&gt;
 *     &lt;ref label="vector"/&gt;
 *     &lt;ref label="semantics"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="mtable"&gt;
 *   &lt;attribute name="align" type="string"/&gt;
 *   &lt;attribute name="rowalign" type="string"/&gt;
 *   &lt;attribute name="columnalign" type="string"/&gt;
 *   &lt;attribute name="groupalign" type="string"/&gt;
 *   &lt;attribute name="alignmentscope" type="string"/&gt;
 *   &lt;attribute name="rowspacing" type="string"/&gt;
 *   &lt;attribute name="columnspacing" type="string"/&gt;
 *   &lt;attribute name="rowlines" type="string"/&gt;
 *   &lt;attribute name="columnlines" type="string"/&gt;
 *   &lt;attribute name="frame" type="NMTOKEN"&gt;
 *     &lt;enumeration value="none"/&gt;
 *     &lt;enumeration value="solid"/&gt;
 *     &lt;enumeration value="dashed"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="framespacing" type="string"/&gt;
 *   &lt;attribute name="equalrows" type="string"/&gt;
 *   &lt;attribute name="equalcolumns" type="string"/&gt;
 *   &lt;attribute name="displaystyle" type="NMTOKEN"&gt;
 *     &lt;enumeration value="true"/&gt;
 *     &lt;enumeration value="false"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="class" type="string"/&gt;
 *   &lt;attribute name="style" type="string"/&gt;
 *   &lt;attribute name="id" type="ID"/&gt;
 *   &lt;attribute name="other" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version MathML.rlx 1.0 (Sat Sep 09 10:48:42 JST 2000)
 * @author  Relaxer 0.11b (by ASAMI@Yokohama)
 */
public class MMtable implements java.io.Serializable, IMMtableContent, IMMtrContent, IMMtdContent, IMMactionContent, IMCiPCDATA, IMCnPCDATA, IMFnContent, IMLogbaseContent, IMDegreeContent, IMBvarContent, IMUplimitContent, IMLowlimitContent, IMVectorContent, IMSetContent, IMMatrixrowContent, IMMatrixContent, IMListContent, IMIntervalContent, IMAnnotationXmlContent, IMSemanticsContent, IMDeclareContent, IMConditionContent, IMLambdaContent, IMRelnContent, IMApplyContent, IRVisitable, IRNode, IMMmultiscriptsContent, IMMunderoverContent, IMMoverContent, IMMunderContent, IMMsubsupContent, IMMsupContent, IMMsubContent, IMMfencedContent, IMMphantomContent, IMMpaddedContent, IMMerrorContent, IMMstyleContent, IMMrootContent, IMMsqrtContent, IMMfracContent, IMMrowContent, IMMathContent {
    private String align;
    private String rowalign;
    private String columnalign;
    private String groupalign;
    private String alignmentscope;
    private String rowspacing;
    private String columnspacing;
    private String rowlines;
    private String columnlines;
    private String frame;
    private String framespacing;
    private String equalrows;
    private String equalcolumns;
    private String displaystyle;
    private String classValue;
    private String style;
    private String id;
    private String other;
    // List<IMMtableContent>
    private java.util.List content = new java.util.ArrayList();
    private IRNode parentRNode;

    /**
     * Creates a <code>MMtable</code>.
     *
     */
    public MMtable() {
    }

    /**
     * Creates a <code>MMtable</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public MMtable(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>MMtable</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public MMtable(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>MMtable</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public MMtable(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>MMtable</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>MMtable</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>MMtable</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        align = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "align");
        rowalign = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "rowalign");
        columnalign = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "columnalign");
        groupalign = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "groupalign");
        alignmentscope = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "alignmentscope");
        rowspacing = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "rowspacing");
        columnspacing = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "columnspacing");
        rowlines = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "rowlines");
        columnlines = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "columnlines");
        frame = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "frame");
        framespacing = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "framespacing");
        equalrows = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "equalrows");
        equalcolumns = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "equalcolumns");
        displaystyle = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "displaystyle");
        classValue = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "class");
        style = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "style");
        id = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "id");
        other = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "other");
        content.clear();
        while (!stack.isEmptyElement()) {
            if (MMi.isMatch(stack)) {
                addContent(new MMi(stack));
            } else if (MMn.isMatch(stack)) {
                addContent(new MMn(stack));
            } else if (MMo.isMatch(stack)) {
                addContent(new MMo(stack));
            } else if (MMtext.isMatch(stack)) {
                addContent(new MMtext(stack));
            } else if (MMs.isMatch(stack)) {
                addContent(new MMs(stack));
            } else if (MMspace.isMatch(stack)) {
                addContent(new MMspace(stack));
            } else if (MMprescripts.isMatch(stack)) {
                addContent(new MMprescripts(stack));
            } else if (MNone.isMatch(stack)) {
                addContent(new MNone(stack));
            } else if (MMrow.isMatch(stack)) {
                addContent(new MMrow(stack));
            } else if (MMfrac.isMatch(stack)) {
                addContent(new MMfrac(stack));
            } else if (MMsqrt.isMatch(stack)) {
                addContent(new MMsqrt(stack));
            } else if (MMroot.isMatch(stack)) {
                addContent(new MMroot(stack));
            } else if (MMstyle.isMatch(stack)) {
                addContent(new MMstyle(stack));
            } else if (MMerror.isMatch(stack)) {
                addContent(new MMerror(stack));
            } else if (MMpadded.isMatch(stack)) {
                addContent(new MMpadded(stack));
            } else if (MMphantom.isMatch(stack)) {
                addContent(new MMphantom(stack));
            } else if (MMfenced.isMatch(stack)) {
                addContent(new MMfenced(stack));
            } else if (MMsub.isMatch(stack)) {
                addContent(new MMsub(stack));
            } else if (MMsup.isMatch(stack)) {
                addContent(new MMsup(stack));
            } else if (MMsubsup.isMatch(stack)) {
                addContent(new MMsubsup(stack));
            } else if (MMunder.isMatch(stack)) {
                addContent(new MMunder(stack));
            } else if (MMover.isMatch(stack)) {
                addContent(new MMover(stack));
            } else if (MMunderover.isMatch(stack)) {
                addContent(new MMunderover(stack));
            } else if (MMmultiscripts.isMatch(stack)) {
                addContent(new MMmultiscripts(stack));
            } else if (MMtable.isMatch(stack)) {
                addContent(new MMtable(stack));
            } else if (MMtr.isMatch(stack)) {
                addContent(new MMtr(stack));
            } else if (MMtd.isMatch(stack)) {
                addContent(new MMtd(stack));
            } else if (MMaligngroup.isMatch(stack)) {
                addContent(new MMaligngroup(stack));
            } else if (MMalignmark.isMatch(stack)) {
                addContent(new MMalignmark(stack));
            } else if (MMaction.isMatch(stack)) {
                addContent(new MMaction(stack));
            } else if (MCi.isMatch(stack)) {
                addContent(new MCi(stack));
            } else if (MCn.isMatch(stack)) {
                addContent(new MCn(stack));
            } else if (MApply.isMatch(stack)) {
                addContent(new MApply(stack));
            } else if (MFn.isMatch(stack)) {
                addContent(new MFn(stack));
            } else if (MLambda.isMatch(stack)) {
                addContent(new MLambda(stack));
            } else if (MReln.isMatch(stack)) {
                addContent(new MReln(stack));
            } else if (MInterval.isMatch(stack)) {
                addContent(new MInterval(stack));
            } else if (MList.isMatch(stack)) {
                addContent(new MList(stack));
            } else if (MMatrix.isMatch(stack)) {
                addContent(new MMatrix(stack));
            } else if (MMatrixrow.isMatch(stack)) {
                addContent(new MMatrixrow(stack));
            } else if (MSet.isMatch(stack)) {
                addContent(new MSet(stack));
            } else if (MVector.isMatch(stack)) {
                addContent(new MVector(stack));
            } else if (MSemantics.isMatch(stack)) {
                addContent(new MSemantics(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("mtable");
        int size;
        if (align != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "align", align);
        }
        if (rowalign != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "rowalign", rowalign);
        }
        if (columnalign != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "columnalign", columnalign);
        }
        if (groupalign != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "groupalign", groupalign);
        }
        if (alignmentscope != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "alignmentscope", alignmentscope);
        }
        if (rowspacing != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "rowspacing", rowspacing);
        }
        if (columnspacing != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "columnspacing", columnspacing);
        }
        if (rowlines != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "rowlines", rowlines);
        }
        if (columnlines != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "columnlines", columnlines);
        }
        if (frame != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "frame", frame);
        }
        if (framespacing != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "framespacing", framespacing);
        }
        if (equalrows != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "equalrows", equalrows);
        }
        if (equalcolumns != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "equalcolumns", equalcolumns);
        }
        if (displaystyle != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "displaystyle", displaystyle);
        }
        if (classValue != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "class", classValue);
        }
        if (style != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "style", style);
        }
        if (id != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "id", id);
        }
        if (other != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "other", other);
        }
        size = content.size();
        for (int i = 0;i < size;i++) {
            IMMtableContent value = (IMMtableContent)this.content.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>align</b>.
     *
     * @return String
     */
    public final String getAlign() {
        return (align);
    }

    /**
     * Sets the String property <b>align</b>.
     *
     * @param align
     */
    public final void setAlign(String align) {
        this.align = align;
    }

    /**
     * Gets the String property <b>rowalign</b>.
     *
     * @return String
     */
    public final String getRowalign() {
        return (rowalign);
    }

    /**
     * Sets the String property <b>rowalign</b>.
     *
     * @param rowalign
     */
    public final void setRowalign(String rowalign) {
        this.rowalign = rowalign;
    }

    /**
     * Gets the String property <b>columnalign</b>.
     *
     * @return String
     */
    public final String getColumnalign() {
        return (columnalign);
    }

    /**
     * Sets the String property <b>columnalign</b>.
     *
     * @param columnalign
     */
    public final void setColumnalign(String columnalign) {
        this.columnalign = columnalign;
    }

    /**
     * Gets the String property <b>groupalign</b>.
     *
     * @return String
     */
    public final String getGroupalign() {
        return (groupalign);
    }

    /**
     * Sets the String property <b>groupalign</b>.
     *
     * @param groupalign
     */
    public final void setGroupalign(String groupalign) {
        this.groupalign = groupalign;
    }

    /**
     * Gets the String property <b>alignmentscope</b>.
     *
     * @return String
     */
    public final String getAlignmentscope() {
        return (alignmentscope);
    }

    /**
     * Sets the String property <b>alignmentscope</b>.
     *
     * @param alignmentscope
     */
    public final void setAlignmentscope(String alignmentscope) {
        this.alignmentscope = alignmentscope;
    }

    /**
     * Gets the String property <b>rowspacing</b>.
     *
     * @return String
     */
    public final String getRowspacing() {
        return (rowspacing);
    }

    /**
     * Sets the String property <b>rowspacing</b>.
     *
     * @param rowspacing
     */
    public final void setRowspacing(String rowspacing) {
        this.rowspacing = rowspacing;
    }

    /**
     * Gets the String property <b>columnspacing</b>.
     *
     * @return String
     */
    public final String getColumnspacing() {
        return (columnspacing);
    }

    /**
     * Sets the String property <b>columnspacing</b>.
     *
     * @param columnspacing
     */
    public final void setColumnspacing(String columnspacing) {
        this.columnspacing = columnspacing;
    }

    /**
     * Gets the String property <b>rowlines</b>.
     *
     * @return String
     */
    public final String getRowlines() {
        return (rowlines);
    }

    /**
     * Sets the String property <b>rowlines</b>.
     *
     * @param rowlines
     */
    public final void setRowlines(String rowlines) {
        this.rowlines = rowlines;
    }

    /**
     * Gets the String property <b>columnlines</b>.
     *
     * @return String
     */
    public final String getColumnlines() {
        return (columnlines);
    }

    /**
     * Sets the String property <b>columnlines</b>.
     *
     * @param columnlines
     */
    public final void setColumnlines(String columnlines) {
        this.columnlines = columnlines;
    }

    /**
     * Gets the String property <b>frame</b>.
     *
     * @return String
     */
    public final String getFrame() {
        return (frame);
    }

    /**
     * Sets the String property <b>frame</b>.
     *
     * @param frame
     */
    public final void setFrame(String frame) {
        this.frame = frame;
    }

    /**
     * Gets the String property <b>framespacing</b>.
     *
     * @return String
     */
    public final String getFramespacing() {
        return (framespacing);
    }

    /**
     * Sets the String property <b>framespacing</b>.
     *
     * @param framespacing
     */
    public final void setFramespacing(String framespacing) {
        this.framespacing = framespacing;
    }

    /**
     * Gets the String property <b>equalrows</b>.
     *
     * @return String
     */
    public final String getEqualrows() {
        return (equalrows);
    }

    /**
     * Sets the String property <b>equalrows</b>.
     *
     * @param equalrows
     */
    public final void setEqualrows(String equalrows) {
        this.equalrows = equalrows;
    }

    /**
     * Gets the String property <b>equalcolumns</b>.
     *
     * @return String
     */
    public final String getEqualcolumns() {
        return (equalcolumns);
    }

    /**
     * Sets the String property <b>equalcolumns</b>.
     *
     * @param equalcolumns
     */
    public final void setEqualcolumns(String equalcolumns) {
        this.equalcolumns = equalcolumns;
    }

    /**
     * Gets the String property <b>displaystyle</b>.
     *
     * @return String
     */
    public final String getDisplaystyle() {
        return (displaystyle);
    }

    /**
     * Sets the String property <b>displaystyle</b>.
     *
     * @param displaystyle
     */
    public final void setDisplaystyle(String displaystyle) {
        this.displaystyle = displaystyle;
    }

    /**
     * Gets the String property <b>classValue</b>.
     *
     * @return String
     */
    public final String getClassValue() {
        return (classValue);
    }

    /**
     * Sets the String property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(String classValue) {
        this.classValue = classValue;
    }

    /**
     * Gets the String property <b>style</b>.
     *
     * @return String
     */
    public final String getStyle() {
        return (style);
    }

    /**
     * Sets the String property <b>style</b>.
     *
     * @param style
     */
    public final void setStyle(String style) {
        this.style = style;
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id = id;
    }

    /**
     * Gets the String property <b>other</b>.
     *
     * @return String
     */
    public final String getOther() {
        return (other);
    }

    /**
     * Sets the String property <b>other</b>.
     *
     * @param other
     */
    public final void setOther(String other) {
        this.other = other;
    }

    /**
     * Gets the IMMtableContent property <b>content</b>.
     *
     * @return IMMtableContent[]
     */
    public final IMMtableContent[] getContent() {
        IMMtableContent[] array = new IMMtableContent[content.size()];
        return ((IMMtableContent[])content.toArray(array));
    }

    /**
     * Sets the IMMtableContent property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IMMtableContent[] content) {
        this.content.clear();
        this.content.addAll(java.util.Arrays.asList(content));
        for (int i = 0;i < content.length;i++) {
            content[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IMMtableContent property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IMMtableContent content) {
        this.content.clear();
        this.content.add(content);
        content.setParentRNode(this);
    }

    /**
     * Adds the IMMtableContent property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IMMtableContent content) {
        this.content.add(content);
        content.setParentRNode(this);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     */
    public void enter(IRVisitor visitor) {
        visitor.enter(this);
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>MMtable</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://www.w3.org/1998/Math/MathML", "mtable")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (MMi.isMatchHungry(target)) {
            } else if (MMn.isMatchHungry(target)) {
            } else if (MMo.isMatchHungry(target)) {
            } else if (MMtext.isMatchHungry(target)) {
            } else if (MMs.isMatchHungry(target)) {
            } else if (MMspace.isMatchHungry(target)) {
            } else if (MMprescripts.isMatchHungry(target)) {
            } else if (MNone.isMatchHungry(target)) {
            } else if (MMrow.isMatchHungry(target)) {
            } else if (MMfrac.isMatchHungry(target)) {
            } else if (MMsqrt.isMatchHungry(target)) {
            } else if (MMroot.isMatchHungry(target)) {
            } else if (MMstyle.isMatchHungry(target)) {
            } else if (MMerror.isMatchHungry(target)) {
            } else if (MMpadded.isMatchHungry(target)) {
            } else if (MMphantom.isMatchHungry(target)) {
            } else if (MMfenced.isMatchHungry(target)) {
            } else if (MMsub.isMatchHungry(target)) {
            } else if (MMsup.isMatchHungry(target)) {
            } else if (MMsubsup.isMatchHungry(target)) {
            } else if (MMunder.isMatchHungry(target)) {
            } else if (MMover.isMatchHungry(target)) {
            } else if (MMunderover.isMatchHungry(target)) {
            } else if (MMmultiscripts.isMatchHungry(target)) {
            } else if (MMtable.isMatchHungry(target)) {
            } else if (MMtr.isMatchHungry(target)) {
            } else if (MMtd.isMatchHungry(target)) {
            } else if (MMaligngroup.isMatchHungry(target)) {
            } else if (MMalignmark.isMatchHungry(target)) {
            } else if (MMaction.isMatchHungry(target)) {
            } else if (MCi.isMatchHungry(target)) {
            } else if (MCn.isMatchHungry(target)) {
            } else if (MApply.isMatchHungry(target)) {
            } else if (MFn.isMatchHungry(target)) {
            } else if (MLambda.isMatchHungry(target)) {
            } else if (MReln.isMatchHungry(target)) {
            } else if (MInterval.isMatchHungry(target)) {
            } else if (MList.isMatchHungry(target)) {
            } else if (MMatrix.isMatchHungry(target)) {
            } else if (MMatrixrow.isMatchHungry(target)) {
            } else if (MSet.isMatchHungry(target)) {
            } else if (MVector.isMatchHungry(target)) {
            } else if (MSemantics.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MMtable</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MMtable</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
