package jp.gr.java_conf.jaba2.xml.mathml.relaxer;

import org.w3c.dom.*;

/**
 * <b>MCi</b> is generated by Relaxer based on MathML.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="ci">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="mi"/>
 *       <ref label="mn"/>
 *       <ref label="mo"/>
 *       <ref label="mtext"/>
 *       <ref label="ms"/>
 *       <ref label="mspace"/>
 *       <ref label="mrow"/>
 *       <ref label="mfrac"/>
 *       <ref label="msqrt"/>
 *       <ref label="mroot"/>
 *       <ref label="mstyle"/>
 *       <ref label="merror"/>
 *       <ref label="mpadded"/>
 *       <ref label="mphantom"/>
 *       <ref label="mfenced"/>
 *       <ref label="msub"/>
 *       <ref label="msup"/>
 *       <ref label="msubsup"/>
 *       <ref label="munder"/>
 *       <ref label="mover"/>
 *       <ref label="munderover"/>
 *       <ref label="mmultiscripts"/>
 *       <ref label="mtable"/>
 *       <ref label="mtr"/>
 *       <ref label="mtd"/>
 *       <ref label="maligngroup"/>
 *       <ref label="malignmark"/>
 *       <ref label="maction"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="ci">
 *   <attribute name="type" type="string"/>
 *   <attribute name="class" type="string"/>
 *   <attribute name="style" type="string"/>
 *   <attribute name="id" type="ID"/>
 *   <attribute name="other" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="ci"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="mi"/&gt;
 *       &lt;ref label="mn"/&gt;
 *       &lt;ref label="mo"/&gt;
 *       &lt;ref label="mtext"/&gt;
 *       &lt;ref label="ms"/&gt;
 *       &lt;ref label="mspace"/&gt;
 *       &lt;ref label="mrow"/&gt;
 *       &lt;ref label="mfrac"/&gt;
 *       &lt;ref label="msqrt"/&gt;
 *       &lt;ref label="mroot"/&gt;
 *       &lt;ref label="mstyle"/&gt;
 *       &lt;ref label="merror"/&gt;
 *       &lt;ref label="mpadded"/&gt;
 *       &lt;ref label="mphantom"/&gt;
 *       &lt;ref label="mfenced"/&gt;
 *       &lt;ref label="msub"/&gt;
 *       &lt;ref label="msup"/&gt;
 *       &lt;ref label="msubsup"/&gt;
 *       &lt;ref label="munder"/&gt;
 *       &lt;ref label="mover"/&gt;
 *       &lt;ref label="munderover"/&gt;
 *       &lt;ref label="mmultiscripts"/&gt;
 *       &lt;ref label="mtable"/&gt;
 *       &lt;ref label="mtr"/&gt;
 *       &lt;ref label="mtd"/&gt;
 *       &lt;ref label="maligngroup"/&gt;
 *       &lt;ref label="malignmark"/&gt;
 *       &lt;ref label="maction"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="ci"&gt;
 *   &lt;attribute name="type" type="string"/&gt;
 *   &lt;attribute name="class" type="string"/&gt;
 *   &lt;attribute name="style" type="string"/&gt;
 *   &lt;attribute name="id" type="ID"/&gt;
 *   &lt;attribute name="other" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version MathML.rlx 1.0 (Sat Sep 09 10:48:43 JST 2000)
 * @author  Relaxer 0.11b (by ASAMI@Yokohama)
 */
public class MCi implements java.io.Serializable, IRVisitable, IRNode, IMMactionContent, IMApplyContent, IMRelnContent, IMLambdaContent, IMConditionContent, IMDeclareContent, IMSemanticsContent, IMAnnotationXmlContent, IMIntervalContent, IMListContent, IMMatrixContent, IMMatrixrowContent, IMSetContent, IMVectorContent, IMLowlimitContent, IMUplimitContent, IMBvarContent, IMDegreeContent, IMLogbaseContent, IMFnContent, IMMtdContent, IMMtrContent, IMMtableContent, IMMmultiscriptsContent, IMMunderoverContent, IMMoverContent, IMMunderContent, IMMsubsupContent, IMMsupContent, IMMsubContent, IMMfencedContent, IMMphantomContent, IMMpaddedContent, IMMerrorContent, IMMstyleContent, IMMrootContent, IMMsqrtContent, IMMfracContent, IMMrowContent, IMMathContent {
    private String type;
    private String classValue;
    private String style;
    private String id;
    private String other;
    // List<IMCiPCDATA>
    private java.util.List pcdata = new java.util.ArrayList();
    private IRNode parentRNode;

    /**
     * Creates a <code>MCi</code>.
     *
     */
    public MCi() {
    }

    /**
     * Creates a <code>MCi</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public MCi(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>MCi</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public MCi(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>MCi</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public MCi(Element element) {
        setup(element);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setPcdata(String text) {
        setPcdata(new RString(text));
    }

    /**
     * Gets a mixed content as <code>String</code>.
     *
     * @return String
     */
    public String getPcdataAsString() {
        return (URelaxer.getStringByMixedList(pcdata));
    }

    /**
     * Initializes the <code>MCi</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>MCi</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>MCi</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        type = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "type");
        classValue = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "class");
        style = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "style");
        id = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "id");
        other = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "other");
        pcdata.clear();
        while (!stack.isEmpty()) {
            if (RString.isMatch(stack)) {
                addPcdata(new RString(stack));
            } else if (MMi.isMatch(stack)) {
                addPcdata(new MMi(stack));
            } else if (MMn.isMatch(stack)) {
                addPcdata(new MMn(stack));
            } else if (MMo.isMatch(stack)) {
                addPcdata(new MMo(stack));
            } else if (MMtext.isMatch(stack)) {
                addPcdata(new MMtext(stack));
            } else if (MMs.isMatch(stack)) {
                addPcdata(new MMs(stack));
            } else if (MMspace.isMatch(stack)) {
                addPcdata(new MMspace(stack));
            } else if (MMrow.isMatch(stack)) {
                addPcdata(new MMrow(stack));
            } else if (MMfrac.isMatch(stack)) {
                addPcdata(new MMfrac(stack));
            } else if (MMsqrt.isMatch(stack)) {
                addPcdata(new MMsqrt(stack));
            } else if (MMroot.isMatch(stack)) {
                addPcdata(new MMroot(stack));
            } else if (MMstyle.isMatch(stack)) {
                addPcdata(new MMstyle(stack));
            } else if (MMerror.isMatch(stack)) {
                addPcdata(new MMerror(stack));
            } else if (MMpadded.isMatch(stack)) {
                addPcdata(new MMpadded(stack));
            } else if (MMphantom.isMatch(stack)) {
                addPcdata(new MMphantom(stack));
            } else if (MMfenced.isMatch(stack)) {
                addPcdata(new MMfenced(stack));
            } else if (MMsub.isMatch(stack)) {
                addPcdata(new MMsub(stack));
            } else if (MMsup.isMatch(stack)) {
                addPcdata(new MMsup(stack));
            } else if (MMsubsup.isMatch(stack)) {
                addPcdata(new MMsubsup(stack));
            } else if (MMunder.isMatch(stack)) {
                addPcdata(new MMunder(stack));
            } else if (MMover.isMatch(stack)) {
                addPcdata(new MMover(stack));
            } else if (MMunderover.isMatch(stack)) {
                addPcdata(new MMunderover(stack));
            } else if (MMmultiscripts.isMatch(stack)) {
                addPcdata(new MMmultiscripts(stack));
            } else if (MMtable.isMatch(stack)) {
                addPcdata(new MMtable(stack));
            } else if (MMtr.isMatch(stack)) {
                addPcdata(new MMtr(stack));
            } else if (MMtd.isMatch(stack)) {
                addPcdata(new MMtd(stack));
            } else if (MMaligngroup.isMatch(stack)) {
                addPcdata(new MMaligngroup(stack));
            } else if (MMalignmark.isMatch(stack)) {
                addPcdata(new MMalignmark(stack));
            } else if (MMaction.isMatch(stack)) {
                addPcdata(new MMaction(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("ci");
        int size;
        if (type != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "type", type);
        }
        if (classValue != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "class", classValue);
        }
        if (style != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "style", style);
        }
        if (id != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "id", id);
        }
        if (other != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "other", other);
        }
        size = pcdata.size();
        for (int i = 0;i < size;i++) {
            IMCiPCDATA value = (IMCiPCDATA)this.pcdata.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type = type;
    }

    /**
     * Gets the String property <b>classValue</b>.
     *
     * @return String
     */
    public final String getClassValue() {
        return (classValue);
    }

    /**
     * Sets the String property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(String classValue) {
        this.classValue = classValue;
    }

    /**
     * Gets the String property <b>style</b>.
     *
     * @return String
     */
    public final String getStyle() {
        return (style);
    }

    /**
     * Sets the String property <b>style</b>.
     *
     * @param style
     */
    public final void setStyle(String style) {
        this.style = style;
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id = id;
    }

    /**
     * Gets the String property <b>other</b>.
     *
     * @return String
     */
    public final String getOther() {
        return (other);
    }

    /**
     * Sets the String property <b>other</b>.
     *
     * @param other
     */
    public final void setOther(String other) {
        this.other = other;
    }

    /**
     * Gets the IMCiPCDATA property <b>pcdata</b>.
     *
     * @return IMCiPCDATA[]
     */
    public final IMCiPCDATA[] getPcdata() {
        IMCiPCDATA[] array = new IMCiPCDATA[pcdata.size()];
        return ((IMCiPCDATA[])pcdata.toArray(array));
    }

    /**
     * Sets the IMCiPCDATA property <b>pcdata</b>.
     *
     * @param pcdata
     */
    public final void setPcdata(IMCiPCDATA[] pcdata) {
        this.pcdata.clear();
        this.pcdata.addAll(java.util.Arrays.asList(pcdata));
        for (int i = 0;i < pcdata.length;i++) {
            pcdata[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IMCiPCDATA property <b>pcdata</b>.
     *
     * @param pcdata
     */
    public final void setPcdata(IMCiPCDATA pcdata) {
        this.pcdata.clear();
        this.pcdata.add(pcdata);
        pcdata.setParentRNode(this);
    }

    /**
     * Adds the IMCiPCDATA property <b>pcdata</b>.
     *
     * @param pcdata
     */
    public final void addPcdata(IMCiPCDATA pcdata) {
        this.pcdata.add(pcdata);
        pcdata.setParentRNode(this);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     */
    public void enter(IRVisitor visitor) {
        visitor.enter(this);
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(pcdata);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>MCi</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://www.w3.org/1998/Math/MathML", "ci")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (MMi.isMatchHungry(target)) {
            } else if (MMn.isMatchHungry(target)) {
            } else if (MMo.isMatchHungry(target)) {
            } else if (MMtext.isMatchHungry(target)) {
            } else if (MMs.isMatchHungry(target)) {
            } else if (MMspace.isMatchHungry(target)) {
            } else if (MMrow.isMatchHungry(target)) {
            } else if (MMfrac.isMatchHungry(target)) {
            } else if (MMsqrt.isMatchHungry(target)) {
            } else if (MMroot.isMatchHungry(target)) {
            } else if (MMstyle.isMatchHungry(target)) {
            } else if (MMerror.isMatchHungry(target)) {
            } else if (MMpadded.isMatchHungry(target)) {
            } else if (MMphantom.isMatchHungry(target)) {
            } else if (MMfenced.isMatchHungry(target)) {
            } else if (MMsub.isMatchHungry(target)) {
            } else if (MMsup.isMatchHungry(target)) {
            } else if (MMsubsup.isMatchHungry(target)) {
            } else if (MMunder.isMatchHungry(target)) {
            } else if (MMover.isMatchHungry(target)) {
            } else if (MMunderover.isMatchHungry(target)) {
            } else if (MMmultiscripts.isMatchHungry(target)) {
            } else if (MMtable.isMatchHungry(target)) {
            } else if (MMtr.isMatchHungry(target)) {
            } else if (MMtd.isMatchHungry(target)) {
            } else if (MMaligngroup.isMatchHungry(target)) {
            } else if (MMalignmark.isMatchHungry(target)) {
            } else if (MMaction.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MCi</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MCi</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
