/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * DFloat
 *
 * @since   Feb. 23, 2000
 * @version Dec. 13, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DFloat extends Datatype {
    // facets
    private Float maxInclusive_;
    private Float maxExclusive_;
    private Float minInclusive_;
    private Float minExclusive_;
    private Float[] enumeration_;

    public DFloat() {
    }

    public DFloat(Element element) {
	setup(element);
    }

    public void setup(Element element) {
	SmartElement sm = new SmartElement(element);
	maxInclusive_
	    = sm.getAttributeOfOnlyElementAsFloat("maxInclusive", "value");
	maxExclusive_
	    = sm.getAttributeOfOnlyElementAsFloat("maxExclusive", "value");
	minInclusive_
	    = sm.getAttributeOfOnlyElementAsFloat("minInclusive", "value");
	minExclusive_
	    = sm.getAttributeOfOnlyElementAsFloat("minExclusive", "value");
	// XXX : enumeration_
    }

    public String getName() {
	return ("float");
    }

    public final Float getMaxInclusive() {
	return (maxInclusive_);
    }

    public final Float getMaxExclusive() {
	return (maxExclusive_);
    }

    public final Float getMinInclusive() {
	return (minInclusive_);
    }

    public final Float getMinExclusive() {
	return (minExclusive_);
    }

    public final Float[] getEnumeration() {
	return (enumeration_);
    }

    public Object makeObject(String cdata) {
	return (Float.valueOf(cdata));
    }
}
