package jp.gr.java_conf.jaba2.xml;

import java.io.Serializable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.util.AbstractTreeModel;

/**
 * XMLTreeModel
 * 
 * @since   Sep. 10, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class XMLTreeModel extends AbstractTreeModel{
    protected Document doc_;

    public XMLTreeModel(Document doc) {
	doc_ = doc;
    }

    // TreeModel
    public Object getRoot() {
	return (doc_.getDocumentElement());
    }

    // TreeModel
    public Object getChild(Object parent, int index) {
	Node node = (Node)parent;
	NodeList nodes = node.getChildNodes();
	return (nodes.item(index));
    }

    // TreeModel
    public int getChildCount(Object parent) {
	Node node = (Node)parent;
	NodeList nodes = node.getChildNodes();
	return (nodes.getLength());
    }

    public boolean isLeaf(Object node) {
	switch (((Node)node).getNodeType()) {

	case Node.COMMENT_NODE:
	case Node.TEXT_NODE:
	    return (true);
	default:
	    return (false);
	}
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
	// XXX
    }

    public int getIndexOfChild(Object parent, Object child) {
	Node node = (Node)parent;
	NodeList nodes = node.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    if (nodes.item(i).equals(child)) {
		return (i);
	    }
	}
	return (-1);
    }
}

