/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package jp.gr.java_conf.jaba2.xml;

import java.util.*;
import java.io.*;
import java.text.*;
import java.net.URL;
import org.w3c.dom.*;
//import com.ibm.xml.parser.*;
import jp.gr.java_conf.jaba2.util.PropertyList;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * UXML
 *
 * @since   Jul.  1, 1998
 * @version Mar.  2, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class UXML {
/*
    public static Document makeDoc(File file) throws IOException {
	URL url = UURL.getURLFromFile(file);
	Parser parser = new Parser(url.toExternalForm());
	return (parser.readStream(url.openStream()));
    }

    public static Document makeDoc(URL url) throws IOException {
	Parser parser = new Parser(url.toExternalForm());
	return (parser.readStream(url.openStream()));
    }

    public static DocumentType makeDTD(URL url) throws IOException {
	Parser parser = new Parser(url.toExternalForm());
	return (parser.readDTDStream(url.openStream()));
    }

    public static Document makeDoc(String text) {
	Parser parser = new Parser("text");
	return (parser.readStream(new StringBufferInputStream(text)));
    }

    public static DocumentType makeDTD(String text) {
	try {
	    Parser parser = new Parser("text");
	    DocumentType dtd = parser.readDTDStream(
		new StringBufferInputStream(text)
	    );
	    return (dtd);
	} catch (IOException e) {
	    throw (new InternalError(e.getMessage()));
	}
    }
*/

    public static String doc2String4Print(Document doc) {
	StringBuffer buffer = new StringBuffer();
	Element element = doc.getDocumentElement();
	buffer.append("<?xml version='1.0' ?>\n");
	_node2String4Print(element, "", buffer);
	return (new String(buffer));
    }

    public static String doc2String4Print(Document doc, String encoding) {
	StringBuffer buffer = new StringBuffer();
	Element element = doc.getDocumentElement();
	buffer.append("<?xml version='1.0' encoding='");
	buffer.append(encoding);
	buffer.append("' ?>\n");
	_node2String4Print(element, "", buffer);
	return (new String(buffer));
    }

    public static String node2String4Print(Node node, String encoding) {
	StringBuffer buffer = new StringBuffer();
	buffer.append("<?xml version='1.0' encoding='");
	buffer.append(encoding);
	buffer.append("' ?>\n");
	_node2String4Print(node, "", buffer);
	return (new String(buffer));
    }

    public static String node2String4Print(Node node) {
	return (_node2String4Print(node, ""));
    }

    protected static String _node2String4Print(Node node, String indent) {
	StringBuffer buffer = new StringBuffer();
	_node2String4Print(node, indent, buffer);
	return (new String(buffer));
    }

    protected static void _node2String4Print(
	Node node,
	String indent,
	StringBuffer buffer
    ) {
	switch(node.getNodeType()) {

	case Node.ELEMENT_NODE: {
	    Element element = (Element)node;
	    String tag = element.getTagName();
	    buffer.append(indent);
	    buffer.append("<");
	    buffer.append(tag);
	    NamedNodeMap attrs = element.getAttributes();
	    int nAttrs = attrs.getLength();
	    for (int i = 0;i < nAttrs;i++) {
		Attr attr = (Attr)attrs.item(i);
		buffer.append(' ');
		buffer.append(attr.getName());
		buffer.append("=\"");
		buffer.append(attr.getValue());
		buffer.append('\"');
	    }
	    buffer.append(">");
	    boolean needIndent = hasChildElement(element);
	    if (needIndent) {
		buffer.append("\n");
	    }
	    NodeList nodes = element.getChildNodes();
	    int nNodes = nodes.getLength();
	    for (int i = 0;i < nNodes;i++) {
		Node child = nodes.item(i);
		if (child.getNodeType() == Node.TEXT_NODE) {
		    // XXX : xml:space
		    Text text = (Text)child;
		    if (!isBlankText(text)) {
			buffer.append(text.getData());
		    }
		} else {
		    _node2String4Print(child, indent + "  ", buffer);
		}
	    }
	    if (needIndent) {
		buffer.append(indent);
	    }
	    buffer.append("</" + tag + ">\n");
	    break;
	}
	case Node.ATTRIBUTE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.TEXT_NODE:
	    Text text = (Text)node;
	    buffer.append(text.getData());
	    break;
	case Node.CDATA_SECTION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.ENTITY_REFERENCE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.PROCESSING_INSTRUCTION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.COMMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_NODE: {
	    NodeList nodes = node.getChildNodes();
	    int nNodes = nodes.getLength();
	    for (int i = 0;i < nNodes;i++) {
		_node2String4Print(nodes.item(i), indent, buffer);
	    }
	    break;
	}
	case Node.DOCUMENT_TYPE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_FRAGMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.NOTATION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	default:
	    throw (new UnsupportedOperationException("not supported yet"));
	}
    }

    /**
     * @deprecated
     * @see doc2String4Data
     */
    public static String XML2String4Data(Document doc) {
	StringBuffer buffer = new StringBuffer();
	Element element = doc.getDocumentElement();
	buffer.append("<?xml version='1.0' ?>");
	_node2String4Data(element, buffer);
	return (new String(buffer));
    }

    public static String doc2String4Data(Document doc) {
	StringBuffer buffer = new StringBuffer();
	Element element = doc.getDocumentElement();
	buffer.append("<?xml version='1.0' ?>");
	_node2String4Data(element, buffer);
	return (new String(buffer));
    }

    public static String node2String4Data(Node node) {
	StringBuffer buffer = new StringBuffer();
	_node2String4Data(node, buffer);
	return (new String(buffer));
    }

    private static void _node2String4Data(Node node, StringBuffer buffer) {
	switch(node.getNodeType()) {

	case Node.DOCUMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.ELEMENT_NODE:
	    Element element = (Element)node;
	    String tag = element.getTagName();
	    buffer.append('<');
	    buffer.append(tag);
	    NamedNodeMap attrs = element.getAttributes();
	    int size = attrs.getLength();
	    for (int i = 0;i < size;i++) {
		Attr attr = (Attr)attrs.item(i);
		buffer.append(' ');
		buffer.append(attr.getName());
		buffer.append("=\"");
		buffer.append(attr.getValue());
		buffer.append('\"');
	    }
	    buffer.append('>');
	    _node2String4Data(element.getChildNodes(), buffer);
	    buffer.append("</");
	    buffer.append(tag);
	    buffer.append('>');
	    break;
	case Node.ATTRIBUTE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.COMMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.TEXT_NODE:
	    Text text = (Text)node;
	    buffer.append(text.getData());
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    _node2String4Data(node.getChildNodes(), buffer);
	    break;
	default:
	    throw (new UnsupportedOperationException("not supported yet"));
	}
    }

    private static void _node2String4Data(
	NodeList nodes,
	StringBuffer buffer
    ) {
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    _node2String4Data(nodes.item(i), buffer);
	}
    }

    // distill contents
    public static String element2Data(Element element) {
	return (element2Text(element).trim());
    }

    public static String element2Text(Element element) {
	return (node2Text(element));
    }

    public static String nodes2Text(Node[] nodes) {
	StringBuffer buffer = new StringBuffer();
	int nNodes = nodes.length;
	for (int i = 0;i < nNodes;i++) {
	    node2Text(nodes[i], buffer);
	}
	return (new String(buffer));
    }

    public static String node2Text(Node node) {
	StringBuffer buffer = new StringBuffer();
	node2Text(node, buffer);
	return (new String(buffer));
    }

    public static void node2Text(Node node, StringBuffer buffer) {
	switch(node.getNodeType()) {

	case Node.DOCUMENT_NODE:
	case Node.ELEMENT_NODE:
	    NodeList nodes = node.getChildNodes();
	    int nNodes = nodes.getLength();
	    for (int i = 0;i < nNodes;i++) {
		node2Text(nodes.item(i), buffer);
	    }
	    break;
	case Node.ATTRIBUTE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.COMMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.TEXT_NODE:
	    Text text = (Text)node;
	    buffer.append(text.getData());
	    break;
	default:
	    throw (new UnsupportedOperationException("not supported yet"));
	}
    }

    public static void printDoc(Document doc) {
	printDocument(doc);
    }

    public static void printDoc(Document doc, PrintWriter out) {
	printDocument(doc, out);
    }

    /**
     * @deprecated
     */
    public static void printDocument(Document doc) {
	printDocument(doc, new PrintWriter(System.out, true));
    }

    public static void printNode(Node node) {
	printNode(node, new PrintWriter(System.out, true));
    }

    /**
     * @deprecated
     */
    public static void printDocument(Document doc, PrintWriter out) {
	Element element = doc.getDocumentElement();
	out.println("<?xml version='1.0' ?>");
	printNode(element, out);
    }

    public static void printNode(Node node, PrintWriter out) {
	_printNode(node, "", out);
    }

    protected static void _printNode(
	Node node,
	String indent,
	PrintWriter out
    ) {
	switch(node.getNodeType()) {

	case Node.DOCUMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.ELEMENT_NODE:
	    Element element = (Element)node;
	    String tag = element.getTagName();
	    out.print(indent);
	    out.print("<");
	    out.print(tag);
	    NamedNodeMap attrs = element.getAttributes();
	    int nAttrs = attrs.getLength();
	    for (int i = 0;i < nAttrs;i++) {
		Attr attr = (Attr)attrs.item(i);
		out.print(' ');
		out.print(attr.getName());
		out.print("=\"");
		out.print(attr.getValue());
		out.print('\"');
	    }
	    out.print(">");
	    boolean needIndent = hasChildElement(element);
	    if (needIndent) {
		out.println();
	    }
	    NodeList nodes = element.getChildNodes();
	    int nNodes = nodes.getLength();
	    for (int i = 0;i < nNodes;i++) {
		Node child = nodes.item(i);
		if (child.getNodeType() == Node.TEXT_NODE) {
		    // XXX : xml:space
		    Text text = (Text)child;
		    if (!isBlankText(text)) {
			_printText(text, out);
		    }
		} else {
		    _printNode(child, indent + "  ", out);
		}
	    }
	    if (needIndent) {
		out.print(indent);
	    }
	    out.println("</" + tag + ">");
	    break;
	case Node.ATTRIBUTE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.COMMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.TEXT_NODE:
	    _printText((Text)node, out);
	    break;
	default:
	    throw (new UnsupportedOperationException("not supported yet"));
	}
    }

    protected static void _printText(Text text, PrintWriter out) {
	try {
	    out.print(text.getData());
//	    _printTextAsByte(text, out); // XXX
	} catch (Exception e) {
		e.printStackTrace();
	}
    }

    protected static void _printTextAsByte(Text text, PrintWriter out) {
	try {
	    String data = text.getData();
	    char[] chars = data.toCharArray();
	    for (int i = 0;i < chars.length;i++) {
		out.print(Integer.toHexString(((int)chars[i]) & 0xffff));
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public static boolean hasChildElement(Element element) {
	NodeList nodes = element.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    if (nodes.item(i).getNodeType() == Node.ELEMENT_NODE) {
		return (true);
	    }
	}
	return (false);
    }

    public static boolean isBlankText(Text text) {
	String data = text.getData();
	char[] chars = data.toCharArray();
	for (int i = 0;i < chars.length;i++) {
	    if (!isSpace(chars[i])) {
		return (false);
	    }
	}
	return (true);
    }

    public static boolean isSpace(char c) {
	switch (c) {

	case ' ':
	case '\t':
	case '\r':
	case '\n':
	    return (true);
	default:
	    return (false);
	}
    }

/*    
    public static Document createDocument() {
	// XML4J
	ElementFactory factory = new DefaultElementFactory();
	return (factory.createDocument());
    }

    public static Element createElement(String tag) {
	// XML4J
	ElementFactory factory = new DefaultElementFactory();
	return (factory.createElement(tag));
    }

    public static Text createText(String value) {
	// XML4J
	ElementFactory factory = new DefaultElementFactory();
	return (factory.createText(value));
    }
*/

    public static Element findElement(Document doc, String tag) {
	Element element = doc.getDocumentElement();
	if (tag.equals(element.getTagName())) {
	    return (element);
	}
	return (findElement(element, tag));
    }

    public static Element findElement(Element element, String tag) {
	NodeList nodes = element.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element e = (Element)child;
		if (tag.equals(e.getTagName())) {
		    return (e);
		}
		Element result = findElement(e, tag);
		if (result != null) {
		    return (result);
		}
	    }
	}
	return (null);
    }

    public static Node[] listNodes(Node parent) {
	NodeList children = parent.getChildNodes();
	Node[] nodes = new Node[children.getLength()];
	for (int i = 0;i < nodes.length;i++) {
	    nodes[i] = children.item(i);
	}
	return (nodes);
    }

    public static Element[] listElements(Element parent) {
	List list = new ArrayList();
	NodeList nodes = parent.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		list.add(child);
	    }
	}
	Element[] elements = new Element[list.size()];
	list.toArray(elements);
	return (elements);
    }

    public static Element[] collectElements(Element root, String tag) {
	List list = new ArrayList();
	_collectElements(root, tag, list);
	Element[] elements = new Element[list.size()];
	list.toArray(elements);
	return (elements);
    }

    protected static void _collectElements(
	Element element,
	String tag,
	List list
    ) {
	String tagName = element.getTagName();
	if (tag.equals(tagName)) {
	    list.add(element);
	    return;
	}
	NodeList nodes = element.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		_collectElements((Element)child, tag, list);
	    }
	}
    }

    public static String findData(Document doc, String tag) {
	return (findData(doc.getDocumentElement(), tag));
    }

    public static String findData(Element element, String tag) {
	Element e = findElement(element, tag);
	if (e == null) {
	    return (null);
	} else {
	    return (element2Data(e));
	}
    }

    public static String findAndDropData(Document doc, String tag) {
	return (findAndDropData(doc.getDocumentElement(), tag));
    }

    public static String findAndDropData(Element element, String tag) {
	NodeList nodes = element.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element e = (Element)child;
		if (tag.equals(e.getTagName())) {
		    String data = element2Data(e);
		    e.getParentNode().removeChild(e);		    
		    return (data);
		}
		String data = findAndDropData(e, tag);
		if (data != null) {
		    return (data);
		}
	    }
	}
	return (null);
    }

    public static String findData(
	Document doc,
	String tag,
	String attr,
	String value
    ) {
	return (findData(doc.getDocumentElement(), tag, attr, value));
    }

    public static String findData(
	Element element,
	String tag,
	String attr,
	String value
    ) {
	NodeList nodes = element.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element e = (Element)child;
		if (tag.equals(e.getTagName()) &&
		    value.equals(e.getAttribute(attr))) {

		    return (element2Data(e));
		}
		String data = findData(e, tag, attr, value);
		if (data != null) {
		    return (data);
		}
	    }
	}
	return (null);
    }

    public static String findAndDropData(
	Document doc,
	String tag,
	String attr,
	String value
    ) {
	return (findAndDropData(doc.getDocumentElement(), tag, attr, value));
    }

    public static String findAndDropData(
	Element element,
	String tag,
	String attr,
	String value
    ) {
	NodeList nodes = element.getChildNodes();
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element e = (Element)child;
		if (tag.equals(e.getTagName()) &&
		    value.equals(e.getAttribute(attr))) {

		    String data = element2Data(e);
		    e.getParentNode().removeChild(e);
		    return (data);
		}
		String data = findAndDropData(e, tag, attr, value);
		if (data != null) {
		    return (data);
		}
	    }
	}
	return (null);
    }

    public static String[] findDataList(Document doc, String tag) {
	return (findDataList(doc.getDocumentElement(), tag));
    }

    public static String[] findDataList(Element element, String tag) {
	List list = new ArrayList();
	_findDataList(element, tag, list);
	return ((String[])list.toArray(new String[list.size()]));
    }

    public static void _findDataList(
	Element element,
	String tag,
	List list
    ) {
	NodeList nodes = element.getChildNodes();
	int size = nodes.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = nodes.item(i);
	    if (child.getNodeType() == Node.ELEMENT_NODE) {
		Element e = (Element)child;
		if (tag.equals(e.getTagName())) {
		    list.add(element2Data(e));
		} else {
		    _findDataList(e, tag, list);
		}
	    }
	}
    }

    public static String getData(Document doc, String path) {
	throw (new UnsupportedOperationException());
    }

    public static String getData(Element element, String path) {
	throw (new UnsupportedOperationException());
    }

    public static String getDataAsString(Element element) {
	return (element2Data(element));
    }

    public static Number getDataAsNumber(Element element) {
	String data = element2Data(element);
	if (UString.isNull(data)) {
	    return (null);
	}
	try {
	    NumberFormat format = NumberFormat.getInstance();
	    Number number = format.parse(data);
	    return (number);	// XXX : Integer, Float
	} catch (ParseException e) {
	    return (null);
	}
    }

    public static Long getDataAsLong(Element element) {
	String data = element2Data(element);
	if (UString.isNull(data)) {
	    return (null);
	}
	try {
	    Long number = Long.valueOf(data);
	    return (number);
	} catch (NumberFormatException e) {
	    return (null);
	}
    }

    public static Document normalize(Document doc) {
	return (doc);
/*
	Document newDoc = (Document)doc.cloneNode(false);
	newDoc.appendChild(normalize(doc.getDocumentElement()));
	return (newDoc);
*/
    }

    public static Element normalize(Element node) {
	Element newNode = (Element)node.cloneNode(false);
	NodeList children = node.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    switch (child.getNodeType()) {

	    case Node.ENTITY_REFERENCE_NODE:
		Node[] refs = resolveEntityReference(
		    (EntityReference)child
		);
		for (int j = 0;j < refs.length;j++) {
		    newNode.appendChild(refs[j]);
		}
		break;
	    case Node.ELEMENT_NODE:
		newNode.appendChild(normalize((Element)child));
		break;
	    default:
		newNode.appendChild(child);
	    }
	}
	return (newNode);
    }

    public static Node[] resolveEntityReference(EntityReference eref) {
	List list = new ArrayList();
	NodeList nodes = eref.getChildNodes();
	int size = nodes.getLength();
	for (int i = 0;i < size;i++) {
	    Node node = nodes.item(i);
	    switch (node.getNodeType()) {

	    case Node.ENTITY_REFERENCE_NODE:
		Node[] children = resolveEntityReference(
		    (EntityReference)node
		);
		for (int j = 0;j < children.length;j++) {
		    list.add(children[j]);
		}
		break;
	    default:
		list.add(node);
	    }
	}
	Node[] result = new Node[list.size()];
	return ((Node[])list.toArray(result));
    }

    public static boolean hasXMLDeclaration(URL url) throws IOException {
	String encoding = guessXMLEncoding(url);
	BufferedReader reader = null;
	try {
	    reader = new BufferedReader(
		new InputStreamReader(url.openStream(), encoding)
	    );
	    String line = reader.readLine();
	    if (line == null) {
		return (false);
	    }
	    if (line.trim().indexOf("<?xml") != -1) {
		return (true);
	    } else {
		return (false);
	    }
	} finally {
	    if (reader != null) {
		try {
		    reader.close();
		} catch (IOException e) {
		}
	    }
	}
    }

    public static String guessXMLEncoding(URL url) throws IOException {
	DataInputStream in = null;
	try {
	    in = new DataInputStream(url.openStream());
	    byte[] buffer = new byte[4];
	    if (in.read(buffer) != 4) {
		return (null);
	    }
	    if (buffer[0] == 0xfe && buffer[1] == 0xff) {
		return ("UCS-16"); // big-endian
	    } else if (buffer[0] == 0xff && buffer[1] == 0xfe) {
		return ("UCS-16"); // little-endian
	    } else if (buffer[0] == 0x00 &&
		       buffer[1] == 0x00 &&
		       buffer[2] == 0x00 &&
		       buffer[3] == 0x3c) {

		return ("UCS-4"); // 1234
	    } else if (buffer[0] == 0x3c &&
		       buffer[1] == 0x00 &&
		       buffer[2] == 0x00 &&
		       buffer[3] == 0x00) {

		return ("UCS-4"); // 4321
	    } else if (buffer[0] == 0x00 &&
		       buffer[1] == 0x00 &&
		       buffer[2] == 0x3c &&
		       buffer[3] == 0x00) {

		return ("UCS-4"); // 2143
	    } else if (buffer[0] == 0x00 &&
		       buffer[1] == 0x3c &&
		       buffer[2] == 0x00 &&
		       buffer[3] == 0x00) {

		return ("UCS-4"); // 3412
	    } else if (buffer[0] == 0x00 &&
		       buffer[1] == 0x3c &&
		       buffer[2] == 0x00 &&
		       buffer[3] == 0x3f) {

		return ("UTF-16"); // error
	    } else if (buffer[0] == 0x00 &&
		       buffer[1] == 0x3f &&
		       buffer[2] == 0x00 &&
		       buffer[3] == 0x3c) {

		return ("UTF-16"); // error
	    } else if (buffer[0] == 0x3c &&
		       buffer[1] == 0x3f &&
		       buffer[2] == 0x78 &&
		       buffer[3] == 0x6d) {

		return ("us-ascii"); // includes UTF-8, Shift_JIS, EUC-JP
	    } else if (buffer[0] == 0x4c &&
		       buffer[1] == 0x6f &&
		       buffer[2] == 0xA7 &&
		       buffer[3] == 0x94) {

		return ("EBCDIC");
	    } else {
		return ("UTF-8");
	    }
	} finally {
	    try {
		if (in != null) {
		    in.close();
		}
	    } catch (IOException e) {
	    }
	}
    }

    public static void appendElement(
	Element element,
	String tagName,
	String data
    ) {
	Document doc = element.getOwnerDocument();
	Element item = doc.createElement(tagName);
	item.appendChild(doc.createTextNode(data));
	element.appendChild(item);
    }

    public static void appendElement(
	Element element,
	String tagName,
	String attrName,
	String data
    ) {
	Document doc = element.getOwnerDocument();
	Element item = doc.createElement(tagName);
	item.setAttribute(attrName, data);
	element.appendChild(item);
    }

    public static void updateElement(
	Element target,
	Element data,
	String keyAttr
    ) {
	updateElement(target, data, new String[] { keyAttr });
    }

    public static void updateElement(
	Element target,
	Element data,
	String[] keyAttrs
    ) {
	String tagName = data.getTagName();
	NodeList nodes = target.getElementsByTagName(tagName);
	int nNodes = nodes.getLength();
	for (int i = 0;i < nNodes;i++) {
	    Element element = (Element)nodes.item(i);
	    if (_isSameAttrs(element, data, keyAttrs)) {
		target.replaceChild(data, element);
		return;
	    }
	}
	target.appendChild(data);
    }

    protected static boolean _isSameAttrs(
	Element lhs,
	Element rhs,
	String[] attrs
    ) {
	for (int i = 0;i < attrs.length;i++) {
	    String attr = attrs[i];
	    if (!lhs.getAttribute(attr).equals(rhs.getAttribute(attr))) {
		return (false);
	    }
	}
	return (true);
    }

    public static Node makeCopy(Document doc, Node source) {
	switch (source.getNodeType()) {

	case Node.ELEMENT_NODE:
	    Element element = (Element)source;
	    Element newElement = doc.createElement(element.getTagName());
	    NamedNodeMap attrs = element.getAttributes();
	    int nAttrs = attrs.getLength();
	    for (int i = 0;i < nAttrs;i++) {
		newElement.setAttributeNode(
		    (Attr)makeCopy(doc, attrs.item(i))
		);
	    }
	    NodeList nodes = element.getChildNodes();
	    int nNodes = nodes.getLength();
	    for (int i = 0;i < nNodes;i++) {
		newElement.appendChild(makeCopy(doc, nodes.item(i)));
	    }
	    return (newElement);
	case Node.ATTRIBUTE_NODE:
	    Attr attr = (Attr)source;
	    Attr newAttr = doc.createAttribute(attr.getName());
	    newAttr.setValue(attr.getValue());
	    return (newAttr);
	case Node.TEXT_NODE:
	    return (doc.createTextNode(((Text)source).getData()));
	case Node.CDATA_SECTION_NODE:
	    return (doc.createCDATASection(((CDATASection)source).getData()));
	case Node.ENTITY_REFERENCE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.PROCESSING_INSTRUCTION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.COMMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_TYPE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_FRAGMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.NOTATION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	default:
	    throw (new UnsupportedOperationException("not supported yet"));
	}
    }

    public static Node makeShallowCopy(Document doc, Node source) {
	switch (source.getNodeType()) {

	case Node.ELEMENT_NODE:
	    Element element = (Element)source;
	    Element newElement = doc.createElement(element.getTagName());
	    NamedNodeMap attrs = element.getAttributes();
	    int nAttrs = attrs.getLength();
	    for (int i = 0;i < nAttrs;i++) {
		newElement.setAttributeNode(
		    (Attr)makeCopy(doc, attrs.item(i))
		);
	    }
	    return (newElement);
	case Node.ATTRIBUTE_NODE:
	    Attr attr = (Attr)source;
	    Attr newAttr = doc.createAttribute(attr.getName());
	    newAttr.setValue(attr.getValue());
	    return (newAttr);
	case Node.TEXT_NODE:
	    return (doc.createTextNode(((Text)source).getData()));
	case Node.CDATA_SECTION_NODE:
	    return (doc.createCDATASection(((CDATASection)source).getData()));
	case Node.ENTITY_REFERENCE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.PROCESSING_INSTRUCTION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.COMMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_TYPE_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.DOCUMENT_FRAGMENT_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	case Node.NOTATION_NODE:
	    throw (new UnsupportedOperationException("not supported yet"));
	default:
	    throw (new UnsupportedOperationException("not supported yet"));
	}
    }

    public static void traverseBreadth(Node node, IDOMVisitor visitor) {
	switch (node.getNodeType()) {

	case Node.ELEMENT_NODE:
	    visitor.visit((Element)node);
	    break;
	case Node.ATTRIBUTE_NODE:
	    visitor.visit((Attr)node);
	    break;
	case Node.TEXT_NODE:
	    visitor.visit((Text)node);
	    break;
	case Node.CDATA_SECTION_NODE:
	    visitor.visit((CDATASection)node);
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    visitor.visit((EntityReference)node);
	    break;
	case Node.ENTITY_NODE:
	    visitor.visit((Entity)node);
	    break;
	case Node.PROCESSING_INSTRUCTION_NODE:
	    visitor.visit((ProcessingInstruction)node);
	    break;
	case Node.COMMENT_NODE:
	    visitor.visit((Comment)node);
	    break;
	case Node.DOCUMENT_NODE:
	    visitor.visit((Document)node);
	    break;
	case Node.DOCUMENT_TYPE_NODE:
	    visitor.visit((DocumentType)node);
	    break;
	case Node.DOCUMENT_FRAGMENT_NODE:
	    visitor.visit((DocumentFragment)node);
	    break;
	case Node.NOTATION_NODE:
	    visitor.visit((Notation)node);
	    break;
	default:
	    visitor.visit(node);
	    break;
	}
	traverseChildrenBreadth(node, visitor);
    }

    public static void traverseDepth(Node node, IDOMVisitor visitor) {
	switch (node.getNodeType()) {

	case Node.ELEMENT_NODE:
	    visitor.visit((Element)node);
	    break;
	case Node.ATTRIBUTE_NODE:
	    visitor.visit((Attr)node);
	    break;
	case Node.TEXT_NODE:
	    visitor.visit((Text)node);
	    break;
	case Node.CDATA_SECTION_NODE:
	    visitor.visit((CDATASection)node);
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    visitor.visit((EntityReference)node);
	    break;
	case Node.ENTITY_NODE:
	    visitor.visit((Entity)node);
	    break;
	case Node.PROCESSING_INSTRUCTION_NODE:
	    visitor.visit((ProcessingInstruction)node);
	    break;
	case Node.COMMENT_NODE:
	    visitor.visit((Comment)node);
	    break;
	case Node.DOCUMENT_NODE:
	    visitor.visit((Document)node);
	    break;
	case Node.DOCUMENT_TYPE_NODE:
	    visitor.visit((DocumentType)node);
	    break;
	case Node.DOCUMENT_FRAGMENT_NODE:
	    visitor.visit((DocumentFragment)node);
	    break;
	case Node.NOTATION_NODE:
	    visitor.visit((Notation)node);
	    break;
	default:
	    visitor.visit(node);
	    break;
	}
	traverseChildrenDepth(node, visitor);
    }

    public static void traverseChildrenBreadth(
	Node node,
	IDOMVisitor visitor
    ) {
	switch (node.getNodeType()) {

	case Node.ELEMENT_NODE:
	    visitor.enter((Element)node);
	    break;
	case Node.ATTRIBUTE_NODE:
	    visitor.enter((Attr)node);
	    break;
	case Node.TEXT_NODE:
	    visitor.enter((Text)node);
	    break;
	case Node.CDATA_SECTION_NODE:
	    visitor.enter((CDATASection)node);
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    visitor.enter((EntityReference)node);
	    break;
	case Node.ENTITY_NODE:
	    visitor.enter((Entity)node);
	    break;
	case Node.PROCESSING_INSTRUCTION_NODE:
	    visitor.enter((ProcessingInstruction)node);
	    break;
	case Node.COMMENT_NODE:
	    visitor.enter((Comment)node);
	    break;
	case Node.DOCUMENT_NODE:
	    visitor.enter((Document)node);
	    break;
	case Node.DOCUMENT_TYPE_NODE:
	    visitor.enter((DocumentType)node);
	    break;
	case Node.DOCUMENT_FRAGMENT_NODE:
	    visitor.enter((DocumentFragment)node);
	    break;
	case Node.NOTATION_NODE:
	    visitor.enter((Notation)node);
	    break;
	default:
	    visitor.enter(node);
	    break;
	}
	NodeList children = node.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    switch (child.getNodeType()) {

	    case Node.ELEMENT_NODE:
		visitor.visit((Element)child);
		break;
	    case Node.ATTRIBUTE_NODE:
		visitor.visit((Attr)child);
		break;
	    case Node.TEXT_NODE:
		visitor.visit((Text)child);
		break;
	    case Node.CDATA_SECTION_NODE:
		visitor.visit((CDATASection)child);
		break;
	    case Node.ENTITY_REFERENCE_NODE:
		visitor.visit((EntityReference)child);
		break;
	    case Node.ENTITY_NODE:
		visitor.visit((Entity)node);
		break;
	    case Node.PROCESSING_INSTRUCTION_NODE:
		visitor.visit((ProcessingInstruction)child);
		break;
	    case Node.COMMENT_NODE:
		visitor.visit((Comment)child);
		break;
	    case Node.DOCUMENT_NODE:
		visitor.visit((Document)child);
		break;
	    case Node.DOCUMENT_TYPE_NODE:
		visitor.visit((DocumentType)child);
		break;
	    case Node.DOCUMENT_FRAGMENT_NODE:
		visitor.visit((DocumentFragment)child);
		break;
	    case Node.NOTATION_NODE:
		visitor.visit((Notation)child);
		break;
	    default:
		visitor.visit(child);
		break;
	    }
	}
	for (int i = 0;i < size;i++) {
	    traverseChildrenBreadth(children.item(i), visitor);
	}
	switch (node.getNodeType()) {

	case Node.ELEMENT_NODE:
	    visitor.leave((Element)node);
	    break;
	case Node.ATTRIBUTE_NODE:
	    visitor.leave((Attr)node);
	    break;
	case Node.TEXT_NODE:
	    visitor.leave((Text)node);
	    break;
	case Node.CDATA_SECTION_NODE:
	    visitor.leave((CDATASection)node);
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    visitor.leave((EntityReference)node);
	    break;
	case Node.ENTITY_NODE:
	    visitor.leave((Entity)node);
	    break;
	case Node.PROCESSING_INSTRUCTION_NODE:
	    visitor.leave((ProcessingInstruction)node);
	    break;
	case Node.COMMENT_NODE:
	    visitor.leave((Comment)node);
	    break;
	case Node.DOCUMENT_NODE:
	    visitor.leave((Document)node);
	    break;
	case Node.DOCUMENT_TYPE_NODE:
	    visitor.leave((DocumentType)node);
	    break;
	case Node.DOCUMENT_FRAGMENT_NODE:
	    visitor.leave((DocumentFragment)node);
	    break;
	case Node.NOTATION_NODE:
	    visitor.leave((Notation)node);
	    break;
	default:
	    visitor.leave(node);
	    break;
	}
    }

    public static void traverseChildrenDepth(
	Node node,
	IDOMVisitor visitor
    ) {
	switch (node.getNodeType()) {

	case Node.ELEMENT_NODE:
	    visitor.enter((Element)node);
	    break;
	case Node.ATTRIBUTE_NODE:
	    visitor.enter((Attr)node);
	    break;
	case Node.TEXT_NODE:
	    visitor.enter((Text)node);
	    break;
	case Node.CDATA_SECTION_NODE:
	    visitor.enter((CDATASection)node);
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    visitor.enter((EntityReference)node);
	    break;
	case Node.ENTITY_NODE:
	    visitor.enter((Entity)node);
	    break;
	case Node.PROCESSING_INSTRUCTION_NODE:
	    visitor.enter((ProcessingInstruction)node);
	    break;
	case Node.COMMENT_NODE:
	    visitor.enter((Comment)node);
	    break;
	case Node.DOCUMENT_NODE:
	    visitor.enter((Document)node);
	    break;
	case Node.DOCUMENT_TYPE_NODE:
	    visitor.enter((DocumentType)node);
	    break;
	case Node.DOCUMENT_FRAGMENT_NODE:
	    visitor.enter((DocumentFragment)node);
	    break;
	case Node.NOTATION_NODE:
	    visitor.enter((Notation)node);
	    break;
	default:
	    visitor.enter(node);
	    break;
	}
	NodeList children = node.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    switch (child.getNodeType()) {

	    case Node.ELEMENT_NODE:
		visitor.visit((Element)child);
		break;
	    case Node.ATTRIBUTE_NODE:
		visitor.visit((Attr)child);
		break;
	    case Node.TEXT_NODE:
		visitor.visit((Text)child);
		break;
	    case Node.CDATA_SECTION_NODE:
		visitor.visit((CDATASection)child);
		break;
	    case Node.ENTITY_REFERENCE_NODE:
		visitor.visit((EntityReference)child);
		break;
	    case Node.ENTITY_NODE:
		visitor.visit((Entity)node);
		break;
	    case Node.PROCESSING_INSTRUCTION_NODE:
		visitor.visit((ProcessingInstruction)child);
		break;
	    case Node.COMMENT_NODE:
		visitor.visit((Comment)child);
		break;
	    case Node.DOCUMENT_NODE:
		visitor.visit((Document)child);
		break;
	    case Node.DOCUMENT_TYPE_NODE:
		visitor.visit((DocumentType)child);
		break;
	    case Node.DOCUMENT_FRAGMENT_NODE:
		visitor.visit((DocumentFragment)child);
		break;
	    case Node.NOTATION_NODE:
		visitor.visit((Notation)child);
		break;
	    default:
		visitor.visit(child);
		break;
	    }
	    traverseChildrenDepth(child, visitor);
	}
	switch (node.getNodeType()) {

	case Node.ELEMENT_NODE:
	    visitor.leave((Element)node);
	    break;
	case Node.ATTRIBUTE_NODE:
	    visitor.leave((Attr)node);
	    break;
	case Node.TEXT_NODE:
	    visitor.leave((Text)node);
	    break;
	case Node.CDATA_SECTION_NODE:
	    visitor.leave((CDATASection)node);
	    break;
	case Node.ENTITY_REFERENCE_NODE:
	    visitor.leave((EntityReference)node);
	    break;
	case Node.ENTITY_NODE:
	    visitor.leave((Entity)node);
	    break;
	case Node.PROCESSING_INSTRUCTION_NODE:
	    visitor.leave((ProcessingInstruction)node);
	    break;
	case Node.COMMENT_NODE:
	    visitor.leave((Comment)node);
	    break;
	case Node.DOCUMENT_NODE:
	    visitor.leave((Document)node);
	    break;
	case Node.DOCUMENT_TYPE_NODE:
	    visitor.leave((DocumentType)node);
	    break;
	case Node.DOCUMENT_FRAGMENT_NODE:
	    visitor.leave((DocumentFragment)node);
	    break;
	case Node.NOTATION_NODE:
	    visitor.leave((Notation)node);
	    break;
	default:
	    visitor.leave(node);
	    break;
	}
    }

    // new traverse logic

    public static void traverseDepthFirst(
	Node node,
	IDOMVisitor visitor
    ) {
	NodeList children = node.getChildNodes();
	int size = children.getLength();
	for (int i = 0;i < size;i++) {
	    Node child = children.item(i);
	    switch (child.getNodeType()) {

	    case Node.ELEMENT_NODE:
		visitor.enter((Element)child);
		break;
	    case Node.ATTRIBUTE_NODE:
		visitor.enter((Attr)child);
		break;
	    case Node.TEXT_NODE:
		visitor.enter((Text)child);
		break;
	    case Node.CDATA_SECTION_NODE:
		visitor.enter((CDATASection)child);
		break;
	    case Node.ENTITY_REFERENCE_NODE:
		visitor.enter((EntityReference)child);
		break;
	    case Node.ENTITY_NODE:
		visitor.enter((Entity)node);
		break;
	    case Node.PROCESSING_INSTRUCTION_NODE:
		visitor.enter((ProcessingInstruction)child);
		break;
	    case Node.COMMENT_NODE:
		visitor.enter((Comment)child);
		break;
	    case Node.DOCUMENT_NODE:
		visitor.enter((Document)child);
		break;
	    case Node.DOCUMENT_TYPE_NODE:
		visitor.enter((DocumentType)child);
		break;
	    case Node.DOCUMENT_FRAGMENT_NODE:
		visitor.enter((DocumentFragment)child);
		break;
	    case Node.NOTATION_NODE:
		visitor.enter((Notation)child);
		break;
	    default:
		visitor.enter(child);
		break;
	    }
	    traverseDepthFirst(child, visitor);
	    switch (child.getNodeType()) {

	    case Node.ELEMENT_NODE:
		visitor.leave((Element)child);
		break;
	    case Node.ATTRIBUTE_NODE:
		visitor.leave((Attr)child);
		break;
	    case Node.TEXT_NODE:
		visitor.leave((Text)child);
		break;
	    case Node.CDATA_SECTION_NODE:
		visitor.leave((CDATASection)child);
		break;
	    case Node.ENTITY_REFERENCE_NODE:
		visitor.leave((EntityReference)child);
		break;
	    case Node.ENTITY_NODE:
		visitor.leave((Entity)node);
		break;
	    case Node.PROCESSING_INSTRUCTION_NODE:
		visitor.leave((ProcessingInstruction)child);
		break;
	    case Node.COMMENT_NODE:
		visitor.leave((Comment)child);
		break;
	    case Node.DOCUMENT_NODE:
		visitor.leave((Document)child);
		break;
	    case Node.DOCUMENT_TYPE_NODE:
		visitor.leave((DocumentType)child);
		break;
	    case Node.DOCUMENT_FRAGMENT_NODE:
		visitor.leave((DocumentFragment)child);
		break;
	    case Node.NOTATION_NODE:
		visitor.leave((Notation)child);
		break;
	    default:
		visitor.leave(child);
		break;
	    }
	}
    }

    public static String escapeAscii(String text) {
	if (isAsciiText(text)) {
	    return (text);
	}
	StringBuffer buffer = new StringBuffer();
	int size = text.length();
	for (int i = 0;i < size;i++) {
	    char c = text.charAt(i);
	    if (UString.isAscii(c)) {
		buffer.append(c);
	    } else {
		buffer.append("&#");
		buffer.append(Integer.toHexString(c));
		buffer.append(";");
	    }
	}
	return (new String(buffer));
    }

    public static boolean isAsciiText(String text) {
	int size = text.length();
	for (int i = 0;i < size;i++) {
	    char c = text.charAt(i);
	    if (!UString.isAscii(c)) {
		return (false);
	    }
	}
	return (true);
    }

    // test driver
    public static void main(String[] args) throws Exception {
	java.net.URL url
	    = jp.gr.java_conf.jaba2.io.UURL.getURLFromFileOrURLName(args[0]);
	jp.gr.java_conf.jaba2.xml.IProcessor processor
	    = jp.gr.java_conf.jaba2.xml.ProcessorFactory.getProcessor();
	Document doc = processor.parseValidDocument(url);
    }
}
