/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.jar;

import java.util.*;
import java.io.*;
import java.util.jar.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.io.UJar;
import jp.gr.java_conf.jaba2.vfs.*;
import jp.gr.java_conf.jaba2.vfs.filter.AnyFilter;

/**
 * JarRoot
 *
 * @since   Jan. 25, 2000
 * @version Feb.  9, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JarRoot extends AbstractVFSRoot {
    private File file_;

    public JarRoot(File file) {
	file_ = file;
    }

    public void shallowSetup(IFilter filter) throws IOException {
	deepSetup(filter);	// XXX
    }

    public void deepSetup(IFilter filter) throws IOException {
	if (file_.exists()) {
	    JarFile jarFile = new JarFile(file_);
	    Enumeration entries = jarFile.entries();
	    while (entries.hasMoreElements()) {
		JarEntry entry = (JarEntry)entries.nextElement();
		String name = entry.getName();
		if ("META-INF/MANIFEST.MF".equals(name)) {
		    continue;
		}
		if (!name.endsWith("/")) {
		    createJarObject(name);
		}
	    }
	}
    }

    public JarObject createJarObject(String path) {
	String[] bodies = UString.getTokens(path, "/");
	if (bodies == null) {
	    throw (new InternalError());
	}
	if (bodies.length == 0) {
	    throw (new InternalError());
	}
	String name = bodies[0];
	IVFSNode node = getNode(name);
	if (node == null) {
	    if (bodies.length == 1) {
		JarObject object = new JarObject(new JarEntry(name));
		addObject(object);
		return (object);
	    } else {
		JarContainer container = new JarContainer(new JarEntry(name));
		addContainer(container);
		return (_createJarObject(container, bodies, 1));
	    }
	} else {
	    if (bodies.length == 1) {
		return ((JarObject)node);
	    }
	    if (!(node instanceof IVFSContainer)) {
		throw (new InternalError());
	    }
	}
	return (_createJarObject((IVFSContainer)node, bodies, 1));
    }

    private JarObject _createJarObject(
	IVFSContainer container,
	String[] bodies,
	int index
    ) {
	String name = bodies[index];
	IVFSNode node = container.getNode(name);
	if (node == null) {
	    if (bodies.length == index + 1) {
		JarObject child = new JarObject(
		    new JarEntry(_makePathname(bodies, index))
		);
		container.addObject(child);
		return (child);
	    } else {
		JarContainer child = new JarContainer(
		    new JarEntry(_makePathname(bodies, index))
		);
		container.addContainer(child);
		return (_createJarObject(child, bodies, index + 1));
	    }
	} else {
	    if (bodies.length == index + 1) {
		return ((JarObject)node);
	    }
	    if (!(node instanceof IVFSContainer)) {
		throw (new InternalError());
	    }
	    return (
		_createJarObject(
		    (IVFSContainer)node,
		    bodies,
		    index + 1
		)
	    );
	}
    }

    private String _makePathname(String[] bodies, int index) {
	StringBuffer buffer = new StringBuffer();
	buffer.append(bodies[0]);
	for (int i = 1;i <= index;i++) {
	    buffer.append("/");
	    buffer.append(bodies[i]);
	}
	return (new String(buffer));
    }
}
