/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.vfs.filter;

import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.vfs.*;

/**
 * NameFilter
 *
 * @since   Jan. 24, 2000
 * @version Jan. 28, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class NameFilter implements IFilter {
    private String[] names_;

    public NameFilter(String name) {
	names_ = new String[] { name };
    }

    public NameFilter(String[] names) {
	names_ = new String[names.length];
	System.arraycopy(names, 0, names_, 0, names.length);
    }

    public boolean isMatch(IVFSNode node) {
	String name = UString.getLastComponent(node.getPathname());
	for (int i = 0;i < names_.length;i++) {
	    if (name.equals(names_[i])) {
		return (true);
	    }
	}
	return (false);
    }
}
