/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.text.cui;

import jp.gr.java_conf.jaba2.util.D2Array;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * CBoardBase
 *
 * @since   Oct. 21, 1999
 * @version Nov. 25, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class CBoardBase implements ICBoard {
    protected D2Array board_ = new D2Array();
    protected String newline_ = "\n";
    protected static final Character AFTER_WIDE_CHARACTER
        = new Character('\uffff');

    public void setNewline(String newline) {
	newline_ = newline;
    }

    public void put(int x, int y, char c) {
	if (board_.getWidth() > x &&
	    board_.getHeight() > y) {

	    Character pc = (Character)board_.get(x, y);
	    if (pc == AFTER_WIDE_CHARACTER) {
		throw (new IllegalArgumentException());
	    }
	}
	board_.put(x, y, new Character(c));
	if (UString.isWideCharacter(c)) {
	    board_.put(x + 1, y, AFTER_WIDE_CHARACTER);
	} else {
	    if (board_.getWidth() > x + 1) {
		Character nc = (Character)board_.get(x + 1, y);
		if (nc == AFTER_WIDE_CHARACTER) {
		    board_.put(x + 1, y, null);
		}
	    }
	}
    }

    public void put(int x, final int y, final String text) {
	int size = text.length();
	for (int i = 0;i < size;i++) {
	    char c = text.charAt(i);
	    put(x, y, c);
	    if (UString.isWideCharacter(c)) {
		x += 2;
	    } else {
		x++;
	    }
	}
    }

    public String makeScreen() {
	StringBuffer buffer = new StringBuffer();
	makeScreen(buffer);
	return (new String(buffer));
    }

    public void makeScreen(StringBuffer buffer) {
	int width = board_.getWidth();
	int height = board_.getHeight();
	for (int y = 0;y < height;y++) {
	    StringBuffer spaces = new StringBuffer();
	    for (int x = 0;x < width;x++) {
		Character c = (Character)board_.get(x, y);
		if (c == null) {
		    spaces.append(" ");
		} else if (c == AFTER_WIDE_CHARACTER) {
		    // do nothing
		} else {
		    buffer.append(spaces);
		    spaces.setLength(0);
		    buffer.append(c);
		}
	    }
	    buffer.append(newline_);
	}
    }
}
