package jp.gr.java_conf.jaba2.j2fw.sample;

import java.io.*;

/**
 * Shell
 *
 * @since   Feb.  9, 1999
 * @version Feb.  9, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class Shell {
    public static void main(String[] args) {
	PrintWriter console = null;
	PrintWriter out = null;
	try {
	    ShellConfig config = new ShellConfig(args);
	    ShellModel model = new ShellModel(config);
	    ShellController controller = new ShellController(
		config,
		model
	    );
	    ShellContext context = new ShellContext(
		config,
		model,
		controller
	    );
	    ShellContext.setContext(context);
	    if (config.showVersion()) {
		controller.showVersionConsole();
	    } else if (config.showHelp()) {
		controller.showHelpConsole();
	    } else {
		throw (new UnsupportedOperationException());
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
