/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.packager;

import java.util.*;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusGeneratorController
 *
 * @since   Aug. 28, 2000
 * @version Aug. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusPackagerController extends AbstractDOMBusComponent {
    IDOMBusPackager[] packagers_;

    public boolean init() {
	IDOMBusParameter param = context_.getParameter();
	String[] packagerNames = param.getParameterAsStringList("packager");
	IDOMBusComponent[] components
	    = bus_.getComponents(IDOMBusPackager.class);
	List list = new ArrayList();
	for (int i = 0;i < components.length;i++) {
	    IDOMBusPackager packager = (IDOMBusPackager)components[i];
	    if (UString.compareList(packager.getID(), packagerNames)) {
		list.add(packager);
	    }
	}
	packagers_ = new IDOMBusPackager[list.size()];
	packagers_ = (IDOMBusPackager[])list.toArray(packagers_);
	System.arraycopy(components, 0, packagers_, 0, components.length);
	return (false);
    }

    public Object fire(DOMBusSignal signal) {
	IParcel parcel = (IParcel)signal.getContent();
	for (int i = 0;i < packagers_.length;i++) {
	    IDOMBusPackager packager = packagers_[i];
	    packager.pack(parcel);
	    _sendSignal("pack");
	}
	return (null);
    }
}
