/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus.packager;

import java.io.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UFile;
import jp.gr.java_conf.jaba2.parcel.IParcel;
import jp.gr.java_conf.jaba2.parcel.IGadget;
import jp.gr.java_conf.jaba2.dombus.*;

/**
 * DOMBusFilePackager
 *
 * @since   Apr. 29, 2000
 * @version Aug. 29, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DOMBusFilePackager extends AbstractDOMBusPackager {
    public String getID() {
	return ("file");
    }

    protected void _pack(IGadget gadget) {
	String urlName = gadget.getName();
	String encoding = gadget.getEncoding();
	String backup = (String)gadget.getProperty("backup"); // XXX
	File file = new File(urlName); // XXX
	try {
	    if ("true".equals(backup)) {
		_backupFile(urlName);
	    }
	    OutputStream out = new FileOutputStream(file);
	    gadget.write(out);
	    out.close();
	} catch (IOException e) {
	    throw (new DOMBusException(e));
	}
    }

    private void _backupFile(String fileName) throws IOException {
	File file = new File(fileName);
	if (file.exists()) {
	    String backupName = fileName + ".bak";
	    File backup = new File(backupName);
	    file.renameTo(backup);
	}
    }
}


