package jp.gr.java_conf.jaba2.dombus.configRelaxer;

import org.w3c.dom.*;

/**
 * <b>CContext</b> is generated by Relaxer based on ConfigFile.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="context">
 *   <ref label="class"/>
 * </elementRule>
 * 
 * <tag name="context">
 *   <attribute java:default="*default*" name="name" type="Name"/>
 *   <attribute name="resource" type="Name"/>
 *   <attribute name="userPropertyFile" type="Name"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="context"&gt;
 *   &lt;ref label="class"/&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="context"&gt;
 *   &lt;attribute java:default="*default*" name="name" type="Name"/&gt;
 *   &lt;attribute name="resource" type="Name"/&gt;
 *   &lt;attribute name="userPropertyFile" type="Name"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version ConfigFile.rlx (Tue Aug 29 11:45:14 JST 2000)
 * @author  Relaxer 0.10.2b (by ASAMI@Yokohama)
 */
public class CContext implements java.io.Serializable {
    private String name = "*default*";
    private String resource;
    private String userPropertyFile;
    private CClass classValue;

    /**
     * Creates a <code>CContext</code>.
     *
     */
    public CContext() {
    }

    /**
     * Creates a <code>CContext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CContext(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CContext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CContext(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CContext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CContext(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>CContext</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CContext</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CContext</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IConfigFileFactory factory = ConfigFileFactory.getFactory();
        RStack stack = new RStack(element);
        name = URelaxer.getAttributePropertyAsString(element, "name");
        resource = URelaxer.getAttributePropertyAsString(element, "resource");
        userPropertyFile = URelaxer.getAttributePropertyAsString(element, "userPropertyFile");
        setClassValue(factory.createCClass(stack));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("context");
        int size;
        if (name != null) {
            URelaxer.setAttributePropertyByString(element, "name", name);
        }
        if (resource != null) {
            URelaxer.setAttributePropertyByString(element, "resource", resource);
        }
        if (userPropertyFile != null) {
            URelaxer.setAttributePropertyByString(element, "userPropertyFile", userPropertyFile);
        }
        classValue.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the String property <b>resource</b>.
     *
     * @return String
     */
    public final String getResource() {
        return (resource);
    }

    /**
     * Sets the String property <b>resource</b>.
     *
     * @param resource
     */
    public final void setResource(String resource) {
        this.resource = resource;
    }

    /**
     * Gets the String property <b>userPropertyFile</b>.
     *
     * @return String
     */
    public final String getUserPropertyFile() {
        return (userPropertyFile);
    }

    /**
     * Sets the String property <b>userPropertyFile</b>.
     *
     * @param userPropertyFile
     */
    public final void setUserPropertyFile(String userPropertyFile) {
        this.userPropertyFile = userPropertyFile;
    }

    /**
     * Gets the CClass property <b>classValue</b>.
     *
     * @return CClass
     */
    public final CClass getClassValue() {
        return (classValue);
    }

    /**
     * Sets the CClass property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(CClass classValue) {
        this.classValue = classValue;
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CContext</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        String tagName = element.getTagName();
        if (!"context".equals(tagName)) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!CClass.isMatchHungry(target)) {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CContext</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CContext</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
