/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.dombus;

import jp.gr.java_conf.jaba2.dombus.configRelaxer.CSlot;

/**
 * ComponentSlot
 *
 * @since   Mar. 28, 2000
 * @version Jul, 21, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
class ComponentSlot extends AbstractComponentSlot {
    public ComponentSlot(
	IDOMBusComponent component,
	IDOMBusGuard guard
    ) {
	super(component, guard);
    }

    public ComponentSlot(IDOMBusComponent component, CSlot slot) {
	super(component, slot);
    }

    public boolean stimulus(DOMBusSignal signal) {
	if (guard_.isAccept(signal)) {
	    Object result = component_.fire(signal);
	    signal.consume();
	    if (post_ != null) {
		post_.fire(result);
	    }
	    return (true);
	} else {
	    signal.consume();
	    return (false);
	}
    }
}
