package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.io.File; // XXX
import java.lang.reflect.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import jp.gr.java_conf.jaba2.awt.ExplorerLayout;
import jp.gr.java_conf.jaba2.awt.explorer.*;
import jp.gr.java_conf.jaba2.io.FileTreeNode; // XXX
import jp.gr.java_conf.jaba2.io.DirectoryTableModel; // XXX

/**
 * ExplorerPanel
 *
 * @since   Apr.  3, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
// add action facility
public class ExplorerPanel extends ActionPanel {
    protected ShortcutListView list_ = null;
    protected IndexView index_;
    protected SummaryView summary_;
    protected Component view_ = null;
    protected ExplorerModel model_;
    protected SummaryModel summaryModel_;
    protected IndexModel indexModel_;
    protected ShortcutListModel shortcutListModel_;

    /**
     * You should invoke the <code>_setModel</code> during construction
     * phase.
     */
    protected ExplorerPanel() {
    }

    public ExplorerPanel(ExplorerModel model) {
	_setModel(model);
    }

    protected void _setModel(ExplorerModel model) {
	model_ = model;
	summaryModel_ = model.refSummaryModel();
	indexModel_ = model.refIndexModel();
	shortcutListModel_ = model.refShortcutListModel();
	setLayout(new ExplorerLayout());
	index_ = new IndexView(indexModel_);
	model_.addObserver(index_); // XXX : should use the IndexModel
	summary_ = new SummaryView(summaryModel_);
	summary_.setSelectionModel(summaryModel_.refListSelectionModel());
	add(new JScrollPane(index_), "tree");
	add(new JScrollPane(summary_), "summary");
	index_.addTreeSelectionListener(new TreeSelectionListener() {
	    public void valueChanged(TreeSelectionEvent evt) {
		indexModel_.setSelection((TreePath)evt.getPath());
	    }
	});
	if (shortcutListModel_ != null) {
	    _setShortcutListModel(shortcutListModel_);
	}
	model_.addObserver(new Observer() {
	    public void update(Observable o, Object arg) {
		if (o instanceof ExplorerModel) {
		    firePropertyChange(
			"selectionPath",
			null,
			getSelectionPath()
		    );
		}
	    }
	});
    }

    protected void _setShortcutListModel(ShortcutListModel model) {
	if (list_ == null) {
	    list_ = new ShortcutListView(model);
	    add(list_, "list");
	} else {
	    list_.setModel(model);
	}
    }

    public void setView(Component view) {
	view_ = view;
	add(new JScrollPane(view_), "view");
    }

    // XXX : should use the ExplorerModel
    public TreePath getSelectionPath() {
	return (index_.getSelectionPath());
    }

    // XXX : should use the ExplorerModel
    public TreePath[] getSelectionPaths() {
	return (index_.getSelectionPaths());
    }

    // XXX : should use the ExplorerModel
    public int getSelectionCount() {
	return (index_.getSelectionCount());
    }

    protected void firePropertyChange(
	String propertyName,
	Object oldValue,
	Object newValue
    ) {
	super.firePropertyChange(propertyName, oldValue, newValue);
    }

    // view
    protected static class IndexView extends JTree implements Observer {
	protected IndexModel model_;

	public IndexView(IndexModel model) {
	    super(model);
	    model_ = model;
	}

	// Observer
	public void update(Observable o, Object arg) {
	    if (o instanceof ExplorerModel) { // XXX : should use IndexModel
		TreePath path = (TreePath)arg;
		setSelectionPath(path);
	    }
	}
    }

    protected static class SummaryView extends JTable {
	SummaryModel model_;

	public SummaryView(SummaryModel model) {
	    super(model);
	    model_ = model;
//	    setMultipleSelectionAllowed(false); // JDK1.2 beta2
	}

	// JTable
	public void tableChanged(TableModelEvent evt) {
	    super.tableChanged(evt);
	    if (model_ != null) {
		int index = model_.getSelectionIndex();
		if (index != SummaryModel.NOSELECTION) {
		    setRowSelectionInterval(index, index);
		}
	    }
	}
    }

    protected static class ShortcutListView extends JComboBox {
	public ShortcutListView(ShortcutListModel model) {
	    super(model);
/*
	    setRenderer(new javax.swing.basic.BasicListCellRenderer() {
		public Component getListCellRendererComponent(
		    JList list,
		    Object value,
		    int index,
		    boolean isSelected,
		    boolean cellHasFocus
		) {
		    if (value instanceof TreePath) {
			value = "OK";
		    }
		    return (super.getListCellRendererComponent(
			list, value, index, isSelected, cellHasFocus));
		}
	    });
 */
	}
    }

    //
    public static class NullTreePath extends TreePath {
	public NullTreePath() {
	    super(new Object[0]);
	}
    }

    // test
    public static class FileExplorerModel extends AbstractExplorerModel {
	public FileExplorerModel(File root) {
	    IndexModel imodel = new FileIndexModel(this, root);
	    TreePath[] paths = _makeList(imodel); // XXX
	    setIndexModel(imodel);
	    setSummaryModel(new FileSummaryModel(this));
	    setShortcutListModel(new FileShortcutListModel(this, paths));
	}

	protected TreePath[] _makeList(IndexModel imodel) { // XXX
	    TreeNode node = (TreeNode)imodel.getRoot();
	    java.util.List list = new java.util.ArrayList();
	    Enumeration enum = node.children();
	    while (enum.hasMoreElements()) {
		TreeNode child = (TreeNode)enum.nextElement();
		list.add(new TreePath(new Object[] { node, child }));
	    }
	    int size = list.size();
	    if (size > 10) {
		size = 10;
	    }
	    TreePath[] paths = new TreePath[size];
	    for (int i = 0;i < size;i++) {
		paths[i] = (TreePath)list.get(i);
	    }
	    return (paths);
	}
    }

    public static class FileIndexModel extends AbstractIndexModel {
	public FileIndexModel(ExplorerModel emodel, File root) {
	    super(emodel, new jp.gr.java_conf.jaba2.io.FileTreeNode(root));
	}
    }

    public static class FileSummaryModel extends AbstractSummaryModel {
	public FileSummaryModel(ExplorerModel emodel) {
	    super(emodel);
	}

	// AbstractSummaryModel
	public boolean isLeaf(TreeNode node) {
	    return (!((FileTreeNode)node).getFile().isDirectory());
	}

	// SummaryModel
	public TableModel makeTableModel(TreeNode node) {
	    return (new DirectoryTableModel(((FileTreeNode)node).getFile()));
	}
    }

    public static class FileShortcutListModel
	extends AbstractShortcutListModel {

	protected String[] labels_;
	protected TreePath[] paths_;
	protected TreePath current_;

	public FileShortcutListModel(
	    ExplorerModel emodel,
	    TreePath[] paths
	) {
	    super(emodel);
	    paths_ = new TreePath[paths.length + 1];
	    paths_[0] = new NullTreePath();
	    for (int i = 0;i < paths.length;i++) {
		paths_[i + 1] = paths[i];
	    }
	    current_ = paths_[0];
	}

	// ComboBoxModel
	public void setSelectedItem(Object item) {
	    current_ = (TreePath)item;
	    fireContentsChanged(this, -1, -1);
	    setSelection((TreePath)item);
	}

	// ComboBoxModel
	public Object getSelectedItem() {
	    return (current_);
	}

	// AbstractListModel
	public Object getElementAt(int index) {
	    return (paths_[index]);
	}

	// AbstractListModel
	public int getSize() {
	    return (paths_.length);
	}

	// ShorcutListModel
	public void notifySelection(TreePath path) {
	    for (int i = 1;i < paths_.length;i++) {
		if (path.equals(paths_[i])) {
		    _setSelectedItem(path);
		    return;
		}
	    }
	    _setSelectedItem(paths_[0]);
	}

	protected void _setSelectedItem(Object obj) {
	    current_ = (TreePath)obj;
	    fireContentsChanged(this, -1, -1);
	}
    }

    // test driver
    public static void main(String[] args) throws Exception {
	javax.swing.JFrame frame
	    = new javax.swing.JFrame("ExplorerPanel test");
	frame.addWindowListener(
	    new jp.gr.java_conf.jaba2.awt.ExitWhenWindowClosing()
	);
	ExplorerPanel panel = new ExplorerPanel(
	    new FileExplorerModel(new java.io.File("."))
	);
//	panel.setView(new JButton("view"));
	frame.getContentPane().add(panel);
	frame.pack();
	frame.show();
    }
}
