/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998,1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.sample;

import java.util.*;
import java.io.*;
import jp.gr.java_conf.jaba2.util.ParameterInfo;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * SampleConfig
 *
 * @since   Apr. 24, 1999
 * @version Aug. 30, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class SampleConfig extends AbstractSmartDocFormatConfig {
    // SmartDocFormatConfig
    public void setup(SmartDocConfig config, String[] args)
	throws IOException {

	ParameterInfo info = new AppParameterInfo(
	    "jp.gr.java_conf.jaba2.SmartDoc",
	    args,
	    "jp.gr.java_conf.jaba2.SmartDoc.sample.SampleDefaults",
	    new File("SmartDoc.properties")
	);
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.sample");
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.sample.handler");
	_init(config, "sample", info);
    }

    // SmartDocFormatConfig
    public String getID() {
	return ("sample");
    }

    // SmartDocFormatConfig
    public String getName() {
	return ("Sample");
    }

    // SmartDocFormatConfig
    public String[] getImageCandidates() {
	return (new String[] { "gif", "jpeg" });
    }
}
