/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.normalizer;

import java.util.*;
import org.apache.oro.text.perl.Perl5Util;
import jp.gr.java_conf.jaba2.util.RangeManager;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * ConsoleNormalizer
 *
 * @since   Aug. 13, 1999
 * @version Oct. 17, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class ConsoleNormalizer extends AbstractNormalizer {
    protected Content[] _normalize(
	Content[] contents,
	Content parent,
	DocContext context
    ) {
	String text = UDoc.makeInlineText((Container)parent);
	String prompt = UString.checkNull(
	    parent.getAttribute("consolePrompt")
	);
	if (prompt == null) {
	    prompt = ">";
	}
	String promptRegex = UString.checkNull(
	    parent.getAttribute("consolePromptRegex")
	);
	String promptRange = UString.checkNull(
	    parent.getAttribute("consolePromptRange")
	);
	if (promptRange == null) {
	    promptRange = "1";
	}
	RangeManager range = new RangeManager(promptRange);
	if (promptRegex != null) {
	    parent.setText(null);
	    return (_makeConsoleByPromptRegex(text, promptRegex, range));
	} else {
	    parent.setText(null);
	    return (_makeConsoleByPrompt(text, prompt, range));
	}
    }

    private Content[] _makeConsoleByPromptRegex(
	String text,
	String regex,
	RangeManager range
    ) {
	regex = "#" + regex + "#m";
	Perl5Util util = new Perl5Util();
	List list = new ArrayList();
	String[] lines = UString.makeTrimedStringList(text);
	String em = null;
	for (int i = 0;i < lines.length;i++) {
	    String line = lines[i];
	    if (range.isValid(i + 1)) {
		if (util.match(regex, line)) {
		    String prompt = util.toString();
		    int index = line.indexOf(prompt);
		    if (index == -1) {
			throw (new InternalError());
		    }
		    int inputIndex = index + prompt.length();
		    list.add(new CharBlock(
			line.substring(index, inputIndex)
		    ));
		    Span span = new Span();
		    span.setClazz("kbd");
		    span.addContent(new CharBlock(
			line.substring(inputIndex)
		    ));
		    list.add(span);
		    list.add(new CharBlock("\n"));
		} else {
		    list.add(new CharBlock(line + "\n"));
		}
	    } else {
		list.add(new CharBlock(line + "\n"));
	    }
	}
	return ((Content[])UDoc.list2Contents(list));
    }

    private Content[] _makeConsoleByPrompt(
	String text,
	String prompt,
	RangeManager range
    ) {
	List list = new ArrayList();
	String[] lines = UString.makeTrimedStringList(text);
	String em = null;
	for (int i = 0;i < lines.length;i++) {
	    String line = lines[i];
	    if (range.isValid(i + 1)) {
		int index = line.indexOf(prompt);
		if (index != -1) {
		    int inputIndex = index + prompt.length();
		    int lineLength = line.length();
		    for (;;) {
			if (inputIndex >= lineLength) {
			    break;
			}
			if (line.charAt(inputIndex) == ' ') {
			    inputIndex++;
			} else {
			    break;
			}
		    }
		    list.add(new CharBlock(
			line.substring(0, inputIndex)
		    ));
		    if (inputIndex < lineLength) {
			Span span = new Span();
			span.setClazz("kbd");
			span.addContent(new CharBlock(
			    line.substring(inputIndex)
			));
			list.add(span);
		    }
		    list.add(new CharBlock("\n"));
		} else {
		    list.add(new CharBlock(line + "\n"));
		}
	    } else {
		list.add(new CharBlock(line + "\n"));
	    }
	}
	return ((Content[])UDoc.list2Contents(list));
    }
}
