/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2002  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc;

import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.text.UString;

/**
 * Ref
 *
 * @since   Oct. 25, 1998
 * @version Jan.  8, 2002
 * @author  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 */
public class Ref extends Container {
    public static final int SELF_LINK = 1;
    public static final int HYPER_LINK = 2;
    public static final int UNKNOWN_LINK = 3;

    protected int type_;
    protected String href_;

    public Ref(Element element) {
	super(element);
	String href = UString.checkNull(element.getAttribute("href"));
	if (href != null) {
	    setHref(href);
	} else if (idref_ != null) {
	    setSelfLink(idref_);
	} else {
	    type_ = UNKNOWN_LINK;
	}
    }

    public Ref(String href) {
	setHref(href);
    }

    public Ref(Content content) {
	setLink(content);
    }

    // Content
    public int getEntityType() {
	return (ENTITY_INLINE);
    }

    public void setHref(String href) {
	if (href.charAt(0) == '#') {
	    setSelfLink(href.substring(1)); // XXX : modify
	} else {
	    setHyperLink(href);
	}
    }

    public void setSelfLink(String idref) {
	type_ = SELF_LINK;
	href_ = idref;
    }

    public void setHyperLink(String href) {
	type_ = HYPER_LINK;
	href_ = href;
    }

    public void setLink(Content link) {
	super.setLink(link);
//	href_ = "#" + link.getID();  XXX : really ok
	href_ = link.getID();
	type_ = SELF_LINK;
    }

    public int getType() {
	return (type_);
    }

    public String getHref() {
	return (href_);
    }
}
