/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.l2fprod.gui.nativeskin.NativeSkin;
import com.l2fprod.gui.region.Region;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NativeSplashScreen
extends Window
implements KeyListener,
MouseListener,
ActionListener {
    public NativeSplashScreen(Frame parent, ImageIcon icon, int timeout) {
        super(parent);
        this.setLayout(new BorderLayout());
        JLayeredPane layer = new JLayeredPane();
        JLabel picture = new JLabel(icon);
        layer.add((Component)picture, JLayeredPane.DEFAULT_LAYER);
        layer.setPreferredSize(picture.getPreferredSize());
        picture.setSize(picture.getPreferredSize());
        this.add("Center", layer);
        if (NativeSkin.isSupported()) {
            final NativeSkin builder = NativeSkin.getInstance();
            Region region = builder.createRegion(icon.getImage());
            builder.setWindowRegion((Window)this, region, true);
            builder.setAlwaysOnTop((Window)this, true);
            final JSlider slider = new JSlider(10, 255);
            layer.add((Component)slider, JLayeredPane.PALETTE_LAYER);
            slider.setMajorTickSpacing(20);
            slider.setSnapToTicks(true);
            slider.setBounds(327, 147, 150, 20);
            slider.setOpaque(false);
            slider.setDoubleBuffered(false);
            builder.setWindowTransparency((Window)this, slider.getValue());
            slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    builder.setWindowTransparency((Window)NativeSplashScreen.this, slider.getValue());
                }
            });
        } else {
            System.err.println("NativeSkin not supported on this platform");
        }
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
        this.addKeyListener(this);
        this.addMouseListener(this);
        if (parent != null) {
            parent.addMouseListener(this);
        }
        Timer timer = new Timer(0, this);
        timer.setRepeats(false);
        timer.setInitialDelay(timeout);
        timer.start();
    }

    public synchronized void block() {
        while (this.isVisible()) {
            try {
                this.wait(5L);
            }
            catch (Exception exception) {}
        }
    }

    public void setVisible(boolean b) {
        if (!b) {
            NativeSkin.getInstance().setWindowTransparency((Window)this, 255);
        }
        super.setVisible(b);
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        this.setVisible(false);
        this.dispose();
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.dispose();
    }
}

