<?php

###############################################################################
#                      ALLbum-1.0.0: admin.php  
#                (SAS maintainer interface component) 
# 
# ALLbum-1.0.0 is a module for the Content Management System 
# "Site@School"  (http://siteatschool.sourceforge.net).  
# 
# ALLbum is written by Martin Herrman <m.herrman@student.tue.nl>  
# ALLbum is copyrighted by OBS Rosa Boekdrukker, Amsterdam, The Netherlands
# (http://www.rosaboekdrukker.nl)  
# ALLbum is licenced by GNU General Public Licence 
###############################################################################
# admin.php: last changed 12/07/2006 2.4.10     
#                    by Fred Stuurman (fc.stuurman@hccnet.nl)
#$Id: admin.php,v 1.2 2006/10/15 19:08:54 fstuurman Exp $ 
# Multiple file upload applet postlet used is from http://sourceforge.net/projects/postlet/
############################################################################
#                        LICENSE INFORMATION
# Copyright (C) 2002 - 2005 Municipality of Amsterdam, City District
#  'de Baarsjes', Amsterdam, the Netherlands.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################
if (!defined('IN_SAS'))
{
	die("Hacking attempt");
}

// use language file:
if (file_exists("languages/$language/sn_allbum/$language.php"))
{
	include ("languages/$language/sn_allbum/$language.php");
}
else
{
	include ("languages/EN/sn_allbum/EN.php");
}

//load_language('','sn_allbum') ;		//load language file

// include shared functions:
include ("modules/sn_allbum/shared.inc.php");

// include private functions:
include ("modules/sn_allbum/admin.inc.php");

include ("interface/header.inc.php");
include ("interface/menubar.inc.php");
include ("interface/menustart.inc.php");

// what should we do? :
if (IsSet ($_GET[suboption2]))
{
	if ($_GET[suboption2] == hide)
	{
		db_PutHideObject($_GET[ID2]);
	}
	elseif ($_GET[suboption2] == unhide)
	{
		db_PutUnhideObject($_GET[ID2]);
	}
	elseif ($_GET[suboption2] == select)
	{
		// skip
	}
	elseif ($_GET[suboption2] == delete)
	{
		db_PutDeleteObjects($_GET[ID3]);
		$_GET[suboption2] = "";
		$_GET[ID3] = "";
	}
	$_GET[suboption] = show;
}
if ($_GET[suboption] == show)
{
	if (IsSet ($_GET[ID]) AND IsSet ($_GET[gallerypage]))
	{
		if ($_GET[ID] != 0)
		{
			$type = db_GetType($_GET[ID]);
			if (($type == 'album') or ($type == 'subalbum'))
			{
				ShowMenu(1, 1, 1, 1, 1, 1, 1);
			}
			else
			{
				ShowMenu(1, 0, 0, 1, 0, 0, 0);
			}
		}
		else
		{
			ShowMenu(1, 1, 0, 1, 1, 1, 1);
		}
		include ("interface/menuend.inc.php");
		include ("interface/pagestart.inc.php");
		ShowContent2($_GET[ID], $_GET[gallerypage]);
	}
	else
	{
		ShowMenu(1, 1, 0, 1, 1, 1, 1);
		include ("interface/menuend.inc.php");
		include ("interface/pagestart.inc.php");
		ShowContent2(0, 1);
	}
}
elseif ($_GET[suboption] == config)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowConfig();
}
elseif ($_GET[suboption] == createalbum)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowCreateAlbum();
}
elseif ($_GET[suboption] == addobject)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowAddObject();
}
elseif ($_GET[suboption] == edit)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowEdit();
}
elseif ($_GET[suboption] == ordersub)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowOrderSub();
}
elseif ($_GET[suboption] == ordermain)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowOrderMain();
}
elseif ($_GET[suboption] == move)
{
	ShowMenu(1, 0, 0, 0, 0, 0, 0);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowMove();
}
else
{
	ShowMenu(1, 1, 0, 1, 1, 1, 1);
	include ("interface/menuend.inc.php");
	include ("interface/pagestart.inc.php");
	ShowContent2(0, 1);
}

include ("interface/pageend.inc.php");
include ("interface/footer.inc.php");

function ShowMenu($main, $add_album, $add_object, $configuration, $editdelete, $selectall, $order)
{
	global $sas_lang;
	global $sas_config;
	global $module;
	global $ID;
	global $ID3;
	global $navpath;

	if ((count(db_GetContents($_GET[ID])) == 0) AND (($_GET[suboption] == "show") OR (!IsSet ($_GET[suboption]))) AND (in_array(db_GetType($_GET[ID]), array (
			'subalbum',
			'album',
			'main'
		))))
	{
		$main = 1;
		$add_album = 1;
		$add_object = 1;
		$configuration = 1;
		$editdelete = 0;
		$selectall = 0;
		$order = 0;
	}

	echo "<span class=\"heading\">" . $sas_lang[sn_allbum_menu] . "</span><p><p>";
	if ($main == 1)
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show\">" . $sas_lang[sn_allbum_main] . "</a></span><p>";
	}
	if ($add_album == 1)
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=createalbum&ID=" . $_GET[ID] . "\">" . $sas_lang[sn_allbum_create_album] . "</a></span><p>";
	}
	if ($add_object == 1)
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=addobject&ID=" . $_GET[ID] . "\">" . $sas_lang[sn_allbum_add_object] . "</a></span><p>";
	}

	if ($selectall == 1)
	{
		// Show (de)select all option:
		if (IsSet ($_GET[gallerypage]))
		{
			$page2 = $_GET[gallerypage];
		}
		else
		{
			$page2 = 1;
		}

		if (IsSet ($_GET[ID]))
		{
			$id2 = $_GET[ID];
		}
		else
		{
			$id2 = 0;
		}
		$contents2 = db_GetContents($id2);
		$items2 = array ();
		$max_objects_per_page = $sas_config['allbum_max_objects_per_page'];
		$num = count($contents2);

		for ($i = (($page2 -1) * $max_objects_per_page) + 1;($i <= ($page2 * $max_objects_per_page)) AND ($i <= $num); $i++)
		{
			array_push($items2, $contents2[$i -1]);
		}

		$items2string = implode(",", $items2);

		$selectedstring = $_GET[ID3];
		if ($selectedstring == "")
		{
			$selectedarray = array ();
		}
		else
		{
			$selectedarray = explode(",", $selectedstring);
			$selectedarray = array_clean($selectedarray, "");
		}

		if (count($selectedarray) == count($items2))
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] .
			"&suboption=show&ID=" . $id2 . "&ID3=&gallerypage=" . $page2 . "\">" . $sas_lang[sn_allbum_deselect_all] . "</a></span><p>";
		}
		else
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] .
			"&suboption=show&ID=" . $id2 . "&ID3=" . $items2string . "&gallerypage=" . $page2 . "\">" . $sas_lang[sn_allbum_select_all] . "</a></span><p>";
		}

	}
	if ($order == 1)
	{
		// show order option:
		if ((IsSet ($_GET[ID])) AND ($_GET[ID] != "") AND ($_GET[ID] > "0"))
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] .
			"&suboption=ordersub&ID=" . $_GET[ID] . "&gallerypage=" . $_GET[gallerypage] . "\">" . $sas_lang[sn_allbum_order_objects] . "</a></span><p>";
		}
		else
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] .
			"&suboption=ordermain&ID=" . $_GET[ID] . "&gallerypage=" . $_GET[gallerypage] . "\">" . $sas_lang[sn_allbum_order_objects] . "</a></span><p>";
		}
	}
	if ($editdelete == 1)
	{
		// Show edit / delete option:

		// Get titlename and "empty or not" for all selected items:
		$items = explode(",", $_GET[ID3]);
		$items2dim = array ();
		foreach ($items AS $key => $value)
		{
			if ($value != "")
			{
				$items2dim[$key][0] = db_GetTitle($value);
				$items2dim[$key][1] = db_GetEmpty($value);
			}
		}

		// make warning message text:
		$message = $sas_lang[sn_allbum_are_you_sure] . "\\n";
		foreach ($items2dim AS $key => $value)
		{
			$message = $message . " " . addslashes($value[0]) . "\\n";
		}
		$i = 0;
		foreach ($items2dim AS $key => $value)
		{
			if ($value[1] == "no")
			{
				if ($i == 0)
				{
					$message = $message . $sas_lang[sn_allbum_not_empty] . "\\n";
					$i++;
				}
				$message = $message . " " . addslashes($value[0]) . "\\n";
			}
		}

		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=edit&ID=" . $_GET[ID] . "&ID3=" . $_GET[ID3] . "&gallerypage=" . $_GET[gallerypage] . "\">" . $sas_lang[sn_allbum_edittitdesc] . "</a></span><p>";
		if ($message == $sas_lang[sn_allbum_are_you_sure] . "\\n")
		{
			echo "<span class=\"link\"><a href=\"javascript: void(0)\" OnClick='alert(\"" . $sas_lang[sn_allbum_please_select] . "\")'\">" . $sas_lang[sn_allbum_deleteselecteditems] . "</a></span><p>";
		}
		else
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=move&ID=" . $_GET[ID] . "&ID3=" . $_GET[ID3] . "&gallerypage=" . $_GET[gallerypage] . "\">" . $sas_lang[sn_allbum_move_selected] . "</a></span><p>";
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=show&suboption2=delete&ID3=" . $_GET[ID3] . "&ID=" . $_GET[ID] . "&gallerypage=" . $_GET[gallerypage] . "\" 
							OnClick=\"return confirm('$message')\">" . $sas_lang[sn_allbum_deleteselecteditems] . "</a></span><p>";
		}
	}
	if ($configuration == 1)
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=config\">" . $sas_lang[sn_allbum_configuration] . "</a></span><p>";
	}

}

function ShowEdit()
{
	// Task: show a page with on each row a thumbnail and edit title/description
	// field. At the bottom a save and cancel button. Show objects on $_GET[ID]
	// and $_GET[gallerypage], if one of them is empty or not set, show first
	// main page contents. If one or more objects are selected, show only the
	// selected objects.

	global $ID;
	global $gallerypage;
	global $sas_config;
	global $sas_lang;
	global $module;
	global $content;
	global $ID3;
	global $navpath;
	global $allbum_table;

	// in case ID and Gallerypage are not set, make sure contents on first main page
	// is shown:
	if ((!IsSet ($_GET[ID])) OR ($_GET[ID] == ""))
	{
		$_GET[ID] = 0;
		$_GET[gallerypage] = 1;
	}

	// If items are selected, show only these selected items:
	if ((IsSet ($_GET[ID3])) AND ($_GET[ID3] != "") AND ($_GET[ID3] != ","))
	{
		$contents = explode(",", $_GET[ID3]);
		$contents = array_clean($contents, "");
	}
	else
	{
		// Get list of $ID's contents:
		$contents = db_GetContents($_GET[ID]);
	}
	// If new titles and descriptions are entered, verify them for correctness:
	if (IsSet ($_GET[content]))
	{
		// Get all changed object ID's:
		$content = explode("X", $_GET[content]);
		array_pop($content);
		// Verify them:
		$verified = array (
			"ok",
			"",
			""
		);
		foreach ($content AS $key => $value)
		{
			// get new title and description:
			$titleget = $value . "title";
			$descget = $value . "description";
			global ${ $titleget };
			global ${ $descget };
			$newtitle = $_GET[$titleget];
			$newdescription = $_GET[$descget];
			if (($newtitle == ".") OR ($newtitle == ".."))
			{
				$verified[0] = "nok";
				$verified[1] = $newtitle;
				$verified[2] = "dirtitle";
				break;
			}
			elseif (strlen($newdescription) > 1000)
			{
				$verified[0] = "nok";
				$verified[1] = $newtitle;
				$verified[2] = "lendesc";
				break;
			}
		}
	}

	// Check if the list is empty:
	if (!IsSet ($contents[0]))
	{
		echo "<form action=\"index.php\" method=\"get\">";
		echo "<table>";
		echo "<tr><td colspan=\"2\"><p><span class=\"text\">" . $sas_lang[sn_allbum_empty_album] . "</span></p></td></tr>";
		echo "<tr><td colspan=\"2\"><p><BR>
					<input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" 
					onClick=\"javascript:history.go(-1)\" class=\"backbutton\">";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"show\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
		echo "<INPUT type=\"hidden\" name=\"navpath\" value=\"" . $_GET[navpath] . "\">";
		echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"" . $_GET[gallerypage] . "\">";
		echo "</td></tr>";
		echo "</table>";

	}
	elseif (!IsSet ($_GET[content]) OR ($verified[0] == "nok"))
	{
		// Calculate which children should be shown on page $_GET[gallerypage]:
		$num = count($contents);
		$show = array ();
		$max_objects_per_page = $sas_config['allbum_max_objects_per_page'];

		if ($_GET[ID3] == "") //we have not selected any object
		{
			for ($i = (($_GET[gallerypage] - 1) * $max_objects_per_page) + 1;($i <= ($_GET[gallerypage] * $max_objects_per_page)) AND ($i <= $num); $i++)
			{
				array_push($show, $contents[$i -1]);
			}
		}
		else
		{ //we have selected certain objects.
			for ($i = 0;($i < count($contents)); $i++)
			{
				array_push($show, $contents[$i]);
			}
		}

		// heading:
		echo "<p><span class=\"heading\">" . $sas_lang[sn_allbum_edittitdesc] . "</span></p>";

		// Show error message if applicable:
		if ($verified[0] == "nok")
		{
			echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_object_with_title] . $verified[1];
			if ($verified[2] == "dirtitle")
			{
				echo $sas_lang[sn_allbum_is_or];
			}
			elseif ($verified[2] == "lendesc")
			{
				echo $sas_lang[sn_allbum_has_description];
			}
			echo $sas_lang[sn_allbum_which_is_not] . "</span></p>";
		}

		// start form:
		echo "<form action=\"index.php\" method=\"get\">";

		$content = "";
		foreach ($show AS $key => $value)
		{
			$content = $content . $value . "X";
		}

		// start table:
		echo "<table>";

		// horizontal line:
		echo "<tr><td align=\"center\" colspan=\"3\"><HR width=\"95%\"></td></tr>";

		// Show each object:
		$x = $sas_config['allbum_thumbsize_x'];
		foreach ($show AS $key => $value)
		{

			// Start row:
			echo "<tr>";

			// Get all details array[type, title, description, path, thumb, parent, children, hidden] for first object:
			$details = db_GetAllDetails($value);

			$image = str_replace("//", "/", $details[3] . "/" . $details[4]);
			$tmp = explode(".", $details[4]);
			$ext = array_pop($tmp);
			$name = implode(".", $tmp);
			$thumb = str_replace("//", "/", $details[3] . "/" . $name . "_t." . $ext);
			if (file_exists($details[4]))
			{ //we have an empty allbum with empty.gif path
				$path = $details[4];
			}
			else
			{
				if (file_exists($thumb))
				{
					// thumbnail exists
					$path = $thumb;
				}
				else
				{
					$path = $image;
				}
			}
			// Show object:

			echo "<td rowspan=\"2\" align=\"center\">
				             <img src=\"" . $path . "\" width=\"" . $x . "\">
					  <p><span class=\"text\">";
			if (($details[0] == "subalbum") OR ($details[0] == "album"))
			{
				echo "<STRONG>" . $sas_lang[sn_allbum_album] . "</STRONG>";
			}
			else
			{
				echo "&nbsp;";
			}
			echo "</span>
					 </p>
				      </td>";

			// Show edit fields:
			echo "<td valign=\"top\">";
			if (IsSet ($verified))
			{
				$titleget = $value . "title";
				$descget = $value . "description";
				global ${ $titleget };
				global ${ $descget };
				$showntitle = $_GET[$titleget];
				$showndescription = stripslashes($_GET[$descget]);
			}
			else
			{
				$showntitle = $details[1];
				$showndescription = $details[2];
			}

			if (($details[0] != "album") AND ($details[0] != "subalbum"))
			{
				if (strpos($title, ".")) //object title has extention?
				{
					$showntitle = explode(".", $showntitle);
					array_pop($showntitle);
					$showntitle = implode(".", $showntitle);
				}
			}
			echo "<span class=\"text\">" . $sas_lang[sn_allbum_title] . ": </span></td><td valign=\"top\">
				          <input name=\"" . $value . "title\" size=\"70\" value=\"" . $showntitle . "\">
				          </td><tr><td valign=\"top\">
					  <span class=\"text\">" . $sas_lang[sn_allbum_description] . ": </span></td><td valign=\"top\"><TEXTAREA name=\"" . $value . "description\" cols=\"45\" rows=\"5\">" . $showndescription . "</TEXTAREA>";
			echo "</td></tr>";

			// close row:
			echo "</tr>";
			if (($details[0] == "album") OR ($details[0] == "subalbum"))
			{
				$query = "SELECT thumb FROM $allbum_table WHERE parent='$details[9]' AND type = 'picture'";
				//print $query;
				$result = mysql_query($query) or die(mysql_error() . $query);
				if (mysql_num_rows($result) > 0)
				{ //if we have 1 or more pictures present the select menu
					print "<tr><td>&nbsp;</td><td><span class=\"text\">" . $sas_lang['sn_allbum_home_picture'] . "</span></td><td>";
					print "<select size=\"1\" name=\"" . $value . "picture\">\n";
					while ($row = mysql_fetch_array($result))
					{
						if ($row[0] == $details[4])
						{
							echo "<option selected value=\"$row[0]\">$row[0]</option>\n";
						}
						else
						{
							echo "<option value=\"$row[0]\">$row[0]</option>\n";
						}
					}
					print "</select></td></tr>";
				}
				if ($details[0] == "album")
				{
					print "<tr><td>&nbsp;</td><td><br><span class=\"text\">" . $sas_lang['sn_allbum_category_is_page'] . "</span></td><td><br><span class=\"text\">&nbsp;" . $sas_lang['yes'];
					if ($details[8] == "1") //ispage field
					{
						print "</span><input type=\"radio\" value=\"1\" name=\"" . $value . "ispage\" checked>";
						print "<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>";
						print "<input type=\"radio\" name=\"" . $value . "ispage\" value=\"0\">";
					}
					else
					{
						print "</span><input type=\"radio\" value=\"1\" name=\"" . $value . "ispage\">";
						print "<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>";
						print "<input type=\"radio\" name=\"" . $value . "ispage\" value=\"0\" checked>";
					}
					print "</td></tr>";
					print "<tr><td>&nbsp;</td><td><br><span class=\"text\">" . $sas_lang['sn_allbum_category_is_public'] . "</span></td><td><br><span class=\"text\">&nbsp;" . $sas_lang['yes'];
					if ($details[10] == "1") //public field
					{
						print "</span><input type=\"radio\" value=\"1\" name=\"" . $value . "ispublic\" checked>";
						print "<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>";
						print "<input type=\"radio\" name=\"" . $value . "ispublic\" value=\"0\">";
					}
					else
					{
						print "</span><input type=\"radio\" value=\"1\" name=\"" . $value . "ispublic\">";
						print "<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>";
						print "<input type=\"radio\" name=\"" . $value . "ispublic\" value=\"0\" checked>";
					}
					print "</td></tr>";
				}
			}
			// Show horizontal line:
			echo "<tr><td align=\"center\" colspan=\"3\"><HR width=\"95%\"></td></tr>";

		}

		// show save and cancel button:
		echo "<tr><td colspan=\"3\">
			    <p><span class=\"text\">
			    <input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" onClick=\"javascript:history.go(-1)\" class=\"backbutton\"> 
			    &nbsp;<INPUT type=\"submit\" class=\"savebutton\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang[sn_allbum_save] . "\">
			    </span></p>
			    </td></tr>";

		// close table:
		echo "</table>";
		echo "<INPUT type=\"hidden\" name=\"content\" value=\"" . $content . "\">";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"edit\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
		echo "<INPUT type=\"hidden\" name=\"ID3\" value=\"" . $_GET[ID3] . "\">";
		echo "<INPUT type=\"hidden\" name=\"navpath\" value=\"" . $_GET[navpath] . "\">";
		echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"" . $_GET[gallerypage] . "\">";

		// end form:
		echo "</form>";
	}
	else
	{
		// Get all changed object ID's:
		$content = explode("X", $_GET[content]);
		array_pop($content);

		// update each object:
		$check = "ok";
		foreach ($content AS $key => $value)
		{
			// get new and old title and description:
			$titleget = $value . "title";
			$descget = $value . "description";
			$ispageget = $value . "ispage";
			$is_publicget = $value . "ispublic";
			$pictureget = $value . "picture";
			global ${ $titleget };
			global ${ $descget };
			global ${ $ispageget };
			global ${ $pictureget };
			global ${ $is_publicget };
			$oldtitle = db_GetTitle($value);
			$oldpicture = db_GetThumb($value);
			$newtitle = $_GET[$titleget];
			$newispage = $_GET[$ispage];
			$newpicture = $_GET[$pictureget];
			$newpublic = $_GET[$is_publicget];
			// seperate (sub-) albums from other objects:
			$type = db_GetType($value);
			if (($type == 'album') OR ($type == 'subalbum'))
			{

				// *(sub-)album*

				// check if new title doesn't already exist:
				if ($_GET[ID] == 0)
				{
					$a = -1;
				}
				else
				{
					$a = $_GET[ID];
				}
				if ((db_GetAlbumExists(stripslashes($_GET[$titleget]), $a) === true) AND ($oldtitle != stripslashes($newtitle)))
				{
					$check == "nok";
					echo $sas_lang[sn_allbum_non_fatal] . $oldtitle . $sas_lang[sn_allbum_cannot] . $newtitle . $sas_lang[sn_allbum_because];
					continue;
				}
				else
				{
					// rename directory
					$olddir = db_GetPath($value);
					$newdir = explode("/", $olddir);
					array_pop($newdir);
					$newdir = implode("/", $newdir);
					# Remove spaces, apostrophe, exclamation marks for the path .
					$str_from = " \'@!,\t\*?`\"";
					$str_to = str_repeat("_", strlen($str_from));
					$path = strtr(stripslashes($_GET[$titleget]), $str_from, $str_to);
					$newdir = $newdir . "/" . $path;
					if (strcmp($olddir, $newdir) != 0)
					{
						rename($olddir, $newdir);
					}
					// update database entries:
					// - own title and description
					db_PutTitleDescriptionObject($value, $_GET[$titleget], $_GET[$descget], $_GET[$ispageget], $_GET[$pictureget], $_GET[$is_publicget]);

					// - own path
					db_PutPathObject($value, $newdir);

					// update children (recursive) database entries (path)
					$level = db_GetLevel($value);
					db_PutChildrenPath($value, $path, $level, $type);
					// if available, update parent:
					if ($type != "album")
					{
						db_PutParentPath($value, $path, 0, $type);
					}
				}
			}
			else
			{

				// *other object type*

				// get file-extension
				$tmp = $oldpicture;
				$tmp = explode(".", $tmp);
				$ext = array_pop($tmp);
				$oldfile = $tmp[0];

				# Remove spaces, apostrophe, exclamation marks for the path .
				$str_from = " \'@!,\t\*?`\"";
				$str_to = str_repeat("_", strlen($str_from));
				$newfile = strtr($_GET[$titleget], $str_from, $str_to);

				// - file
				$dir = db_GetPath($value);
				$src = $dir . $oldpicture;
				$dest = $dir . $newfile . "." . $ext;
				// rename file:
				rename($src, $dest);

				// - thumb
				$newpicture = $newfile . "." . $ext;
				$oldthumb = $dir . $oldfile . "_t." . $ext;
				$newthumb = $dir . $newfile . "_t." . $ext;

				if (file_exists($oldthumb))
				{
					rename($oldthumb, $newthumb);
				}

				// update own entry:
				db_PutTitleDescriptionObject($value, $_GET[$titleget], $_GET[$descget], $_GET[$ispageget], $newpicture);
				// update thumbfiles of parent(s) entrie(s):
				db_PutIfNeededUpdateParentThumb(db_GetParentID($value));
			}

		}
		if ($check == "nok")
		{
			// show error message
			echo $sas_lang[sn_allbum_check_error] . "<a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&navpath=" . $_GET[navpath] . "&ID=" . $_GET[ID] . "&gallerypage=1\" target=\"_self\">" . $sas_lang[sn_allbum_here] . "</a>" . $sas_lang[sn_allbum_to_proceed];
		}
		else
		{
			// javascript to reload page
			echo $sas_lang[sn_allbum_no_errors];
			echo "<script language='javascript'>
					  window.location = 'index.php?option=modulemanager&module=" . $module . "&suboption=show&navpath=" . $_GET[navpath] . "&ID=" . $_GET[ID] . "&gallerypage=" . $_GET[gallerypage] . "'
					  </script>";
			echo $sas_lang[sn_allbum_error_redirect];
		}
	}
}

function ShowContent2($ID, $gpage)
{
	// Task: show object with ID $ID except when $ID = 0, then a main page
	// should be shown;
	// When $ID is not a (sub-)album or a main page, $page is -1. Otherwise,
	// $page is the page number that should be shown.

	global $sas_lang;
	global $sas_config;
	global $module;
	global $navpath;

	// Get all details:
	// array[type, title, description, path, thumb, parent, children, hidden]
	$details = db_GetAllDetails($ID);

	$objects = array (
		'sound',
		'movie',
		'doc',
		'unknown'
	);

	if (in_array($details[0], $objects))
	{
		// **sound-file, movie-file, document-file, unknown-file**
		// calculate next and previous picture:
		$albumcontents = array_clean(explode(",", $_GET[contents]), "");
		$i = 0;
		while ($albumcontents[$i] != $ID)
		{
			$i++;
		}

		if ($i == count($albumcontents) - 1)
		{
			$nextobjectid = $albumcontents[0];
		}
		else
		{
			$nextobjectid = $albumcontents[$i +1];
		}

		if ($i == 0)
		{
			$prevobjectid = $albumcontents[count($albumcontents) - 1];
		}
		else
		{
			$prevobjectid = $albumcontents[$i -1];
		}

		// Show navigation bar:
		ShowNavPath($_GET[navpath], false);

		// Show page (title, image, description, navigation buttons):
		$iconpath = $details[4];
		$filepath = str_replace("//", "/", $details[3] . "/" . $details[1]);
		echo "<table width=\"95%\" align=\"center\" border=\"0\">";
		echo "<tr>";
		echo "<td align=\"center\">";
		echo "<a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&navpath=" . $_GET[navpath] . "&contents=" . $_GET[contents] . "&ID=" . $prevobjectid . "&gallerypage=1\"><img border=\"0\" title=\"" . $sas_lang[sn_allbum_previous_object] . "\" src=\"modules/sn_allbum/nav_prev_icon.gif\"></a>";
		echo "</td><td align=\"center\" width=\"" . $width . "\">";
		echo "<p><span class=\"heading\">" . $details[1] . "</span></p>";
		echo "<img src=\"" . $iconpath . "\">";
		echo "<div align=\"center\"><p><span class=\"link\"><a href=\"" . $filepath . "\">" . $sas_lang[sn_allbum_download_file] . "</a></span></p></div>";
		echo "<div align=\"left\"><p><span class=\"text\">" . $details[2] . "</span></p></div>";
		echo "</td><td align=\"center\">";
		echo "<a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&navpath=" . $_GET[navpath] . "&contents=" . $_GET[contents] . "&ID=" . $nextobjectid . "&gallerypage=1\"><img border=\"0\" title=\"" . $sas_lang[sn_allbum_next_object] . "\" src=\"modules/sn_allbum/nav_next_icon.gif\"></a>";
		echo "</td>";
		echo "</tr></table>";

		// Show options
		echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_options] . "</span></p>";
		if ($details[7] == 0)
		{
			echo "<p><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&suboption2=hide&ID=" . $ID . "&ID2=" . $ID . "&gallerypage=-1\">" . $sas_lang[sn_allbum_hide] . "</a></span></p>";
		}
		else
		{
			echo "<p><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&suboption2=unhide&ID=" . $ID . "&ID2=" . $ID . "&gallerypage=-1\">" . $sas_lang[sn_allbum_unhide] . "</a></span></p>";
		}

		return 0;
	}

	$objects = array (
		'picture'
	);

	if (in_array($details[0], $objects))
	{

		// **picture**
		// Get object size options:
		$width = $sas_config['allbum_picsize_x'];
		//$width = db_GetPicSizeX();

		// calculate next and previous picture:
		$albumcontents = array_clean(explode(",", $_GET[contents]), "");
		$i = 0;
		while ($albumcontents[$i] != $ID)
		{
			$i++;
		}
		if ($i == count($albumcontents) - 1)
		{
			$nextobjectid = $albumcontents[0];
		}
		else
		{
			$nextobjectid = $albumcontents[$i +1];
		}
		if ($i == 0)
		{
			$prevobjectid = $albumcontents[count($albumcontents) - 1];
		}
		else
		{
			$prevobjectid = $albumcontents[$i -1];
		}

		// Show navigation bar:
		ShowNavPath($_GET[navpath], false);

		// Calculate width:
		$image = str_replace("//", "/", $details[3] . "/" . $details[4]);
		$size = getimagesize($image);
		if ($size[0] < $size[1])
		{
			// portrait
			$width = $width / 1.3;
		}

		// Show page (title, image, description, navigation buttons):
		echo "<table width=\"95%\" align=\"center\" border=\"0\">";
		echo "<tr>";
		echo "<td align=\"center\">";
		echo "<a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&navpath=" . $_GET[navpath] . "&contents=" . $_GET[contents] . "&ID=" . $prevobjectid . "&gallerypage=1\"><img border=\"0\" title=\"" . $sas_lang[sn_allbum_previous_object] . "\" src=\"modules/sn_allbum/nav_prev_icon.gif\"></a>";
		echo "<a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&navpath=" . $_GET[navpath] . "&contents=" . $_GET[contents] . "&ID=" . $nextobjectid . "&gallerypage=1\"><img border=\"0\" title=\"" . $sas_lang[sn_allbum_next_object] . "\" src=\"modules/sn_allbum/nav_next_icon.gif\"></a>
				</td><td align=\"center\" width=\"95%\">";
		$heading = explode(".", $details[1]);
		array_pop($heading);
		$heading = implode(".", $heading);
		echo "<span class=\"heading\">" . $heading . "</span>";
		echo "</td>";
		echo "</tr><tr>";
		echo "<td align=\"center\" colspan=\"2\" width=\"" . $width . "\">";
		echo "  <img width=\"" . $width . "\" src=\"" . $image . "\">";
		echo "  <div align=\"center\"><span class=\"text\">" . $details[2] . "</span></div>";
		echo "</td>";
		echo "</tr>";
		echo "<tr><td align=\"center\"><a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&navpath=" . $_GET[navpath] . "&contents=" . $_GET[contents] . "&ID=" . $prevobjectid . "&gallerypage=1\"><img border=\"0\" title=\"" . $sas_lang[sn_allbum_previous_object] . "\" src=\"modules/sn_allbum/nav_prev_icon.gif\"></a>";
		echo "<a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&navpath=" . $_GET[navpath] . "&contents=" . $_GET[contents] . "&ID=" . $nextobjectid . "&gallerypage=1\"><img border=\"0\" title=\"" . $sas_lang[sn_allbum_next_object] . "\" src=\"modules/sn_allbum/nav_next_icon.gif\"></a>";
		echo "</td><td align=\"center\">&nbsp;</td>";
		echo "</tr>";
		echo "</table>";

		// Show options
		echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_options] . "</span></p>";
		if ($details[7] == 0)
		{
			echo "<p><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&suboption2=hide&ID=" . $ID . "&ID2=" . $ID . "&gallerypage=-1\">" . $sas_lang[sn_allbum_hide] . "</a></span></p>";
		}
		else
		{
			echo "<p><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&suboption2=unhide&ID=" . $ID . "&ID2=" . $ID . "&gallerypage=-1\">" . $sas_lang[sn_allbum_unhide] . "</a></span></p>";
		}

		return 0;
	}

	$objects = array (
		'album',
		'subalbum'
	);

	if (in_array($details[0], $objects))
	{

		// **(sub-)album**

		// Show navigation bar:
		ShowNavPath($_GET[navpath], false);

		// Show title:
		echo "<p><span class=\"heading\">" . $details[1] . "</span></p>";

		// Show description:
		echo "<p><span class=\"text\">" . $details[2] . "</span></p>";
		// Get number of objects per row:
		$numperrow = $sas_config['allbum_num_objects_per_row'];
		// Start table:
		echo "<table align=\"center\" width=\"98%\">
			 <tr>
			    <td colspan=\"" . $numperrow . "\" align=\"center\"><HR width=\"95%\"></td>
			 </tr>";
		// Get list of $ID's contents:
		$contents = db_GetContents($ID);
		// Check if the list of children is empty:
		$num = count($contents);
		if ($num == 0)
		{
			echo "<form action=\"index.php\" method=\"get\">";
			echo "<tr><td colspan=\"" . $numperrow . "\"><p><span class=\"text\">" . $sas_lang[sn_allbum_empty_album] . "</span></p></td></tr>";
			echo "<tr><td colspan=\"" . $numperrow . "\"><p><BR>
							<input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" onClick=\"javascript:history.go(-1)\" class=\"backbutton\">";
			echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
			echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
			echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"show\">";
			if (db_GetType($_GET[ID]) != "album")
			{
				echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . db_GetParentID($_GET[ID]) . "\">";
			}
			else
			{
				echo "<INPUT type=\"hidden\" name=\"ID\" value=\"0\">";
			}
			echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"1\">";
			echo "</td></tr>";
		}
		else
		{

			// Calculate which children should be shown on page $gpage:
			$show = array ();
			$max_objects_per_page = $sas_config['allbum_max_objects_per_page'];
			for ($i = (($gpage -1) * $max_objects_per_page) + 1;($i <= ($gpage * $max_objects_per_page)) AND ($i <= $num); $i++)
			{
				array_push($show, $contents[$i -1]);
			}

			// make a ?-dimensional array of $show:
			$showmultipledimensions = array_chunk($show, $numperrow);

			// Show each object:
			$x = $sas_config['allbum_thumbsize_x'];
			foreach ($showmultipledimensions AS $key => $value)
			{
				echo "<tr>";

				// Show objects:
				$w = 100 / $numperrow;
				for ($i = 0; $i < $numperrow; $i++)
				{
					if (IsSet ($value[$i]))
					{
						ShowObject($value[$i], $x, $w, $_GET[navpath] . "," . $ID, implode(",", $contents));
					}
					else
					{
						echo "<td width=\"" . $w . "%\">&nbsp;</td>";
					}
				}
				echo "</tr><tr>";

				for ($i = 0; $i < $numperrow; $i++)
				{
					if (IsSet ($value[$i]))
					{
						ShowObjectTitle($value[$i]);
					}
					else
					{
						echo "<td>&nbsp;</td>";
					}
				}
				// End row:
				echo "</tr>";
				echo "<tr>";
				// Show (un)hide and (de)select links:
				for ($i = 0; $i < $numperrow; $i++)
				{
					if (IsSet ($value[$i]))
					{
						echo "<td width=\"" . $w . "%\" align=\"center\">";
						ShowHide($value[$i], $ID, $_GET[ID3], $gpage);
						echo "<BR>";
						ShowSelect($value[$i], $ID, $_GET[ID3], $gpage);
						echo "</td>";
					}
					else
					{
						echo "<td width=\"" . $w . "%\" align=\"center\">&nbsp;</td>";
					}
				}
				// End row:
				echo "</tr>";
				// Show horizontal line:
				echo "<tr><td align=\"center\" colspan=\"" . $numperrow . "\"><HR width=\"95%\"></td></tr>";
			}
			ShowPreviousNext($ID, $gpage, $num, $max_objects_per_page, $numperrow, false);
		}

		// End table
		echo "</table>";
		return 0;
	}

	if ($details[0] == 'main')
	{
		// **main-page**
		// show title:
		echo "<p><span class=\"heading\">" . $sas_lang[sn_allbum_gallery_main_page] . "</span></p>";

		// start table:
		echo "<table width=\"98%\">
			        <tr>
			          <td align=\"center\" colspan=\"2\"><HR width=\"95%\"></td>
			        </tr>";

		// Get list of main albums:
		$contents = db_GetContents($ID);

		// Check if list of main albums is empty:
		$num = count($contents);
		if ($num == 0)
		{
			echo "<tr><td colspan=\"2\"><p><span class=\"text\">" . $sas_lang[sn_allbum_no_main_albums_avail] . "</span></p></td></tr>";
		}
		else
		{

			// sort $contents on value of parent field
			$contents2 = array ();
			foreach ($contents AS $key => $value)
			{
				$ordnum = db_GetParentID($value);
				$contents2[$ordnum -1] = $value;
			}
			$contents = $contents2;

			// Calculate which albums should be shown on page $page:
			$show = array ();

			$max_objects_per_page = $sas_config['allbum_max_objects_per_page'];
			for ($i = (($gpage -1) * $max_objects_per_page) + 1;($i <= ($gpage * $max_objects_per_page)) AND ($i <= $num); $i++)
			{
				array_push($show, $contents[$i -1]);
			}

			// Show each album:
			$x1 = $sas_config['allbum_thumbsize_x'];
			foreach ($show AS $key => $value)
			{

				// Get album details (type, title, description, path, thumb, parent, children, hidden):
				$details = db_GetAllDetails($value);

				if (file_exists($details[4]))
				{
					$path = $details[4];
					$x2 = $x1;
				}
				else
				{
					$image = str_replace("//", "/", $details[3] . "/" . $details[4]);
					$tmp = explode(".", $details[4]);
					$ext = array_pop($tmp);
					$name = implode(".", $tmp);
					$thumb = str_replace("//", "/", $details[3] . "/" . $name . "_t." . $ext);
					if (file_exists($thumb))
					{
						// thumbnail exists
						$path = $thumb;
					}
					else
					{
						// thumbnail does not exist
						// can't resize images, use large images instead
						$path = $image;
					}
					$x2 = $x1;
				}

				// Show album:
				if ($details[10] == 1)
				{
					$protected_site = $sas_lang['sn_allbum_on_protected'];
				}
				else
				{
					$protected_site = "";
				}
				echo "<tr>
								<td align=\"center\" width=\"40%\">
								<a href=\"index.php?option=modulemanager&suboption=show&module=" . $module . "&ID=" . $value . "&gallerypage=1\">
								<img src=\"" . $path . "\" width=\"" . $x2 . "\"></a></td>
								<td width=\"60%\"><p><span class=\"text\"><STRONG>" . $details[1] . "</STRONG><BR><BR>
								" . $details[2] . "</span></p></td></tr>";

				// Show hide/unhide link and select/deselect link:
				echo "<tr><td align=\"center\">";
				ShowHide($value, $ID, $_GET[ID3], $gpage);
				echo "<BR>";
				ShowSelect($value, $ID, $_GET[ID3], $gpage);
				echo "</td><td><span class=\"text\"><font size=\"1\">$protected_site &nbsp;</font></span></td>";
				echo "</tr>";

				// Show horizontal line:
				echo "<tr><td align=\"center\" colspan=\"2\"><HR width=\"95%\"></td></tr>";
			}
			ShowPreviousNext($ID, $gpage, $num, $max_objects_per_page, 2, false);
		}

		// End table:
		echo "</table>";

		return 0;
	}
}

function ShowObject($id, $x, $w, $navpath, $contents)
{
	// Task: render thumbnail cell for object with id $ID within a row in a (sub)-album.

	global $module;
	global $sas_lang;
	// Get all details array(type, title, description, path, thumb, parent, children, hidden) for first object:
	$details = db_GetAllDetails($id);
	if (file_exists($details[4]))
	{ //we have an empty allbum with empty.gif path
		$path = $details[4];
		$thumbicon = true;
	}
	else
	{
		$path = $details[3] . "/" . $details[1];

		if ($details[0] == "subalbum")
		{
			$image = str_replace("//", "/", $details[3] . "/" . $details[4]);
			$tmp = explode(".", $details[4]);
		}
		else
		{
			$image = str_replace("//", "/", $details[3] . "/" . $details[4]);
			$tmp = explode(".", $details[4]);
		}
		$ext = array_pop($tmp);
		$name = implode(".", $tmp);
		$thumb = str_replace("//", "/", $details[3] . "/" . $name . "_t." . $ext);
		if (file_exists($thumb))
		{
			// thumbnail exists
			$path = $thumb;
		}
		else
		{
			// thumbnail does not exist
			// use large images instead
			if (file_exists($image))
			{
				$path = $image;
				$size = getimagesize($path);
				if ($size[0] < $size[1])
				{
					// portrait
					$x = $x / 1.3;
				}
			}
			else
			{
				print $sas_lang['sn_allbum_err'] . $sas_lang['sn_allbum_file_not_exists'] . "<b>" . $image . "</b>";
			}
		}
	}
	// Show object:
	echo "<td valign=\"center\" align=\"center\" width=\"" . $w . "%\">
		  <a href=\"index.php?option=modulemanager&suboption=show&contents=" . $contents . "&module=" . $module . "&navpath=" . $navpath . "&ID=" . $id . "&gallerypage=1\">
		  <img src=\"" . $path . "\" width=\"" . $x . "\" alt=\"" . $sas_lang['sn_allbum_alt_click'] . "\" title=\"" . $sas_lang['sn_allbum_alt_click'] . "\">
		  </a></td>";
}

function ShowObjectTitle($id)
{
	// Task: render title cell for object with id $ID within a row in a (sub)-album.

	global $sas_lang;

	// Get some details array(type, title, description, path, thumb, parent, children, hidden) for first object:
	$details = db_GetAllDetails($id);

	// Show object title:
	echo "<td align=\"center\"><p><span class=\"text\">";
	if ($details[0] == "subalbum")
	{
		echo "<STRONG>" . $sas_lang[sn_allbum_album] . ": " . $details[1] . "</STRONG>";
	}
	else
	{
		if (strpos($details[1], ".")) //object title has extention?
		{
			$tmp = explode(".", $details[1]);
			array_pop($tmp);
			$tmp = implode(".", $tmp);
			echo $tmp;
		}
		else
		{
			echo $details[1];
		}
	}
	echo "</span></p></td>";
}

function ShowHide($id, $parentid, $id3, $gpage)
{
	// Task: show hide/unhide link for object with id $id

	global $module;
	global $sas_lang;
	global $navpath;

	if (db_GetHidden($id) == 0)
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module .
		"&suboption=show&suboption2=hide&navpath=" . $_GET[navpath] . "&ID=" . $parentid . "&ID2=" . $id . "&ID3=" . $id3 . "&gallerypage=" . $gpage . "\">" . $sas_lang[sn_allbum_hide] . "</a></span>";
	}
	else
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module .
		"&suboption=show&suboption2=unhide&navpath=" . $_GET[navpath] . "&ID=" . $parentid . "&ID2=" . $id . "&ID3=" . $id3 . "&gallerypage=" . $gpage . "\">" . $sas_lang[sn_allbum_unhide] . "</a></span>";
	}
}

function ShowSelect($id, $parentid, $id3, $gpage)
{
	// Task: show select/unselect link for object with id $id

	global $module;
	global $sas_lang;
	global $navpath;

	if ($id3 != "")
	{
		$array = explode(",", $id3);
		if (in_array($id, $array))
		{
			$array = array_clean($array, $id);
			if (IsSet ($array[0]))
			{
				$array = implode(",", $array);
			}
			else
			{
				$array = "";
			}
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&navpath=" . $_GET[navpath] . "&module=" . $module . "&suboption=show&suboption2=select&ID3=" . $array . "&ID=" . $parentid . "&gallerypage=" . $gpage . "\"><font color=\"red\">" . $sas_lang[sn_allbum_deselect_item] . "</font></a></span>";
		}
		else
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&navpath=" . $_GET[navpath] . "&module=" . $module . "&suboption=show&suboption2=select&ID3=" . $id3 . "," . $id . "&ID=" . $parentid . "&gallerypage=" . $gpage . "\">" . $sas_lang[sn_allbum_select_item] . "</a></span>";
		}
	}
	else
	{
		echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&navpath=" . $_GET[navpath] . "&module=" . $module . "&suboption=show&suboption2=select&ID3=" . $id3 . "," . $id . "&ID=" . $parentid . "&gallerypage=" . $gpage . "\">" . $sas_lang[sn_allbum_select_item] . "</a></span>";
	}
}

function ShowCreateAlbum()
{
	global $title;
	global $module;
	global $description;
	global $sas_lang;
	global $sas_config;
	global $ID;
	global $gallerypage;
	global $navpath;

	if (($_GET[title] == "") OR ($_GET[title] == ".") OR ($_GET[title] == "..") OR ($_GET[description] == "") OR (strlen($_GET[description]) > 1000))
	{

		echo "<form action=\"index.php\" method=\"get\">";
		echo "<span class=\"heading\">" . $sas_lang[sn_allbum_create_album] . "</span>";
		echo "<BR><BR>";

		if (strlen($_GET[description]) > 1000)
		{
			echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_description_1000] . "</span></p>";
		}

		if (($_GET[title] == ".") OR ($_GET[title] == ".."))
		{
			echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_title_like_dir] . "</span></p>";
		}

		if ((($_GET[title] == "") OR ($_GET[description] == "")) AND (IsSet ($_GET[title]) AND IsSet ($_GET[description])))
		{
			echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_enter_both] . "</span></p>";
		}

		echo "<BR><BR>";
		echo "<table><tr><td valign=\"top\"><p><span class=\"text\">" . $sas_lang[sn_allbum_title] . ":
						</span></p>
						</td>
						<td>
						<p><input name=\"title\" size=\"70\" value=\"" . $_GET[title] . "\"></p>
						</td>
						</tr>
						<tr>
						<td valign=\"top\">
						<p><span class=\"text\">" . $sas_lang[sn_allbum_description] . ":</span></p>
						</td>
						<td>
						<p><TEXTAREA cols=\"50\" rows=\"5\" name=\"description\">" . $_GET[description] . "</TEXTAREA></p>
						</td>
						</tr>
						<tr><td><span class=\"text\">" . $sas_lang['sn_allbum_category_is_page'] . "</span></td>
						<td <span class=\"text\">&nbsp;" . $sas_lang['yes'] . "
						</span><input type=\"radio\" value=\"1\" name=\"ispage\">
						<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>
						<input type=\"radio\" name=\"ispage\" value=\"0\" checked></td></tr>";
		if (($_GET[ID] == "") OR $_GET[ID] == "0")
		{
			print "<tr><td><span class=\"text\">" . $sas_lang['sn_allbum_category_is_public'] . "</span></td>
					<td <span class=\"text\">&nbsp;" . $sas_lang['yes'] . "
					</span><input type=\"radio\" value=\"1\" name=\"ispublic\">
					<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>
					<input type=\"radio\" name=\"ispublic\" value=\"0\" checked></td></tr>";
		}
		print "<tr>
		    		<td colspan=\"2\">
		    		    <BR>
		    		    <input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" onClick=\"javascript:history.go(-1)\" class=\"backbutton\">
		    		    &nbsp;&nbsp;<INPUT type=\"submit\" class=\"savebutton\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang[sn_allbum_create_album] . "\">
		    		    <BR>
		    		</td>
			      </tr>
				</table>";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"createalbum\">";
		echo "<INPUT type=\"hidden\" name=\"navpath\" value=\"" . $_GET[navpath] . "\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">"; // might be empty
		echo "</form>";
	}
	else // title and description have been entered 
		{
		if (($_GET[ID] != "") AND ($_GET[ID] != "0"))
		{
			$parent = $_GET[ID]; // SUB-ALBUM
		}
		else
		{
			$parent = -1; // MAIN-ALBUM
		}

		// Check if album with the same title already exists:
		if (db_GetAlbumExists(stripslashes($_GET[title]), $parent))
		{

			// Create HTML webpage:
			echo "<form action=\"index.php\" method=\"get\">";
			echo "<span class=\"heading\">" . $sas_lang[sn_allbum_album_exists] . "</span>";
			echo "<table>
				    	<tr>
				    	    <td valign=\"top\">
				    	        <p><span class=\"text\">" . $sas_lang[sn_allbum_album_exists_text] . "</span></p>
				    	    </td>
				    	</tr>
				    	<tr>
				            <td align=\"center\" colspan=\"2\"><BR>
				        	<input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" onClick=\"javascript:history.go(-1)\" class=\"backbutton\">
				        	<BR></td>
				    	</tr>
				        </table>";
			echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
			echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
			echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"show\">";

			if ($_GET[ID] != "")
			{
				echo "<INPUT type=\"hidden\" name=\"navpath\" value=\"" . $_GET[navpath] . "\">";
				echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"1\">";
				echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
			}

			echo "</form>";

		}
		else
		{

			if (($_GET[ID] != "") AND ($_GET[ID] != "0"))
			{
				// Create sub-album:
				$parentpath = db_GetPath($_GET[ID]);
				$path = str_replace("/", "_", stripslashes($_GET[title]));
				$is_public = db_GetPublic($_GET[ID]); //get the public bit of the parent
				$tmp = db_PutCreateObject('subalbum', $_GET[title], $_GET[description], str_replace("//", "/", addslashes($parentpath) . "/" . $path), 'modules/sn_allbum/empty.gif', $_GET[ID], NULL, 0, $_GET[ispage], $is_public);
			}
			else
			{
				// Create album:
				$arraymainalbums = db_GetContents("0");
				$albumnum = 0;
				foreach ($arraymainalbums AS $key => $value)
				{
					$parentfield = db_GetParentID($value);
					if ($parentfield > $albumnum)
					{
						$albumnum = $parentfield;
					}
				}
				$albumnum++;

				$path = str_replace("/", "_", stripslashes($_GET[title]));
				$is_public = $_GET['ispublic'];
				$tmp = db_PutCreateObject('album', $_GET[title], $_GET[description], str_replace("//", "/", $sas_config[allbum_gallery_dir] . $path), 'modules/sn_allbum/empty.gif', $albumnum, NULL, 0, $_GET[ispage], $is_public);
			}
			// javascript reloads page
			echo "<script language='javascript'>
					  window.location = 'index.php?option=modulemanager&module=" . $module . "&suboption=show&ID=" . $tmp . "&navpath=" . $_GET[navpath] . "," . $_GET[ID] . "&gallerypage=1'
					  </script>";
			echo $sas_lang[sn_allbum_error_redirect];
		}
	}
}

function ShowAddObject()
{
	global $module;
	global $sas_lang;
	global $sas_config;
	global $FILES;
	global $state;
	global $ID;
	global $dir;
	global $selectedfiles;
	global $navpath;

	if ((!(IsSet ($_GET[state]))))
	{

		if (db_GetType($_GET[ID]) == "main")
		{
			$main = true;
		}
		else
		{
			$main = false;
		}

		echo "<form name=\"name1\" action=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=addobject&state=2&ID=" . $_GET[ID] . "\" method=\"post\" enctype=\"multipart/form-data\">";
		echo "<span class=\"heading\">" . $sas_lang[sn_allbum_add_object] . "</span><BR><BR>";
		if ($_GET[mupload] == "yes")
		{
			$path = db_GetPath($_GET[ID]);
			$sess_id = session_id();
			print "<p>
							<table>
							<tr><td><span class=\"heading\">" . $sas_lang['multiple_upload'] . ": $path</span></td></tr>
							<tr><td>
							<APPLET CODE =\"Main.class\" ARCHIVE =\"core/Postlet.jar\" WIDTH =\"600\" HEIGHT =\"200\" NAME =\"Postlet\" MAYSCRIPT>
							<PARAM NAME =\"CODE\" VALUE =\"Main.class\" >
							<PARAM NAME =\"ARCHIVE\" VALUE =\"core/Postlet.jar\" >
							<PARAM NAME =\"NAME\" VALUE =\"Multiple file uploader\" >
							<PARAM NAME =\"type\" VALUE =\"application/x-java-applet;version=1.4\">
							<PARAM NAME=\"language\" VALUE=\"" . $sas_config['language'] . "\" />
							<PARAM NAME=\"fileextensions\" VALUE=\"jpg,gif,png,bmp,doc,txt,html,htm,mp3,avi,zip,xls,pdf,rtf,csv,jpeg,mpg,mpeg,swf,fla\" />
							<PARAM NAME =\"destination\" VALUE=\"" . $sas_config['url'] . "starnet/modules/sn_allbum/javaUpload.php?store_path=" . $path . "&ID=" . $_GET[ID] . "&PHPsessid=" . $sess_id . "\">
							<PARAM NAME =\"endpage\" VALUE=\"" . $sas_config['url'] . "starnet/index.php?option=modulemanager&module=" . $module . "&suboption=show&ID=" . $_GET[ID] . "&gallerypage=1\"> 
							</applet>
							</td></tr>
							</table>";
		}
		elseif ($main)
		{
			echo "<table>
				        <tr>
					  <td valign=\"top\">
					    <p><span class=\"text\">" . $sas_lang[sn_allbum_choose_dirs] . ":</span></p>
					  </td>
						</tr>
						<tr>
					  <td align=\"left\">";
			if (!IsSet ($_GET[dir]))
			{
				$dir = "media/";
			}
			else
			{
				$dir = $_GET[dir];
			}
			ShowDir2($dir);
			echo "</td></tr></table>";
		}
		else
		{

			echo "<table>
				        <tr>
			    		  <td valign=\"top\" colspan=\"2\">
			    		    <p><span class=\"text\">" . $sas_lang[sn_allbum_files] . ":</span>
					    </p>";
			$num = $sas_config['allbum_num_files'];
			for ($i = 1; $i <= $num; $i++)
			{
				echo "<INPUT size=\"60\" type=\"file\" name=\"file" . $i . "\"><BR>";
			}
			echo "
			    		  </td>
				        </tr>
				        <tr>
			    		  <td align=\"left\" colspan=\"2\">
					      <BR><center>
						  <input type=\"button\" value=\"&nbsp;" . $sas_lang['multiple_upload'] . "\" onClick=\"parent.location='index.php?option=modulemanager&module=$module&navpath=" . $_GET[navpath] . "&suboption=addobject&mupload=yes&ID=" . $_GET[ID] . "'\">
						  <INPUT type=\"submit\" value=\"" . $sas_lang[sn_allbum_add_objects] . "\">
					      <INPUT type=\"button\" value=\"" . $sas_lang[sn_allbum_cancel] . "\" onClick=\"history.go(-1)\">
					      </center>
			    		  </td>
				        </tr>
				        <tr>
				          <td align=\"center\">&nbsp;</td>
						  <td><BR>
					    <p><span class=\"text\">" . $sas_lang[sn_allbum_or_select_files] . "</span></p>
					  </td>
				        </tr>
				        <tr>
				          <td width=\"20%\">&nbsp;</td>
				          <td>";
			if (!IsSet ($_GET[dir]))
			{
				$dir = "media/";
			}
			else
			{
				$dir = $_GET[dir];
			}
			ShowDir($dir);
			echo "</td></tr></table></form>";
		}
	}
	elseif ($_GET[state] == "2")
	{
		alert($_GET[ID]); //send alert 
		if (IsSet ($_POST[selectedfiles]) or IsSet ($_POST[selecteddirs]))
		{
			// File(s) and/or Directorie(s) are located somewhere in media/, inspect 
			// $_POST[selectedfiles][i] and $_POST[selecteddirs][i] for their location.

			// process files:
			if (IsSet ($_POST[selectedfiles]))
			{
				foreach ($_POST[selectedfiles] AS $key => $value)
				{
					UseFileFromMedia($value, $_GET[ID]);
				}
			}

			// process directories:
			if (IsSet ($_POST[selecteddirs]))
			{
				$exists_error = false;
				$exists = array ();
				foreach ($_POST[selecteddirs] AS $key => $value)
				{
					if (db_GetAlbumExists($value, $_GET[ID]))
					{
						$exists_error = true;
						array_push($exists, $value);
					}
					else
					{
						UseDirFromMedia($value, $_GET[ID]);
					}
				}
			}
			// show page, load current allbum contents, last page
			if ($exists_error)
			{
				echo "<tr><td colspan=\"2\">";
				echo "<span class=\"text\">" . $sas_lang['sn_allbum_dir_exists'] . "</span><BR><BR>";
				foreach ($exists_error AS $key => $value)
				{
					echo "<span class=\"text\">" . $value . "</span><BR>";
				}
				echo "<BR><span class=\"link\">";
				$last_page = round(ceil(count(db_GetContents($_GET[ID])) / $sas_config['allbum_max_objects_per_page']));
				echo "<a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=show&ID=" . $_GET[ID] . "&gallerypage=" . $last_page . "\">Continue</a></span>";
			}
			else
			{
				$last_page = round(ceil(count(db_GetContents($_GET[ID])) / $sas_config['allbum_max_objects_per_page']));
				echo "<tr><td colspan=\"2\"><script language='javascript'>
								window.location = 'index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=show&ID=" . $_GET[ID] . "&gallerypage=" . $last_page . "'
								</script>";
				echo $sas_lang[sn_allbum_error_redirect];
			}
			echo "</td></tr></table>";
		}
		else
		{
			// File(s) has(ve) been uploaded to temporary directory

			// Get path to main parent:
			$parent = db_GetPath($_GET[ID]);

			// move files to right directory:
			$i = 1;
			$temp = "file" . "$i";
			$num = $sas_config['allbum_num_files'];

			$succes = "ok";
			while ($i <= $num AND ($_FILES[$temp]['error'] == 0))
			{
				$dest = $parent . "/" . $_FILES[$temp]['name'];
				# Remove spaces, apostrophe, exclamation marks etc.
				$str_from = " \'@!,\t\*?`\"";
				$str_to = str_repeat("_", strlen($str_from));
				$dest = strtr($dest, $str_from, $str_to);

				if (file_exists($dest))
				{ //if file already exists, skip it
					$succes = "nok";
					$exists_error = true;
					break;
				}
				$filename = $_FILES[$temp]["name"];
				$temp_file = $_FILES[$temp]['tmp_name']; //this is temporary uploaded file.	
				sas_move_uploaded_file($parent, $filename, $temp_file);

				//move_uploaded_file($_FILES[$temp]['tmp_name'],$dest);
				if ($_FILES[$temp]['error'] != 0)
				{
					$succes = "nok";
					break;
				}
				$title = $_FILES[$temp]['name'];

				if (substr_count($_FILES[$temp]['type'], "image") != 0)
				{
					$type = "picture";
					$thumb = ListThumb($dest); //make the thumb file
					$path = MakeThumb($thumb, $dest);

					$thumb = strtr($title, $str_from, $str_to);
				}
				elseif (substr_count($_FILES[$temp]['type'], "application/x-shockwave-flash") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/swf.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "mp3") != 0)
				{
					$type = "sound";
					$thumb = "modules/sn_allbum/sound.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "x-ms-asf") != 0)
				{
					$type = "sound";
					$thumb = "modules/sn_allbum/winmedia.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "wav") != 0)
				{
					$type = "sound";
					$thumb = "modules/sn_allbum/sound.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "audio/mid") != 0)
				{
					$type = "sound";
					$thumb = "modules/sn_allbum/sound.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "real") != 0)
				{
					$type = "sound";
					$thumb = "modules/sn_allbum/sound.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "video/x-msvideo") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/movie.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "audio/x-pn-realaudio") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/movie.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "video/quicktime") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/mov.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "mpg") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/movie.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "mpeg") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/movie.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "divx") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/movie.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "doc") != 0)
				{
					$type = "document";
					$thumb = "modules/sn_allbum/document.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "pdf") != 0)
				{
					$type = "document";
					$thumb = "modules/sn_allbum/pdf.gif";
				}
				elseif (substr_count($_FILES[$temp]['type'], "video/x-ms-wmv") != 0)
				{
					$type = "movie";
					$thumb = "modules/sn_allbum/movie.gif";
				}
				else
				{
					$type = "unknown";
					$thumb = "modules/sn_allbum/unknown.gif";
				}
				$description = NULL;
				$hidden = 0;
				$path = str_replace("//", "/", $parent . "/");
				$parent_ID = $_GET[ID];
				$children = NULL;
				if ($succes == "ok")
				{
					$is_public = db_GetPublic($parent_ID); //get public bit of parent

					if ((strpos($title, ".")) AND ($type == "picture")) //object title has extention?
					{
						$tmp = explode(".", $title);
						array_pop($tmp);
						$title = implode(".", $tmp);
					}
					db_PutCreateObject($type, $title, $description, addslashes($path), $thumb, $parent_ID, $children, $hidden, $ispage, $is_public);
				}
				$i++;
				$temp = "file" . "$i";
			}
			// show page
			if ($succes == "ok")
			{
				// load current allbum contents, last page
				$last_page = round(ceil(count(db_GetContents($_GET[ID])) / $sas_config['allbum_max_objects_per_page']));
				echo "<tr><td colspan=\"2\"><script language='javascript'>
						      window.location = 'index.php?option=modulemanager&module=" . $module . "&navpath=" . $_GET[navpath] . "&suboption=show&ID=" . $_GET[ID] . "&gallerypage=" . $last_page . "'
						      </script>";
				echo $sas_lang[sn_allbum_error_redirect];
			}
			else
			{
				echo "<span class=\"heading\">" . $sas_lang[sn_allbum_add_object_error] . "</span><BR><BR>";
				echo "<table>
					    	    <tr>
					        	<td valign=\"top\" colspan=\"2\">
					        	    <p><span class=\"text\">" . $sas_lang[sn_allbum_add_object_error_text] . "
					        	    </span></p>
					        	</td>
					    	    </tr>";
				if ($succes == "nok")
				{
					// file upload error, database action not taken
					//echo "<tr><td colspan=\"2\"><span class=\"text\">".$sas_lang[sn_allbum_file_upload_error]."</span></td></tr>";
					echo "<tr><td colspan=\"2\"><span class=\"text\">";
					$i = 1;
					$temp = "file" . "$i";
					while ($i <= $num AND $_FILES[$temp]['error'] == 0)
					{
						$i++;
						$temp = "file" . "$i";
					}
					if ($exists_error)
					{
						echo $sas_lang[sn_allbum_error9];
					}
					elseif ($_FILES[$temp]['error'] == 0)
					{
						echo $sas_lang[sn_allbum_error0];
					}
					elseif ($_FILES[$temp]['error'] == 1)
					{
						echo $sas_lang[sn_allbum_error1];
					}
					elseif ($_FILES[$temp]['error'] == 2)
					{
						echo $sas_lang[sn_allbum_error1];
					}
					elseif ($_FILES[$temp]['error'] == 3)
					{
						echo $sas_lang[sn_allbum_error3];
					}
					elseif ($_FILES['file . $i']['error'] == 4)
					{
						echo $sas_lang[sn_allbum_error4];
					}
					else
					{
						echo $sas_lang[sn_allbum_error];
					}
					echo "</span>";
				}
			}
			echo "</td></tr></table>";
		}
	}
}

function ShowDir($dir)
{
	// Task: show contents of directory $dir, make it possible
	// to select files and/or directories. Do not show media/gallery.
	// CAUTION: this function depends on function ShowAddObject()!

	global $module;
	global $id;
	global $option;
	global $sas_lang;

	// echo some javascript for a 'toggle all' button:
	echo "<script language=\"JavaScript\">
		<!--
		function doselectAll(theBox) 
		{
			State = theBox.checked;
			elm=theBox.form.elements;
			for(i=0 ; i < elm.length ; i++) 
			{
				if(elm[i].type==\"checkbox\") 
				{
				  elm[i].checked=State;
				}
			}
		}
		-->
		</script>";

	$dp = opendir($dir);
	echo "<BR><span class=\"link\">" . $dir . "</span><BR><BR>";
	echo "<input type=\"checkbox\" id=\"SelectAll\" name=\"SelectAll\" onClick=\"doselectAll(this)\"><span class=\"text\">" . $sas_lang[sn_allbum_toggle] . "</span><BR><BR>";

	$dirs = array ();
	$files = array ();
	while (false !== ($file = readdir($dp)))
	{
		if (is_dir(str_replace("//", "/", $dir . "/" . $file)))
		{
			if (($file != ".") AND ($file != ".."))
			{
				if (!($dir == "media") OR ($dir == "media/"))
				{
					array_push($dirs, $file);
				}
			}
		}
		else
		{ //filter the zz_thumb_ files.
			if (substr($file, 0, 9) != "zz_thumb_")
			{
				array_push($files, $file);
			}
		}
	}
	closedir($dp);
	//sort the dirs and files arrays
	$array_lowercase = array_map('strtolower', $dirs);
	array_multisort($array_lowercase, SORT_ASC, SORT_STRING, $dirs);
	$array_lowercase = array_map('strtolower', $files);
	array_multisort($array_lowercase, SORT_ASC, SORT_STRING, $files);

	if (($dir != "media") AND ($dir != "media/"))
	{
		$dirname = explode("/", $dir);
		array_pop($dirname);
		$dirname = implode("/", $dirname);
		echo "<img src=\"graphics/folder_closed.gif\"><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=&suboption=addobject&dir=" . $dirname . "/&ID=" . $_GET[ID] . "\">..</a></span><BR>";
	}

	foreach ($dirs AS $key => $value)
	{
		$dirname = str_replace("//", "/", $dir . "/" . $value);
		echo "<img src=\"graphics/folder_closed.gif\"><INPUT TYPE=\"checkbox\" id=\"" . $value . "\" NAME=\"selecteddirs[]\" VALUE=\"" . $dirname . "\">
			<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=addobject&dir=" . $dirname . "&ID=" . $_GET[ID] . "\">" . $value . "</a></span><BR>";
	}

	foreach ($files AS $key => $value)
	{
		$filefullpath = str_replace("//", "/", $dir . "/" . $value);
		echo "<img src=\"graphics/document.gif\"><span class=\"text\"><INPUT TYPE=\"checkbox\" id=\"" . $value . "\" NAME=\"selectedfiles[]\" VALUE=\"" . $filefullpath . "\">" . $value . "</span><BR>";
	}
	echo "<BR>";
}

function ShowDir2($dir)
{
	// Task: show directories in directory $dir, make it possible
	// to select directories. Do not show media/gallery.
	// CAUTION: this function depends on function ShowAddObject()!

	global $module;
	global $id;
	global $option;
	global $sas_lang;

	// echo some javascript for a 'toggle all' button:
	echo "<script language=\"JavaScript\">
		<!--
		function doselectAll(theBox) 
		{
		  State = theBox.checked;
		  elm=theBox.form.elements;
		  for(i=0 ; i < elm.length ; i++) 
		  {
		   if(elm[i].type==\"checkbox\") 
		   {
		      elm[i].checked=State;
		    }
		  }
		}
		-->
		</script>";

	$dp = opendir($dir);
	echo "<BR><span class=\"link\">" . $dir . "</span><BR><BR>";
	echo "<input type=\"checkbox\" id=\"SelectAll\" name=\"SelectAll\" onClick=\"doselectAll(this)\"><span class=\"text\">" . $sas_lang[sn_allbum_toggle] . "</span><BR><BR>";

	$dirs = array ();
	while (false !== ($file = readdir($dp)))
	{
		if (is_dir(str_replace("//", "/", $dir . "/" . $file)))
		{
			if (($file != ".") AND ($file != ".."))
			{
				if (!($dir == "media") OR ($dir == "media/"))
				{
					array_push($dirs, $file);
				}
			}
		}
	}
	closedir($dp);
	if (($dir != "media") AND ($dir != "media/"))
	{
		$dirname = explode("/", $dir);
		array_pop($dirname);
		$dirname = implode("/", $dirname);
		echo "<img src=\"graphics/folder_closed.gif\"><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=addobject&dir=" . $dirname . "&ID=" . $_GET[ID] . "\">..</a></span><BR>";
	}

	foreach ($dirs AS $key => $value)
	{
		$dirname = str_replace("//", "/", $dir . "/" . $value);
		echo "<img src=\"graphics/folder_closed.gif\"><INPUT TYPE=\"checkbox\" id=\"" . $value . "\" NAME=\"selecteddirs[]\" VALUE=\"" . $dirname . "\"><span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=addobject&dir=" . $dirname . "&ID=" . $_GET[ID] . "\">" . $value . "</a></span><BR>";
	}
	echo "<BR>";
}

function ShowConfig()
{
	global $module;
	global $sas_lang;
	global $state;

	if (!IsSet ($_GET[state]))
	{
		echo "<form action=\"index.php\" method=\"get\">";
		echo "<span class=\"heading\">" . $sas_lang[sn_allbum_configuration] . "</span>";
		echo "<table><p>";

		// Get (config_key, config_value, description) for each config option
		$config2d = db_GetConfigOptions();
		foreach ($config2d as $value)
		{
			print "<tr><td valign=\"top\">
					      <p><span class=\"text\">" . $sas_lang["sn_allbum_" . $value[0]] . "</span></p></td>";
			if ($value[0] == "allbum_welcome")
			{
				print "<td>&nbsp;</td></tr><tr><td colspan=\"2\">
						  <textarea cols=\"60\" rows=\"4\" name=\"$value[0]\">" . $value[1] . "</textarea>";
			}
			elseif ($value[0] == "allbum_reverse_order")
			{
				print "<td><span class=text>" . $sas_lang['yes'] . "</span>";
				if ($value[1] == 1)
				{
					print "<input type=\"radio\" value=\"1\" name=\"" . $value[0] . "\" checked>";
					print "<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>";
					print "<input type=\"radio\" name=\"" . $value[0] . "\" value=\"0\"></td></tr>";
				}
				else
				{
					print "<input type=\"radio\" value=\"1\" name=\"" . $value[0] . "\">";
					print "<span class=text>&nbsp;&nbsp;&nbsp; " . $sas_lang['no'] . "</span>";
					print "<input type=\"radio\" name=\"" . $value[0] . "\" value=\"0\" checked></td></tr>";
				}
			}
			else
			{
				print "<td valign=\"top\">&nbsp;
								<INPUT type=\"text\" size=\"5\" name=\"" . $value[0] . "\" value=\"" . $value[1] . "\">";
			}

			print "</td></tr><tr><td colspan=\"2\">&nbsp;</td></tr>";
		}
		echo "<tr>
		    		<td colspan=\"2\">
				    <p><input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" onClick=\"javascript:history.go(-1)\" class=\"backbutton\">
		    		&nbsp;&nbsp;<INPUT type=\"submit\" class=\"savebutton\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang[sn_allbum_save_configuration] . "\">
				    </center>
				    <BR><BR>
		    		</td>
			      </tr>
			      </table>";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"config\">";
		echo "<INPUT type=\"hidden\" name=\"state\" value=\"save\">";
		echo "</form>";
	}
	elseif ($_GET[state] == "save")
	{
		// get the array again
		$config2d = db_GetConfigOptions();

		// make all config_keys global and update the database
		foreach ($config2d as $value)
		{
			global $value0;
			$value0 = $value[0];
			db_PutConfigOption($value[0], $_GET[$value0]);
		}

		// render HTML page
		echo "<p><span class=\"heading\">" . $sas_lang[sn_allbum_configuration_saved] . "</span></p>";
		echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_configuration_saved_text] . "</span></p>";
	}

}

function ShowOrderSub()
{
	global $module;
	global $sas_lang;
	global $state;
	global $ID;
	global $navpath;

	// if a new order has been chosen, verify if it is a valid one:	
	$valid = true;

	if ((IsSet ($_GET[state])) AND ($_GET[state] == 2))
	{
		$order = array ();
		$keys = array (
			'option',
			'module',
			'suboption',
			'state',
			'ID',
			'navpath',
			'gallerypage'
		);
		foreach ($_GET AS $key => $value)
		{
			if (!in_array($key, $keys))
			{
				array_push($order, $value);
			}
		}
		sort($order);
		$i = 0;
		while ($i < count($order))
		{
			if ($order[$i] != $i +1)
			{
				$valid = false;
			}
			$i++;
		}
	}

	if ((!(IsSet ($_GET[state]))) OR (!$valid))
	{
		echo "<form action=\"index.php\" method=\"get\">";
		echo "<span class=\"heading\">" . $sas_lang[sn_allbum_order_album] . "</span><BR><BR>";
		if (!$valid)
		{
			echo "<p><span class=\"text\"><font color=\"red\">" . $sas_lang[sn_allbum_order_invalid] . "</font></span></p>";
		}

		echo "<table>
			      <tr>
		    		<td>
		    		  <span class=\"text\">" . $sas_lang[sn_allbum_order_album_text] . "<b> " . db_GetTitle($_GET[ID]) . "</b><p></span>
		    		</td>
			      </tr>
			      <tr><td><table><tr>";
		$contents = db_GetContents($_GET[ID]);
		foreach ($contents AS $key => $value)
		{
			echo "<td><SELECT name=\"" . $value . "\">";
			$i = 1;
			if (IsSet ($_GET[$value]))
			{
				while ($i <= count($contents))
				{
					echo "<OPTION";
					global ${ $value };
					if ($i == $_GET[$value])
					{
						echo " selected";
					}
					echo " value=\"" . $i . "\">" . $i . "</option>";
					$i++;
				}
			}
			else
			{
				while ($i <= count($contents))
				{
					echo "<OPTION";
					if ($i == $key +1)
					{
						echo " selected";
					}
					echo " value=\"" . $i . "\">" . $i . "</OPTION>";
					$i++;
				}
			}
			echo "</SELECT>&nbsp;&nbsp;";
			echo db_GetTitle($value);
			if ($k == 1)
			{
				$k = 0;
				echo "</td><tr>";
			}
			else
			{
				$k = 1;
				echo "</td><td width=\"30\">&nbsp;</td>";
			}
		}
		echo "</tr></table></td>
					  </tr>
					  <tr>
						<td>
						<BR>
						<input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" 
						onClick=\"javascript:history.go(-1)\" class=\"backbutton\">
					  &nbsp;&nbsp;<INPUT type=\"submit\" class=\"savebutton\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang[sn_allbum_order] . "\">
							<BR>
						</td>
					  </tr>
					</table>";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"ordersub\">";
		echo "<INPUT type=\"hidden\" name=\"state\" value=\"2\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
		echo "<INPUT type=\"hidden\" name=\"navpath\" value=\"" . $_GET[navpath] . "\">";
		echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"1\">";
		echo "</form>";
	}
	elseif (($_GET[state] == "2") AND $valid)
	{
		// new orders have been entered and are valid; now reorder items.
		$keys = array (
			'option',
			'module',
			'suboption',
			'state',
			'ID',
			'navpath',
			'gallerypage'
		);
		$order = array ();
		foreach ($_GET AS $key => $value)
		{
			global ${ $key };
			if (!in_array($key, $keys))
			{
				$order[$key] = $_GET[$key];
			}
		}
		asort($order);
		$string;
		foreach ($order AS $key => $value)
		{
			$string = $string . $key;
			if ($value != (count($order)))
			{
				$string = $string . ",";
			}
		}
		db_PutChildren($_GET[ID], $string);

		echo $sas_lang[sn_allbum_no_errors];
		echo "<script language='javascript'>
					window.location = 'index.php?option=modulemanager&module=" . $module . "&suboption=show&navpath=" . $_GET[navpath] . "&ID=" . $_GET[ID] . "&gallerypage=" . $_GET[gallerypage] . "'
					</script>";
		echo $sas_lang[sn_allbum_error_redirect];

	}
}

function ShowOrderMain()
{
	global $module;
	global $sas_lang;
	global $state;
	global $ID;
	global $gallerypage;

	$valid = true;

	if ((IsSet ($_GET[state])) AND ($_GET[state] == 2))
	{
		$order = array ();
		$keys = array (
			'option',
			'module',
			'suboption',
			'state',
			'ID',
			'gallerypage',
			'last2first'
		);
		foreach ($_GET AS $key => $value)
		{
			if (!in_array($key, $keys))
			{
				$order[$key] = $value;
			}
		}
		asort($order);
		$i = 0;
		foreach ($order AS $key => $value)
		{
			if ($order[$key] != $i +1)
			{
				$valid = false;
				break;
			}
			$i++;
		}
	}

	if (!(IsSet ($_GET[state])) OR (!$valid))
	{
		echo "<form action=\"index.php\" method=\"get\">";
		echo "<span class=\"heading\">" . $sas_lang[sn_allbum_order_album] . "</span><BR><BR>";

		if (!$valid)
		{
			echo "<p><span class=\"text\"><font color=\"red\">" . $sas_lang[sn_allbum_order_invalid] . "</font></span></p>";
		}
		echo "<table>
			      <tr>
		    		<td>
		    		  <p><span class=\"text\">" . $sas_lang[sn_allbum_order_album_text] . ":
		    		     </span>
				  </p><BR>
		    		</td>
			      </tr>
			      <tr>
		    		<td><table><tr>";
		$contents = db_GetContents(0);
		$albumparentarray = array ();
		foreach ($contents AS $key => $value)
		{
			$albumparentarray[$value] = db_GetParentID($value);
		}

		asort($albumparentarray);
		foreach ($albumparentarray AS $key => $value)
		{
			if (!IsSet ($_GET[$key]))
			{
				echo "\n<td><SELECT name=\"" . $key . "\">";
				$i = 1;
				while ($i <= count($albumparentarray))
				{
					echo "<OPTION";
					if ($i == $value)
					{
						echo " selected";
					}
					echo " value=\"" . $i . "\">" . $i . "</OPTION>";
					$i++;
				}
				echo "</SELECT>&nbsp;&nbsp;";
				echo db_GetTitle($key);
				if ($k == 1)
				{
					$k = 0;
					echo "</td><tr>";
				}
				else
				{
					$k = 1;
					echo "</td><td width=\"30\">&nbsp;</td>";
				}
			}
			else
			{
				echo "\n<td><SELECT name=\"" . $key . "\">";
				$i = 1;
				while ($i <= count($albumparentarray))
				{
					echo "<OPTION";
					global ${ $key };
					if ($i == $_GET[$key])
					{
						echo " selected";
					}
					echo " value=\"" . $i . "\">" . $i . "</OPTION>\n";
					$i++;
				}
				echo "</SELECT>&nbsp;&nbsp;";
				echo db_GetTitle($key);
				if ($k == 1)
				{
					$k = 0;
					echo "</td><tr>";
				}
				else
				{
					$k = 1;
					echo "</td><td width=\"30\">&nbsp;</td>\n";
				}
			}
		}
		echo "</tr><tr><td colspan=\"4\">&nbsp;</td></tr>
							<tr><td colspan=\"4\" align=\"right\">" . $sas_lang['sn_allbum_last2first'] . " <input type=\"checkbox\" name=\"last2first\" value=\"1\"></td>
							</tr></table></td>
			      </tr>
			      <tr>
		    		<td>
				    <BR><input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" 
					  onClick=\"javascript:history.go(-1)\" class=\"backbutton\">
		    		  &nbsp;&nbsp;<INPUT type=\"submit\" class=\"savebutton\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang[sn_allbum_order] . "\"><BR>
		    		</td>
			      </tr>
				</table>";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"ordermain\">";
		echo "<INPUT type=\"hidden\" name=\"state\" value=\"2\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
		echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"1\">";
		echo "</form>";
	}
	elseif (($_GET[state] == "2") AND $valid)
	{
		// new orders have been entered and are valid; now reorder items.
		if ($_GET[last2first] == 1) //move the last allbum as first.
		{
			$array_count = count($order);
			foreach ($order AS $key => $value)
			{
				if ($array_count == $value)
				{
					$value = 1; //last one becomes first.
				}
				else
				{
					$value++;
				}
				db_PutParent($key, $value);
			}
		}
		else
		{
			foreach ($order AS $key => $value)
			{
				db_PutParent($key, $value);
			}
		}
		echo $sas_lang[sn_allbum_no_errors];
		echo "<script language='javascript'>
						window.location = 'index.php?option=modulemanager&module=" . $module . "&suboption=show&navpath=" . $_GET[navpath] . "&ID=" . $_GET[ID] .
		"&gallerypage=" . $_GET[gallerypage] . "'</script>";
		echo $sas_lang[sn_allbum_error_redirect];
	}
}
?>