<?php

/*
** DGS Search
** search.php written by James M. Sella
** Copyright (c) 2000-2001 Digital Genesis Software, LLC. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/
#last changed 27/04/2004  , version: 2.4.10  by Fred Stuurman (fc.stuurman@hccnet.nl)
#$Id: search.php,v 1.2 2006/10/15 19:08:55 fstuurman Exp $

if (!defined('IN_SAS'))
{
	die("Hacking attempt");
}
//Fcs added for compatibilty with S@S	
if (IsSet ($_GET['page']))
{
	$page = intval($_GET['page']);
}
if (IsSet ($_GET['section']))
{
	$section = intval($_GET['section']);
}
if (IsSet ($_GET['q']))
{
	$q = $_GET['q'];
}
$q = htmlspecialchars(strip_tags($q)); //remove html tags
if (IsSet ($_GET['r']))
{
	$r = intval($_GET['r']);
}
if (IsSet ($_GET['o']))
{
	$o = intval($_GET['o']);
}

load_language($cmsdir . '/', 'dgs_search'); //load language file

//Fcs end

require ($cmsdir . "/modules/dgs_search/config/config.php");
require ($cmsdir . "/modules/dgs_search/libs/utils.php");

function search($q, $r, $o, $s, $timer)
{
	global $config, $serverpath;
	$modules = array (
		'db'
	);
	$installBase = $serverpath . "/modules/dgs_search";
	$retVal = array ();

	if ($config['debug'])
		printf(">Debug: search()<BR>\n");

	reset($modules);
	while (list (, $module) = each($modules))
	{
		$retVal = $module ($retVal, $q, $r, $o, $s, $timer);
		if (is_string($retVal))
		{
			printf("Error: Search module '%s' had a fatal error. Details below:<BR>\n<BR>\n%s<BR>\n", $module, $retVal);
			exit ();
		}
	}

	return $retVal;
}

function display($retVal, $q, $r, $o, $s, $timer)
{
	global $config, $lang, $sas_config, $serverpath;
	$modules = array (
		'query',
		'stats',
		'hr',
		'nav',
		'results',
		'nav'
	);
	$installBase = $serverpath . "/modules/dgs_search";

	if ($config['debug'])
		printf(">Debug: display()<BR>\n");

	print "<table border=\"0\" cellpadding=\"10\" cellspacing=\"0\" 
	       style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"100%\">
	       <tr><td width=\"500\">" . $sas_config['search_module_welcome'];

	reset($modules);
	while (list (, $module) = each($modules))
	{
		$error = $module ($retVal, $q, $r, $o, $s, $timer);
		if (is_string($error))
		{
			printf("Error: Display module '%s' had a fatal error. Details below:<BR>\n<BR>\n%s<BR>\n", $module, $error);
			break;
		}
	}

	print "<span></td></tr></table>";
}

/* Start of Main */
$max = $sas_config['search_module_results'];
;
$data = getFormData();

$timer = getTime();

if ($config['debug'])
	printf("Debug: main() - Calling processConfig()<BR>\n");

$status = processConfig();
if ($status)
{
	/* Clean up and localize passed values. */
	$r = (!isset ($data['r'])) ? (($max) ? $max : $max) : $data['r']; //Set default for results per page.	
	$r = ($r < 1) ? 65535 : $r;
	$o = (!isset ($data['o']) || $data['o'] < 1) ? 0 : $data['o']; //Set default for offset.
	$s = (!isset ($data['s']) || $data['s'] < 1) ? 0 : $data['s']; //Set result set to 0 if we don't have a cached one.
	$q = (isset ($data['q']) && $data['q'] != '') ? $data['q'] : '';

	/* Search for results. */
	if ($q)
	{
		//if (function_exists('get_html_translation_table')) 
		//{
		//	if ($config['debug'])
		//		printf("Debug: main() - Calling get_html_translation_table()<BR>\n");
		//	$q = strtr($q, get_html_translation_table(HTML_ENTITIES));
		//}
		if ($config['debug'])
			printf("Debug: main() - Calling search(%s, %d, %d, %d, %d)<BR>\n", $q, $r, $o, $s, $timer);
		$retVal = search($q, $r, $o, $s, $timer);
	}

	/* Display our results. */
	if ($config['debug'])
		printf("Debug: main() - Calling display(%s, %d, %d, %d, %d)<BR>\n", $q, $r, $o, $s, $timer);
	display($retVal, $q, $r, $o, $s, $timer);
}

if ($config['debug'])
	printf("Debug: main() - Total Time: %.1f<BR>\n", getTime() - $timer);

/* End of Main */
?>