<?php

// functions.php -- useful subroutines for janitor interface
//
//  $Id: functions.php,v 1.1 2006/10/03 08:33:55 fstuurman Exp $
//
//  Copyright (C) 2004 Peter Fokker, <peter@berestijn.nl>
//
//  This file is part of Janitor.
//
//  Janitor is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  Janitor is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//2005-11-03/FcS changed coding to be able to use the import function
//		of janitor in site@school CMS.

//
// string menu_item($href,$title);
// string start_page($title);
// string end_page(void);
// string navigation_bar($items,$itemwidth)
// string button_bar($items,$itemwidth)
// integer janitorcmd($cmd,$args);
// integer get_listgroups($alist,$force)
// integer get_listusers($alist,$force)
// string group_select_list($exclude,$match)
// array homedir_array($userid="")
// array webmail_array()
// string __($string)
// void init_lang($languagecode)
//

$lang = array ();

include "basic.php";

function start_page($subttl = "")
{
	//------------------------------------------------------------
	// start_page() -- construct the generic pageheader
	global $Message;
	if (!empty ($Message))
		$e .= "<hr>\n<font color=\"" . APP_MSGCOLOR . "\">" . $Message . "</font>\n<hr>\n";
	else
		$e = "";
	return $e;
	//------------------------------------------------------------
} // start_page()

function end_page($footer = PAGE_FOOTER)
{
	//------------------------------------------------------------
	// end_page() -- construct a standard page footer
	$out = "";
	if (!empty ($footer))
		$out .= "\n<hr>\n" .
		"<font size=\"-1\">\n" .
		"<address>" .
		$footer . " " . strftime("%Y-%m-%d %H:%M") .
		"</address> " .
		"</font>\n";
	$out .= "</body>\n" .
	"</html>\n";
	return $out;
	//------------------------------------------------------------
} // end_page()

function button_bar($items, $itemwidth = 15)
{
	//------------------------------------------------------------
	// button_bar() -- return a string with 1 or more buttons 
	// in different table columns (1 row)
	// this routine expects an array in $items
	$n = 0;
	$output = "<p>\n<table border=\"0\" width=\"90%\">\n<tr>\n";
	while (list (, $button) = each($items))
	{
		$output .= "<td align=\"left\" bgcolor=\"" . APP_BUTCOLOR . "\" width=\"" . $itemwidth . "%\">" . $button . "</td>\n";
		$n += $itemwidth;
	}
	$n = 100 - $n;
	$output .= "<td bgcolor=\"" . APP_BUTCOLOR . "\"";
	if ($n > 0)
	{
		$output .= " width=\"" . $n . "%\"";
	}
	$output .= ">&nbsp;</td>\n</tr>\n</table>\n";
	return $output;
	//------------------------------------------------------------
} // button_bar()

function get_listgroups(& $list, $force = FALSE)
{
	//------------------------------------------------------------
	// get_listgroups() -- retrieve list of groups from cache or janitorcmd.
	// if $force = TRUE, we refresh the cached list
	// returns 0 on succes (and the list in $list), non-0 otherwise
	//
	global $JOutput, $JLastline;
	static $cached_groupslist = array ();
	static $in_cache = FALSE;
	$retval = 0; // assume success

	if ((!$in_cache) | ($force))
	{
		if (($retval = janitorcmd("listgroups")) == 0)
		{
			$cached_groupslist = $JOutput;
			asort($cached_groupslist);
			$in_cache = TRUE;
		}
		else
		{
			$Message .= __("Error retrieving list of groups") . ": " . $JLastline;
		}
	}
	if ($in_cache)
		$list = $cached_groupslist;
	else
		$list = array ();
	return $retval;
	//------------------------------------------------------------
} // get_listgroups()

function get_listusers(& $list, $force = FALSE)
{
	//------------------------------------------------------------
	// get_listusers() -- retrieve list of users from cache or janitorcmd.
	// if $force = TRUE, we refresh the cached list
	// returns 0 on succes (and the list in $list), non-0 otherwise
	//
	global $JOutput, $JLastline;
	static $cached_userslist = array ();
	static $in_cache = FALSE;
	$retval = 0; // assume success

	if ((!$in_cache) | ($force))
	{
		if (($retval = janitorcmd("listusers")) == 0)
		{
			$cached_userslist = $JOutput;
			$in_cache = TRUE;
		}
		else
		{
			$Message .= __("Error retrieving list of users") . ": " . $JLastline;
		}
	}
	if ($in_cache)
		$list = $cached_userslist;
	else
		$list = array ();
	return $retval;
	//------------------------------------------------------------
} // get_listusers()

function get_listusergroup($group, & $list, $force = FALSE)
{
	//------------------------------------------------------------
	// get_listusergroup() -- retrieve list of a group from cache or janitorcmd.
	// if $force = TRUE, we refresh the cached list
	// returns 0 on succes (and the list in $list), non-0 otherwise
	//
	global $JOutput, $JLastline;
	static $cached_usergrouplist = array ();
	static $in_cache = FALSE;
	$retval = 0; // assume success

	if ((!$in_cache) | ($force))
	{
		if (($retval = janitorcmd("listusergroup", "$group")) == 0)
		{
			$cached_usergrouplist = $JOutput;
			$in_cache = TRUE;
		}
		else
		{
			$Message .= __("Error retrieving list of users in group") . " '$group': " . $JLastline;
		}
	}
	if ($in_cache)
		$list = $cached_usergrouplist;
	else
		$list = array ();
	return $retval;
	//------------------------------------------------------------
} // get_listusergroup()

function group_select_list($fieldname = "", $exclude = "", $match = "?")
{
	//------------------------------------------------------------
	// group_select_list() -- construct a select list of groups,
	// We retrieve the groupslist and suppress the group(s)
	// in $exclude. If a group matches $match, that entry is 'selected'.
	// The exclude-parameter can be either an array or a string.
	// Both groupnames and groupnumbers are OK.
	//

	$entries = array (
		"?" => __("--------no group selected---------"
	));
	$s = "";
	$ex = array ();
	if (!empty ($exclude))
	{
		if (is_string($exclude))
			$ex = array (
				"$exclude"
			);
		elseif (is_array($exclude)) $ex = $exclude;
	}
	$groupslist = array ();
	if (0 == get_listgroups($groupslist))
	{
		if (!empty ($groupslist))
			foreach ($groupslist as $grouprec)
			{
				list ($name, $id, $members) = explode(':', $grouprec);
				if (!array_search($name, $ex) && !array_search($id, $ex))
					$entries["$name"] = "$name";
			}
	}
	if (!empty ($entries))
		$s = select_field($fieldname, $entries, $match);
	return $s;
	//------------------------------------------------------------
} // group_select_list()

function homedir_array($userid = "")
{
	//------------------------------------------------------------
	// homedir_array() -- generate an array with 4 possibilities
	global $jcfg;
	$a[1] = $jcfg['CHROOT_USERDATA'] . "/./" . $jcfg['SUB_HOME'] . "/" . $jcfg['SUB_USERS'] . "/" . $userid;
	$a[2] = $jcfg['CHROOT_USERDATA'] . "/" . $jcfg['SUB_HOME'] . "/" . $jcfg['SUB_USERS'] . "/" . $userid;
	$a[3] = $jcfg['CHROOT_USERDATA'] . "/" . $jcfg['SUB_HOME'] . "/" . $jcfg['SUB_SKELETONS'] . "/" . $userid;
	$a[4] = $jcfg['CHROOT_BUDDIES'] . "/./" . $jcfg['BUD_HOME'] . "/" . $userid;
	return $a;
	//------------------------------------------------------------
} // homedir_array()

function webmail_array()
{
	//------------------------------------------------------------
	// webmail_array() -- construct list of 3 allowable remote_addr's
	global $jcfg;
	$a[1] = "255.255.255.255/32"; // 1 = none
	$a[2] = "127.0.0.0/8," . $jcfg['INTERNAL_ADDR'];
	$a[3] = "0.0.0.0/0";
	return $a;
	//------------------------------------------------------------
} // function webmail_array() {

function shell_array()
{
	//------------------------------------------------------------
	// shell_array() -- construct list of 3 allowable shells
	$a[1] = "/sbin/nologin";
	$a[2] = "/bin/bash";
	$a[3] = "/bin/sh";
	return $a;
	//------------------------------------------------------------
} // function shell_array() {

function strip8859_1($text)
{
	//------------------------------------------------------------
	// strip8859_1() -- translate chars 128-255 to acceptable (?) ASCII
	// used to generate plain ascii names based on iso 8859-1 input
	// kludge, sorry :-(
	static $s = "";
	static $t = "E________________________________!cL_Y|_\"ca<__r___23'uP__1o>___?AAAAAA_CEEEEIIIIDNOOOOOxOUUUUYPBaaaaaa_ceeeeiiiionooooo:ouuuuypy";
	if ($s == "")
		for ($i = 128; $i < 256; ++ $i)
			$s .= chr($i);
	return strtr($text, $s, $t);
	//------------------------------------------------------------
} // strip8859_1()

function __($s)
{
	//------------------------------------------------------------
	// __() - our own KISS variation on _() alias gettext()
	global $__lang;
	if (empty ($__lang))
		return $s;
	else
	{
		$t = $__lang[$s];
		return (empty ($t)) ? $s : $t;
	}
	//------------------------------------------------------------
} // __()

function init_lang($lcode)
{
	//------------------------------------------------------------
	// init_lang() -- try to read the file .../language/$lcode.php
	// For security reasons we only accept a 2-char lcode so we can't
	// be fooled with ../../../-like tricks to execute arbitrary 
	// PHP-code...
	global $__lang;
	$lang = array ();
	$fname = "language/" . substr($lcode, 0, 2) . ".php";
	if (file_exists($fname))
	{
		include $fname;
	}
	$__lang = $lang;
	//------------------------------------------------------------
} // init_lang()

// eof functions.php
?>
