/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class PostletLabels {
    private String[] language;
    private static final int numLabels = 16;
    private static final String[][] languages = new String[][]{{"EN", "Filename", "File Size", "Finished", "The destination URL provided is not a valid one.", "You have not provided a destination URL.", "Postlet error", "Add", "Remove", "Upload", "Help", "Upload progress:", "Do not close your web browser, or leave this page until upload completes.", "Postlet warning", "Image files", "Select file for upload", "The help URL provided is not a valid one."}, {"DE", "Dateiname", "Dateigr\u00f6\u00dfe", "Fertig", "Die angegebene Ziel-URL ist ung\u00fcltig.", "Es ist keine Ziel-URL angegeben.", "Postlet Fehler", "Hinzuf\u00fcgen", "Entfernen", "Upload", "Hilfe", "Upload prozess:", "Der Browser darf nicht geschlossen werden solange der Upload l\u00e4uft.", "Postlet Warnung", "Bild-Dateien", "Datei zum hochladen ausw\u00e4hlen", "Die angegebene Hilfe-URL ist nicht g\u00fcltig."}, {"NL", "Bestands naam", "Bestands grootte", "Klaar", "De opgegeven doel URL is niet correct.", "U heeft geen doel URL opgegeven.", "Postlet fout", "Toevoegen", "Verwijder", "Upload", "Help", "Upload voortgang", "Uw web browser niet sluiten, of deze pagina verlaten tot dat de upload compleet is.", "Postlet waarschuwing", "Plaatjes bestanden", "Selecteer bestand voor upload", "De help URL is niet correct"}, {"FR", "Nom de fichier", "Taille du fichier", "Termin\u00e9", "L'URL de destination fournie n'est pas valide.", "Vous n'avez pas fourni d'URL de destination.", "Erreur Postlet", "Ajouter", "Enlever", "Envoyer", "Aide", "Progression de l'envoi:", "Ne fermer pas votre browser et rester sur cette page jusqu'\u00e0 l'envoi complet des donn\u00e9es.", "Avertissement Postlet", "Fichiers image", "Selectionner les fichiers \u00e0 envoyer", "L'URL de l'aide fournie n'est pas valide."}, {"ES", "Fichero", "Tama\u00f1o", "Terminado", "La URL destino no es v\u00e1lida.", "No hay una URL destino especificada.", "Postlet error", "A\u00f1adir", "Quitar", "Subir", "Ayuda", "Progreso de la transferencia:", "No cerrar el navegador o esta ventana hasta que la transferencia haya terminado.", "Aviso del Postlet", "Ficheros de im\u00e1genes", "Selecciona los ficheros para subir", "La URL de ayuda no es v\u00e1lida."}, {"IT", "Nome File", "Dimensione File", "Terminato", "L'indirizzo fornito non \u00e8 valido.", "Non hai inserito un indirizzo di destinazione.", "Errore di Postlet", "Aggiungi", "Rimuovi", "Trasferisci", "Help", "Stato del trasferimento", "Non chiudere il browser o cambiare pagina finch\u00e9 il trasferimento non \u00e8 finito.", "Avvertimento di Postlet", "File immagine", "Seleziona il file da trasferire", "L'indirizzo dell'help non \u00e8 valido."}, {"NO", "Filnavn", "Fil st\u00f8rrelse", "Ferdig", "Den URL du oppgav er ikke gyldig.", "Du har ikke oppgitt en URL.", "Postlet feil", "Legg til", "Ta bort", "Last opp", "Hjelp", "Upload gjennomf\u00f8ring:", "Lukk ikke igjen denne nettsiden, eller forlate nettsiden f\u00f8r opplastingen er ferdig.", "Postlet advarsel", "Bildefiler", "Velg fil for opplasting", "Den angitte hjelp URL er ikke gyldig."}, {"FI", "Tiedoston nimi", "Tiedoston koko", "Valmis", "URL-osoitetta ei l\u00f6ydy", "Kirjoita URL-osoite", "Postlet -virhe", "Lis\u00e4\u00e4", "Poista", "lataa", "Help", "Lataaminen k\u00e4ynniss\u00e4", "\u00c4l\u00e4 sulje selainta tai poistu sivuilta ennen kuin lataaminen on p\u00e4\u00e4ttynyt.", "Postlet -varoitus", "Kuvatiedostot", "Valitse tiedosto, jonka aiot ladata", "Help-toiminnon URL-osoitetta ei l\u00f6ydy."}, {"TU", "Dosya Ad\u00fd", "Dosya Boyutu", "Bitti", "Yazd\u00fd\u00f0\u00fdn\u00fdz URL desteklenen bir URL de\u00f0il!", "Belirtilmi\u00fe (desteklenen) bir URL niz yok!", "Postlet Hatas\u00fd", "Ekle", "Kald\u00fdr", "Y\u00fckle", "Yard\u00fdm", "Y\u00fckleme S\u00fcreci", "Y\u00fckleme bitene kadar bu sayfay\u00fd kapatmay\u00fdn veya ayr\u00fdlmay\u00fdn.", "Postlet uyar\u00fds\u00fd", "Resim (imaj) dosyalar\u00fd", "Y\u00fckleme i\u00e7in dosya se\u00e7in", "The help URL provided is not a valid one."}};

    public PostletLabels(String l, URL codeBase) {
        boolean languageIncluded = false;
        for (int i = 0; i < languages.length; ++i) {
            if (!languages[i][0].equalsIgnoreCase(l)) continue;
            languageIncluded = true;
            this.language = languages[i];
            break;
        }
        if (!languageIncluded) {
            this.readUserDefinedLanguageFile(codeBase, l);
        }
    }

    public String getLabel(int i) {
        if (i >= 16) {
            return "ERROR!";
        }
        return this.language[i + 1];
    }

    private void readUserDefinedLanguageFile(URL codeBase, String lang) {
        try {
            URL languageURL = new URL(codeBase.getProtocol() + "://" + codeBase.getHost() + codeBase.getPath() + "language_" + lang.toUpperCase().trim());
            BufferedReader in = new BufferedReader(new InputStreamReader(languageURL.openStream()));
            this.language = new String[16];
            for (int i = 0; i < 16; ++i) {
                this.language[i] = in.readLine();
            }
        }
        catch (FileNotFoundException fnf) {
            this.language = languages[0];
        }
        catch (IOException ioe) {
            this.language = languages[0];
            System.out.println("Language file possibly too short, please ensure it has 17 lines, terminated by a final carriage return");
        }
    }
}

