/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.recordio;

import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import com.servingxml.app.Flow;
import com.servingxml.app.ServiceContext;
import com.servingxml.util.xml.XPathBooleanExpression;
import com.servingxml.util.record.Value;
import com.servingxml.util.PrefixMap;

/**
 * A command for mapping a record in a flat file into an XML stream.
 * 
 * 
 * @author Daniel A. Parker (daniel.parker@servingxml.com)
 */                                                             
                                                            
public class XPathRecordAccepter implements RecordAccepter {
  private final PrefixMap prefixMap;
  private final XPathBooleanExpression expr;

  public XPathRecordAccepter(PrefixMap prefixMap, XPathBooleanExpression expr) {
    this.prefixMap = prefixMap;
    this.expr = expr;
  }

  public boolean accept(ServiceContext context, Flow flow, Value value) {
    XMLReader reader = flow.getRecord().createXmlReader(prefixMap);
    Source source = new SAXSource(reader,new InputSource(""));
    return expr.evaluate(source, flow.getParameters());
  }
}


