/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.util.xml;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

import com.servingxml.util.system.RuntimeContext;

/**
 *
 * 
 * @author Daniel A. Parker (daniel.parker@servingxml.com)
 */

public class DefaultTransformerErrorListener implements ErrorListener {
  private final RuntimeContext context;

  public DefaultTransformerErrorListener(RuntimeContext context) {
    this.context = context;
  }

  public void error(TransformerException exception) throws TransformerException {
    context.error(exception.getMessage() + "( " + exception.getLocationAsString() + " )"); 
  }

  public void fatalError(TransformerException exception) throws TransformerException {
    throw exception;
  }

  public void warning(TransformerException exception) {
    context.warning(exception.getMessage() + "( " + exception.getLocationAsString() + " )"); 
  }
}

