/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.flatfile.options;

import java.io.IOException;

import com.servingxml.util.ByteArrayBuilder;
import com.servingxml.components.flatfile.options.ByteBuffer;

public interface DelimiterByteChecker {
  public static final DelimiterByteChecker NULL = new NullDelimiterChecker();
  public static final DelimiterByteChecker[] EMPTY_DELIMITER_CHECKER_ARRAY = new DelimiterByteChecker[0];

  boolean testStart(ByteBuffer recordBuffer, ByteArrayBuilder byteArrayBuilder) 
  throws IOException;
  boolean foundEndDelimiter(ByteBuffer recordBuffer, ByteArrayBuilder byteArrayBuilder) 
  throws IOException;
  boolean testContinuation(ByteBuffer recordBuffer, ByteArrayBuilder byteArrayBuilder) 
  throws IOException;
  int foundEndDelimiter(byte[] data, int start, int length) 
  throws IOException;
  int testStart(byte[] data, int start, int length) 
  throws IOException;
}

final class NullDelimiterChecker implements DelimiterByteChecker {
  public final boolean testStart(ByteBuffer recordBuffer, ByteArrayBuilder byteArrayBuilder) {
    return false;
  }
  public final boolean foundEndDelimiter(ByteBuffer recordBuffer, ByteArrayBuilder byteArrayBuilder) {
    return false;
  }
  public final boolean testContinuation(ByteBuffer recordBuffer, ByteArrayBuilder byteArrayBuilder) {
    return false;
  }
  public final int foundEndDelimiter(byte[] data, int start, int length) {
    return 0;
  }
  public int testStart(byte[] data, int start, int length) 
  {
    return 0;
  }
}
