/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLInfoPanel
extends IzPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 3257008769514025270L;
    private JEditorPane textArea;

    public HTMLInfoPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.add((Component)LabelFactory.create(parent.langpack.getString("InfoPanel.info"), parent.icons.getImageIcon("edit"), 10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadInfo());
            this.add((Component)scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.getLayoutHelper().completeLayout();
    }

    private URL loadInfo() {
        String resNamePrifix = "HTMLInfoPanel.info";
        try {
            return ResourceManager.getInstance().getURL(resNamePrifix);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean isValidated() {
        return true;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(e.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

