/***************************************************************************

        TI-89

        12/05/2009 Skeleton driver.

****************************************************************************/

#include "driver.h"
#include "cpu/m68000/m68000.h"

static ADDRESS_MAP_START(ti89_mem, ADDRESS_SPACE_PROGRAM, 16 )
	ADDRESS_MAP_UNMAP_HIGH
	AM_RANGE(0x000000, 0x1fffff) AM_ROM
	AM_RANGE(0x200000, 0x2fffff) AM_RAM
ADDRESS_MAP_END

/* Input ports */
static INPUT_PORTS_START( ti89 )
INPUT_PORTS_END


static MACHINE_RESET(ti89)
{
}

static VIDEO_START( ti89 )
{
}

static VIDEO_UPDATE( ti89 )
{
    return 0;
}

static MACHINE_DRIVER_START( ti89 )
    /* basic machine hardware */
    MDRV_CPU_ADD("maincpu",M68000, XTAL_10MHz)
    MDRV_CPU_PROGRAM_MAP(ti89_mem)

    MDRV_MACHINE_RESET(ti89)

    /* video hardware */
    MDRV_SCREEN_ADD("screen", RASTER)
    MDRV_SCREEN_REFRESH_RATE(50)
    MDRV_SCREEN_VBLANK_TIME(ATTOSECONDS_IN_USEC(2500)) /* not accurate */
    MDRV_SCREEN_FORMAT(BITMAP_FORMAT_INDEXED16)
    MDRV_SCREEN_SIZE(640, 480)
    MDRV_SCREEN_VISIBLE_AREA(0, 640-1, 0, 480-1)
    MDRV_PALETTE_LENGTH(2)
    MDRV_PALETTE_INIT(black_and_white)

    MDRV_VIDEO_START(ti89)
    MDRV_VIDEO_UPDATE(ti89)
MACHINE_DRIVER_END

/* ROM definition */
ROM_START( ti89 )
  ROM_REGION( 0x200000, "maincpu", ROMREGION_ERASEFF )
  ROM_SYSTEM_BIOS( 0, "v100", "V 1.00 - HW1" )
  ROMX_LOAD( "ti89v100.rom",   0x000000, 0x200000, CRC(264b34ad) SHA1(c87586a7e9b6d49fbe908fbb6f3c0038f3498573), ROM_BIOS(1))
  ROM_SYSTEM_BIOS( 1, "v100", "V 1.00 [a] - HW1" )
  ROMX_LOAD( "ti89v100a.rom",  0x000000, 0x200000, CRC(95199934) SHA1(b8e3cdeb4705b0c7e0a15ab6c6f62bcde14a3a55), ROM_BIOS(2))
  ROM_SYSTEM_BIOS( 2, "v100", "V 1.00 [m] - HW1" )
  ROMX_LOAD( "ti89v100m.rom",  0x000000, 0x200000, CRC(b9059e06) SHA1(b33a7c2935eb9f73b210bcf6e7c7f32d1548a9d5), ROM_BIOS(3))
  ROM_SYSTEM_BIOS( 3, "v100", "V 1.00 [m2] - HW1" )
  ROMX_LOAD( "ti89v100m2.rom", 0x000000, 0x200000, CRC(cdd69d34) SHA1(1686362b0997bb9597f39b443490d4d8d85b56cc), ROM_BIOS(4))
  ROM_SYSTEM_BIOS( 4, "v105", "V 1.05 - HW1" )
  ROMX_LOAD( "ti89v105.rom",   0x000000, 0x200000, CRC(3bc0b474) SHA1(46fe0cd511eb81d53dc12cc4bdacec8a5bba5171), ROM_BIOS(5))
  ROM_SYSTEM_BIOS( 5, "v201", "V 2.01 - HW1" )
  ROMX_LOAD( "ti89v201.rom",   0x000000, 0x200000, CRC(fa6745e9) SHA1(e4ee6067df9b975356cef6c5a81d0ec664371c1d), ROM_BIOS(6))
  ROM_SYSTEM_BIOS( 6, "v203", "V 2.03 - HW1" )
  ROMX_LOAD( "ti89v203.rom",   0x000000, 0x200000, CRC(a3a74eca) SHA1(55aae3561722a96973b430e3d4cb4f513298ea4e), ROM_BIOS(7))
  ROM_SYSTEM_BIOS( 7, "v203m", "V 2.03 [m] - HW 1" )
  ROMX_LOAD( "ti89v203m.rom",  0x000000, 0x200000, CRC(d79068f7) SHA1(5b6f571417889b11ae19eef99a5fda4f027d5ec2), ROM_BIOS(8))
  ROM_SYSTEM_BIOS( 8, "v209",  "V 2.09 - HW 1" )
  ROMX_LOAD( "ti89v209.rom",   0x000000, 0x200000, CRC(f76f9c15) SHA1(66409ef4b20190a3b7c0d48cbd30257580b47dcd), ROM_BIOS(9))
  ROM_SYSTEM_BIOS( 9, "v105-2","V 1.05 - HW2" )
  ROMX_LOAD( "ti89v105-2.rom", 0x000000, 0x200000, CRC(83817402) SHA1(b2ddf785e973cc3f9a437d058a68abdf7ca52ea2), ROM_BIOS(10))
  ROM_SYSTEM_BIOS( 10, "v203-2",  "V 2.03 - HW2" )
  ROMX_LOAD( "ti89v203-2.rom", 0x000000, 0x200000, CRC(5e0400a9) SHA1(43c608ee72f15aed56cb5762948ec6a3c93dd9d8), ROM_BIOS(11))
  ROM_SYSTEM_BIOS( 11, "v203m-2", "V 2.03 [m] - HW2" )
  ROMX_LOAD( "ti89v203m-2.rom", 0x000000, 0x200000, CRC(04d5d76d) SHA1(14ca44b64c29aa1bf274508ca40fe69224f5a7cc), ROM_BIOS(12))
  ROM_SYSTEM_BIOS( 12, "v205-2", "V 2.05 - HW2" )
  ROMX_LOAD( "ti89v205-2.rom", 0x000000, 0x200000, CRC(37c4653c) SHA1(f48d00a57430230e489e243383513485009b1b98), ROM_BIOS(13))
  ROM_SYSTEM_BIOS( 13, "v205-2m", "V 2.05[m] - HW2" )
  ROMX_LOAD( "ti89v205m-2.rom", 0x000000, 0x200000, CRC(e58a23f9) SHA1(d4cb23fb4b414a43802c37dc3c572a8ede670e0f), ROM_BIOS(14))
  ROM_SYSTEM_BIOS( 14, "v205-2m2","V 2.05[m2] - HW2" )
  ROMX_LOAD( "ti89v205m2-2.rom", 0x000000, 0x200000, CRC(a8ba976c) SHA1(38bd25ada5e2066c64761d1008a9327a37d68654), ROM_BIOS(15))
  ROM_SYSTEM_BIOS( 15,"v209-2", "V 2.09 - HW2" )
  ROMX_LOAD( "ti89v209-2.rom", 0x000000, 0x200000, CRC(242a238f) SHA1(9668df314a0180ef210796e9cb651c5e9f17eb07), ROM_BIOS(16))
ROM_END

ROM_START( ti92 )
  ROM_REGION( 0x300000, "maincpu", ROMREGION_ERASEFF )
  // Internal ROM
  ROM_LOAD( "ti92v111.rom",   0x000000, 0x100000, CRC(67878d52) SHA1(c0fdf162961922a76f286c93fd9b861ce20f23a3))
  // External ROM
  ROM_SYSTEM_BIOS( 0, "v13", "V 1.3" )
  ROMX_LOAD( "ti92v13e.rom",  0x100000, 0x100000, CRC(316c8196) SHA1(82c8cd484c6aebe36f814a2023d2afad6d87f840), ROM_BIOS(1))
  ROM_SYSTEM_BIOS( 1, "v14", "V 1.4" )
  ROMX_LOAD( "ti92v14e.rom",  0x100000, 0x100000, CRC(239e9405) SHA1(df2f1ab17d490fda43a02f5851b5a15052361b28), ROM_BIOS(2))
  ROM_SYSTEM_BIOS( 2, "v17", "V 1.7" )
  ROMX_LOAD( "ti92v17e.rom",  0x100000, 0x100000, CRC(83e27cc5) SHA1(aec5a6a6157ff94a4e665fa3fe747bacb6688cd4), ROM_BIOS(3))
  ROM_SYSTEM_BIOS( 3, "v111", "V 1.11" )
  ROMX_LOAD( "ti92v111e.rom", 0x100000, 0x100000, CRC(4a343833) SHA1(ab4eaacc8c83a861c8d37df5c10e532d0d580460), ROM_BIOS(4))
  ROM_SYSTEM_BIOS( 4, "v112", "V 1.12" )
  ROMX_LOAD( "ti92v112e.rom", 0x100000, 0x100000, CRC(9a6947a0) SHA1(8bb0538ca98711e9ad46c56e4dfd609d4699be30), ROM_BIOS(5))
  ROM_SYSTEM_BIOS( 5, "v21", "V 2.1" )
  ROMX_LOAD( "ti92v21e.rom",  0x100000, 0x200000, CRC(5afb5863) SHA1(bf7b260d37d1502cc4b08dea5e1d55b523f27925), ROM_BIOS(6))

ROM_END

ROM_START( ti92p )
  ROM_REGION( 0x200000, "maincpu", ROMREGION_ERASEFF )
  ROM_SYSTEM_BIOS( 0, "v100", "V 1.00 - HW1" )
  ROMX_LOAD( "ti92pv100.rom", 0x0000, 0x200000, CRC(c651a586) SHA1(fbbf7e053e70eefe517f9aae40c072036bc614ea), ROM_BIOS(1))
  ROM_SYSTEM_BIOS( 1, "v101", "V 1.01 - HW1" )
  ROMX_LOAD( "ti92pv101.rom", 0x0000, 0x200000, CRC(826b1539) SHA1(dd8969511fc6233bf2047f83c3306ac8d2be5644), ROM_BIOS(2))
  ROM_SYSTEM_BIOS( 2, "v101a","V 1.01 [a] - HW1" )
  ROMX_LOAD( "ti92pv101a.rom", 0x0000, 0x200000, CRC(18f9002f) SHA1(2bf13ba7da0212a8706c5a43853dc2ccb8c2257d), ROM_BIOS(3))
  ROM_SYSTEM_BIOS( 3, "v101m", "V 1.01 [m] - HW1" )
  ROMX_LOAD( "ti92pv101m.rom", 0x0000, 0x200000, CRC(fe2b6e77) SHA1(0e1bb8c677a726ee086c1a4280ab59de95b4abe2), ROM_BIOS(4))
  ROM_SYSTEM_BIOS( 4, "v105", "V 1.05 - HW1" )
  ROMX_LOAD( "ti92pv105.rom", 0x0000, 0x200000, CRC(cd945824) SHA1(6941aca243c6fd5c8a377253bffc2ffb5a84c41b), ROM_BIOS(5))
  ROM_SYSTEM_BIOS( 5, "v105-2", "V 1.05 - HW2" )
  ROMX_LOAD( "ti92pv105-2.rom", 0x0000, 0x200000, CRC(289aa84f) SHA1(c9395750e20d5a201401699d156b62f00530fcdd), ROM_BIOS(6))
  ROM_SYSTEM_BIOS( 6, "v203", "V 2.03 - HW2" )
  ROMX_LOAD( "ti92pv203.rom", 0x0000, 0x200000, CRC(1612213e) SHA1(1715dd5913bed12baedc4912e9abe0cb4e48cd45), ROM_BIOS(7))
  ROM_SYSTEM_BIOS( 7, "v204", "V 2.04 - HW2" )
  ROMX_LOAD( "ti92pv204.rom", 0x0000, 0x200000, CRC(86819be3) SHA1(78032a0f5f11d1e9a45ffbea91e7f9657fd1a8ae), ROM_BIOS(8))
  ROM_SYSTEM_BIOS( 8, "v205", "V 2.05 - HW2" )
  ROMX_LOAD( "ti92pv205.rom",  0x0000, 0x200000, CRC(9509c575) SHA1(703410d8bb98b8ec14277efcd8b7dda45a7cf358), ROM_BIOS(9))
  ROM_SYSTEM_BIOS( 9, "v205m", "V 2.05 [m] - HW2" )
  ROMX_LOAD( "ti92pv205m.rom",  0x000000, 0x200000, CRC(13ef4d57) SHA1(6ef290bb0dda72f645cd3eca9cc1185f6a2d32dc), ROM_BIOS(10))
  ROM_SYSTEM_BIOS( 10, "v209", "V 2.09 - HW2" )
  ROMX_LOAD( "ti92pv209.rom",  0x000000, 0x200000, CRC(4851ad52) SHA1(10e6c2cdc60623bf0be7ea72a9ec840259fb37c3), ROM_BIOS(11))
ROM_END

/* Driver */

/*    YEAR  NAME    PARENT  COMPAT   MACHINE    INPUT    INIT    CONFIG COMPANY   FULLNAME       FLAGS */
COMP( 1998, ti89,  0,       0, 	ti89, 	ti89, 	 0,  	  0,	"Texas Instruments",	"TI-89",		 GAME_NOT_WORKING)
COMP( 1995, ti92,  0,       0, 	ti89, 	ti89, 	 0,  	  0,	"Texas Instruments",	"TI-92",		 GAME_NOT_WORKING)
COMP( 1999, ti92p, 0,       0, 	ti89, 	ti89, 	 0,  	  0,	"Texas Instruments",	"TI-92 Plus", GAME_NOT_WORKING)

