/*
 * Decompiled with CFR 0.152.
 */
package org.scala.tools.eclipse.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.scala.tools.eclipse.search.Util$;
import org.scala.tools.eclipse.search.indexing.Index;
import org.scala.tools.eclipse.search.indexing.Occurrence;
import org.scala.tools.eclipse.search.indexing.OccurrenceCollector$;
import org.scala.tools.eclipse.search.indexing.SourceIndexer$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.tools.eclipse.ScalaProject;
import scala.tools.eclipse.javaelements.ScalaSourceFile;
import scala.tools.eclipse.logging.HasLogger;
import scala.tools.eclipse.logging.Logger;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001f\ti1k\\;sG\u0016Le\u000eZ3yKJT!a\u0001\u0003\u0002\u0011%tG-\u001a=j]\u001eT!!\u0002\u0004\u0002\rM,\u0017M]2i\u0015\t9\u0001\"A\u0004fG2L\u0007o]3\u000b\u0005%Q\u0011!\u0002;p_2\u001c(BA\u0006\r\u0003\u0015\u00198-\u00197b\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011+A\u0011\u0011cE\u0007\u0002%)\t1\"\u0003\u0002\u0015%\t1\u0011I\\=SK\u001a\u0004\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\u000f1|wmZ5oO*\u0011qA\u0007\u0006\u0003\u0013II!\u0001H\f\u0003\u0013!\u000b7\u000fT8hO\u0016\u0014\b\u0002\u0003\u0010\u0001\u0005\u000b\u0007I\u0011A\u0010\u0002\u000b%tG-\u001a=\u0016\u0003\u0001\u0002\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u000b%sG-\u001a=\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0001\na!\u001b8eKb\u0004\u0003\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002*UA\u0011\u0011\u0005\u0001\u0005\u0006=\u0019\u0002\r\u0001\t\u0005\u0006Y\u0001!\t!L\u0001\rS:$W\r\u001f)s_*,7\r\u001e\u000b\u0003]]\u00022a\f\u001a5\u001b\u0005\u0001$BA\u0019\u0013\u0003\u0011)H/\u001b7\n\u0005M\u0002$a\u0001+ssB\u0011\u0011#N\u0005\u0003mI\u0011A!\u00168ji\")\u0001h\u000ba\u0001s\u0005!\u0001O]8k!\tQ4(D\u0001\u001a\u0013\ta\u0014D\u0001\u0007TG\u0006d\u0017\r\u0015:pU\u0016\u001cG\u000fC\u0003?\u0001\u0011\u0005q(\u0001\u0006j]\u0012,\u00070\u0013$jY\u0016$\"A\f!\t\u000b\u0005k\u0004\u0019\u0001\"\u0002\t\u0019LG.\u001a\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0011B]3t_V\u00148-Z:\u000b\u0005\u001dC\u0015\u0001B2pe\u0016T!a\u0002\u0007\n\u0005)#%!B%GS2,\u0007\"\u0002'\u0001\t\u0003i\u0015AD5oI\u0016D8kY1mC\u001aKG.\u001a\u000b\u0003]9CQaT&A\u0002A\u000b!a\u001d4\u0011\u0005E#V\"\u0001*\u000b\u0005MK\u0012\u0001\u00046bm\u0006,G.Z7f]R\u001c\u0018BA+S\u0005=\u00196-\u00197b'>,(oY3GS2,w!B,\u0003\u0011\u0003A\u0016!D*pkJ\u001cW-\u00138eKb,'\u000f\u0005\u0002\"3\u001a)\u0011A\u0001E\u00015N\u0011\u0011\f\u0005\u0005\u0006Oe#\t\u0001\u0018\u000b\u00021\u001a!a,\u0017\u0001`\u0005m)f.\u00192mKR{\u0017J\u001c3fq\u001aKG.Z:Fq\u000e,\u0007\u000f^5p]N\u0011Q\f\u0019\t\u0003C&t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u0015t\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tA'#A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'!C#yG\u0016\u0004H/[8o\u0015\tA'\u0003\u0003\u0005n;\n\u0015\r\u0011\"\u0001o\u0003\u00151\u0017\u000e\\3t+\u0005y\u0007cA1q\u0005&\u0011\u0011o\u001b\u0002\u0004'\u0016\f\b\u0002C:^\u0005\u0003\u0005\u000b\u0011B8\u0002\r\u0019LG.Z:!\u0011\u00159S\f\"\u0001v)\t1\b\u0010\u0005\u0002x;6\t\u0011\fC\u0003ni\u0002\u0007q\u000e")
public class SourceIndexer
implements HasLogger {
    private final Index index;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        SourceIndexer sourceIndexer = this;
        synchronized (sourceIndexer) {
            if (!this.bitmap$0) {
                this.logger = HasLogger.class.logger((HasLogger)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Logger eclipseLog() {
        return HasLogger.class.eclipseLog((HasLogger)this);
    }

    public Index index() {
        return this.index;
    }

    public Try<BoxedUnit> indexProject(ScalaProject proj) {
        this.index().deleteIndex(proj.underlying());
        None$ blockingFailure = None$.MODULE$;
        ObjectRef ioFailures = new ObjectRef((Object)Nil$.MODULE$);
        Iterator it = proj.allSourceFiles().iterator();
        while (blockingFailure.isEmpty() && it.hasNext()) {
            BoxedUnit boxedUnit;
            IFile file = (IFile)it.next();
            boolean bl = false;
            Failure failure = null;
            Try<BoxedUnit> try_ = this.indexIFile(file);
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (ex instanceof IOException) {
                    ioFailures.elem = (Seq)((Seq)ioFailures.elem).$colon$plus((Object)file, Seq$.MODULE$.canBuildFrom());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                blockingFailure = new Some((Object)failure);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Try)blockingFailure.fold((Function0)new Serializable(this, ioFailures){
            public static final long serialVersionUID = 0L;
            private final ObjectRef ioFailures$1;

            public final Try<BoxedUnit> apply() {
                return ((Seq)this.ioFailures$1.elem).isEmpty() ? new Success((Object)BoxedUnit.UNIT) : new Failure((Throwable)new UnableToIndexFilesException((Seq<IFile>)((Seq)this.ioFailures$1.elem)));
            }
            {
                this.ioFailures$1 = ioFailures$1;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Try<BoxedUnit> apply(Try<BoxedUnit> fail) {
                return fail;
            }
        });
    }

    public Try<BoxedUnit> indexIFile(IFile file) {
        Success success = new Success((Object)BoxedUnit.UNIT);
        return this.index().isIndexable(file) ? (Try)Util$.MODULE$.scalaSourceFileFromIFile(file).fold((Function0)new Serializable(this, (Try)success){
            public static final long serialVersionUID = 0L;
            private final Try success$1;

            public final Try<BoxedUnit> apply() {
                return this.success$1;
            }
            {
                this.success$1 = success$1;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SourceIndexer $outer;

            public final Try<BoxedUnit> apply(ScalaSourceFile cu) {
                return this.$outer.indexScalaFile(cu);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }) : success;
    }

    public Try<BoxedUnit> indexScalaFile(ScalaSourceFile sf) {
        this.logger().debug((Function0)new Serializable(this, sf){
            public static final long serialVersionUID = 0L;
            private final ScalaSourceFile sf$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexing document: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sf$1.file().path()}));
            }
            {
                this.sf$1 = sf$1;
            }
        });
        return this.index().removeOccurrencesFromFile(sf.workspaceFile().getProjectRelativePath(), sf.scalaProject()).flatMap((Function1)new Serializable(this, sf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SourceIndexer $outer;
            public final ScalaSourceFile sf$1;

            public final Try<BoxedUnit> apply(BoxedUnit _) {
                return OccurrenceCollector$.MODULE$.findOccurrences(this.sf$1).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$indexScalaFile$2 $outer;

                    public final Try<BoxedUnit> apply(Seq<Occurrence> occurrences) {
                        return this.$outer.org$scala$tools$eclipse$search$indexing$SourceIndexer$$anonfun$$$outer().index().addOccurrences(occurrences, this.$outer.sf$1.scalaProject()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(BoxedUnit _) {
                                new Success((Object)BoxedUnit.UNIT);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SourceIndexer org$scala$tools$eclipse$search$indexing$SourceIndexer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sf$1 = sf$1;
            }
        });
    }

    public SourceIndexer(Index index) {
        this.index = index;
        HasLogger.class.$init$((HasLogger)this);
    }

    public static class UnableToIndexFilesException
    extends Exception {
        private final Seq<IFile> files;

        public Seq<IFile> files() {
            return this.files;
        }

        public UnableToIndexFilesException(Seq<IFile> files) {
            this.files = files;
        }
    }
}

