/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.eclipse.contribution.weaving.jdt.jcompiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class ExpandableResourceDelta
extends PlatformObject
implements IResourceDelta {
    private IResourceDelta wrapped;
    private List<ExpandableResourceDelta> children = new ArrayList<ExpandableResourceDelta>();
    private IResource resource;

    private ExpandableResourceDelta(IResourceDelta resourceDelta) {
        this.wrapped = resourceDelta;
    }

    private ExpandableResourceDelta(IResource resource) {
        this.resource = resource;
    }

    public void accept(IResourceDeltaVisitor visitor) throws CoreException {
        this.accept(visitor, 0);
    }

    public void accept(IResourceDeltaVisitor visitor, boolean includePhantoms) throws CoreException {
        this.accept(visitor, includePhantoms ? 1 : 0);
    }

    public void accept(IResourceDeltaVisitor visitor, int memberFlags) throws CoreException {
        IResourceDelta[] iResourceDeltaArray = this.getAffectedChildren(7, memberFlags);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            visitor.visit(child);
            ++n2;
        }
    }

    public IResourceDelta findMember(IPath path) {
        if (path.segmentCount() == 0) {
            return this;
        }
        IPath fullPath = this.getFullPath().append(path.segment(0));
        int nbSegments = fullPath.segmentCount();
        for (IResourceDelta iResourceDelta : this.children) {
            if (iResourceDelta.getFullPath().matchingFirstSegments(fullPath) != nbSegments) continue;
            return iResourceDelta.findMember(path.removeFirstSegments(1));
        }
        return null;
    }

    public IResourceDelta[] getAffectedChildren() {
        return this.getAffectedChildren(7, 0);
    }

    public IResourceDelta[] getAffectedChildren(int kindMask) {
        return this.getAffectedChildren(kindMask, 0);
    }

    public IResourceDelta[] getAffectedChildren(int kindMask, int memberFlags) {
        ArrayList<IResourceDelta> affectedChildren = new ArrayList<IResourceDelta>();
        if ((memberFlags & 1) != 0) {
            kindMask |= 0x18;
        }
        boolean includeHidden = (memberFlags & 8) != 0;
        boolean includeTeamPrivateMember = (memberFlags & 2) == 0;
        for (IResourceDelta iResourceDelta : this.children) {
            if ((kindMask & iResourceDelta.getKind()) == 0 || !includeHidden && iResourceDelta.getResource().isHidden() || !includeTeamPrivateMember && iResourceDelta.getResource().isTeamPrivateMember()) continue;
            affectedChildren.add(iResourceDelta);
        }
        return affectedChildren.toArray(new IResourceDelta[affectedChildren.size()]);
    }

    public int getFlags() {
        if (this.wrapped != null) {
            return this.wrapped.getFlags();
        }
        return 256;
    }

    public IPath getFullPath() {
        if (this.wrapped != null) {
            return this.wrapped.getFullPath();
        }
        return this.resource.getFullPath();
    }

    public int getKind() {
        if (this.wrapped != null) {
            return this.wrapped.getKind();
        }
        return 4;
    }

    public IMarkerDelta[] getMarkerDeltas() {
        if (this.wrapped != null) {
            return this.wrapped.getMarkerDeltas();
        }
        return new IMarkerDelta[0];
    }

    public IPath getMovedFromPath() {
        if (this.wrapped != null) {
            return this.wrapped.getMovedFromPath();
        }
        return null;
    }

    public IPath getMovedToPath() {
        if (this.wrapped != null) {
            return this.wrapped.getMovedToPath();
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        if (this.wrapped != null) {
            return this.wrapped.getProjectRelativePath();
        }
        return this.resource.getFullPath().makeRelativeTo(this.resource.getProject().getFullPath());
    }

    public IResource getResource() {
        if (this.wrapped != null) {
            return this.wrapped.getResource();
        }
        return this.resource;
    }

    public void addChangedResource(IResource changedResource) {
        this.getOrAddResourceForChange(changedResource);
    }

    private ExpandableResourceDelta getOrAddResourceForChange(IResource newResource) {
        if (this.getResource().equals((Object)newResource)) {
            if (this.getKind() == 0) {
                this.resource = this.wrapped.getResource();
                this.wrapped = null;
            }
            return this;
        }
        ExpandableResourceDelta parentResourceDelta = this.getOrAddResourceForChange((IResource)newResource.getParent());
        for (ExpandableResourceDelta childResourceDelta : parentResourceDelta.children) {
            if (!childResourceDelta.getResource().equals((Object)newResource)) continue;
            return childResourceDelta;
        }
        ExpandableResourceDelta newResourceDelta = new ExpandableResourceDelta(newResource);
        parentResourceDelta.children.add(newResourceDelta);
        return newResourceDelta;
    }

    public static ExpandableResourceDelta duplicate(IResourceDelta original) {
        ExpandableResourceDelta newDelta = new ExpandableResourceDelta(original);
        IResourceDelta[] iResourceDeltaArray = original.getAffectedChildren(31, 11);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            newDelta.children.add(ExpandableResourceDelta.duplicate(child));
            ++n2;
        }
        return newDelta;
    }

    public String toString() {
        return "ExtendedResourceDelta(" + this.getFullPath() + ")";
    }
}

