/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.eclipse.contribution.weaving.jdt.jcompiler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import scala.tools.eclipse.contribution.weaving.jdt.jcompiler.ExpandableResourceDelta;

public class BuildManagerStore {
    public static final BuildManagerStore INSTANCE = new BuildManagerStore();
    private Map<IProject, File[]> projectToJavaSourceFiles = new HashMap<IProject, File[]>();

    private BuildManagerStore() {
    }

    public IResourceDelta appendJavaSourceFilesToCompile(IResourceDelta delta, IProject project) {
        if (delta == null) {
            return delta;
        }
        File[] files = this.projectToJavaSourceFiles.get(project);
        if (files == null || files.length == 0) {
            return delta;
        }
        ExpandableResourceDelta newDelta = ExpandableResourceDelta.duplicate(delta);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IFile[] iFileArray = workspaceRoot.findFilesForLocationURI(file.toURI());
            int n3 = iFileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IFile resource = iFileArray[n4];
                if (resource.getProject() == project) {
                    newDelta.addChangedResource((IResource)resource);
                }
                ++n4;
            }
            ++n2;
        }
        return newDelta;
    }

    public void setJavaSourceFilesToCompile(File[] files, IProject project) {
        if (files == null) {
            this.projectToJavaSourceFiles.remove(project);
        } else {
            this.projectToJavaSourceFiles.put(project, files);
        }
    }
}

