/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.eclipse.contribution.weaving.jdt.imagedescriptor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import scala.tools.eclipse.contribution.weaving.jdt.ScalaJDTWeavingPlugin;
import scala.tools.eclipse.contribution.weaving.jdt.imagedescriptor.IImageDescriptorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageDescriptorSelectorRegistry
implements Iterable<IImageDescriptorSelector> {
    private static final ImageDescriptorSelectorRegistry INSTANCE = new ImageDescriptorSelectorRegistry();
    private static final String SELECTORS_EXTENSION_POINT = "org.scala-ide.sdt.aspects.imagedescriptorselector";
    private Set<IImageDescriptorSelector> registry;

    public static ImageDescriptorSelectorRegistry getInstance() {
        return INSTANCE;
    }

    private ImageDescriptorSelectorRegistry() {
    }

    void registerSelector(IImageDescriptorSelector provider) {
        this.registry.add(provider);
    }

    public boolean isRegistered() {
        return this.registry != null;
    }

    public void registerSelectors() {
        IExtension[] exs;
        this.registry = new HashSet<IImageDescriptorSelector>();
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(SELECTORS_EXTENSION_POINT);
        if (exP != null && (exs = exP.getExtensions()) != null) {
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] configs = exs[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    try {
                        IConfigurationElement config = configs[j];
                        if (config.isValid()) {
                            IImageDescriptorSelector provider = (IImageDescriptorSelector)config.createExecutableExtension("class");
                            this.registry.add(provider);
                        }
                    }
                    catch (CoreException e) {
                        ScalaJDTWeavingPlugin.logException(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public Iterator<IImageDescriptorSelector> iterator() {
        if (!this.isRegistered()) {
            this.registerSelectors();
        }
        return this.registry.iterator();
    }
}

