<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cat="http://www.saxonica.com/ns/doc/catalog"
	xmlns:fn="http://www.saxonica.com/ns/doc/functions"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:saxon="http://saxon.sf.net/"
	exclude-result-prefixes="cat fn xs saxon">

<xsl:include href="render-functions.xsl"/>

<xsl:output method="html" encoding="iso-8859-1"
            doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>

<xsl:param name="destination" select="'online'" as="xs:string"/>
         <!-- set this to "online" for the web site, "offline" for the document supplied in the download"-->
         
<xsl:variable name="img" select="if ($destination='online') then '../img' else 'img'"/>         

<xsl:import-schema schema-location="saxon-doc-schema.xsd"/>
<xsl:import-schema namespace="http://www.saxonica.com/ns/doc/catalog" 
                             schema-location="catalog-schema.xsd"/>
<xsl:import-schema namespace="http://www.saxonica.com/ns/doc/functions" 
                             schema-location="functions-schema.xsd"/>

<xsl:variable name="sections" select="/cat:catalog/cat:section/@ref"/>

<xsl:template match="/">
    <!-- process the catalog file -->
	<xsl:if test="not(* instance of schema-element(cat:catalog))">
	  <xsl:message terminate="yes">
	      Input file must be a validated instance of cat:catalog
	  </xsl:message>
	</xsl:if>   
	<xsl:apply-templates/>
	<xsl:call-template name="generate-contents"/>
</xsl:template>

<xsl:template match="cat:catalog">
  <xsl:for-each select="cat:section/@ref">
    <xsl:variable name="doc" select="document(concat(., '.xml'))"/>
    <xsl:if test="not($doc/html instance of schema-element(html) or 
	                  $doc/fn:conformance instance of schema-element(fn:conformance))">
	   <xsl:message terminate="yes">Input <xsl:value-of select="."/> has not been validated against the schema</xsl:message>
	</xsl:if>
    <xsl:apply-templates select="$doc/((html/body)|fn:conformance)">
       <xsl:with-param name="this-doc" select="string(.)" tunnel="yes"/>
    </xsl:apply-templates>
  </xsl:for-each>
</xsl:template>

<!-- entry point for processing a single document -->

<xsl:template match="/" mode="single-doc">
    <xsl:apply-templates select="./((html/body)|fn:conformance)">
       <xsl:with-param name="this-doc" select="tokenize(document-uri(.), '/')[last()]" tunnel="yes"/>
    </xsl:apply-templates>
</xsl:template>    


<xsl:template match="element(*, inline) | element(*, list-type) | tr | td | li | a | table | br | thead | tbody">
  <xsl:copy copy-namespaces="no">
    <xsl:copy-of select="@*"/>
	<xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="*">
  <xsl:message>
     *** Unrecognized element <xsl:value-of select="name(.)"/> of type <xsl:value-of select="saxon:type-annotation(.)"/> ***
  </xsl:message>
</xsl:template>

<xsl:template match="a[starts-with(string(@href), 'http://') or starts-with(string(@href), '../javadoc')
                            or starts-with(string(@href), '../dotnetdoc')]">
  <xsl:copy copy-namespaces="no">
    <xsl:copy-of select="@*"/>
    <xsl:attribute name="target" select="'_blank'"/>
    <xsl:attribute name="class" select="'bodylink'"/>
	  <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="a[starts-with(string(@href), '#')]">
  <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
  <xsl:message>** obsolete hyperlink in <xsl:value-of select="document-uri(/)"/>:  <xsl:copy-of select="."/></xsl:message>
  <xsl:variable name="frag" select="substring-after(string(@href), '#')"/>
  <xsl:variable name="anchor" as="attribute()" select="
          (//h2[@id = $frag]/@id | //a[@name=$frag]/@name)[1]"/>
  <xsl:variable name="page" select="
          if (name($anchor) = 'name')
          then string($anchor/ancestor::page/h2/@id)
          else $frag"/>
  <xsl:variable name="subpage" as="xs:string" select="
          if (name($anchor) = 'name')
          then concat('#', string($anchor))
          else ''"/>
  <xsl:if test="not($anchor)">
    <xsl:message>*** Dangling local link <xsl:value-of select="@href"/>
    <!--Found: <xsl:for-each select="//h2"><xsl:value-of select="@id"/>, </xsl:for-each>-->
    </xsl:message>
  </xsl:if>
  <xsl:variable name="up" as="xs:string" select="
         if (ancestor::subpage) then '../../'
         else if (ancestor::page) then '../'
         else ''"/> 

  <xsl:copy copy-namespaces="no">
    <xsl:copy-of select="@* except @href"/>
    <xsl:attribute name="href" select="concat($up, $this-doc, '/', $page, '.html', $subpage)"/>
    <xsl:attribute name="target" select="'_self'"/>
    <xsl:attribute name="class" select="'bodylink'"/>
	  <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="a[matches(string(@href), '^[A-Za-z\-]+.html#.+$')]">
  <xsl:param name="this-doc" required="yes" tunnel="yes"  as="xs:string"/>
  <xsl:message>** obsolete hyperlink in <xsl:value-of select="document-uri(/)"/>: <xsl:copy-of select="."/></xsl:message>
  <xsl:variable name="section" select="substring-before(string(@href), '.html')"/>
  <xsl:variable name="page" select="substring-after(string(@href), '#')"/>
  <xsl:if test="not($sections[.=$section])">
    <xsl:message>*** Dangling section in link <xsl:value-of select="@href"/></xsl:message>
  </xsl:if>
  <xsl:variable name="target-section" select="document(concat($section, '.xml'))"/>
  <xsl:if test="not($target-section//h2[@id=$page])">
    <xsl:message>*** Dangling page in link <xsl:value-of select="@href"/></xsl:message>
  </xsl:if>
  <xsl:copy copy-namespaces="no">
    <xsl:copy-of select="@* except @href"/>
    <xsl:attribute name="class" select="'bodylink'"/>
    <xsl:attribute name="href">
      <xsl:text>javascript:topage('</xsl:text>
      <xsl:value-of select="$section"/>
      <xsl:text>', '</xsl:text>
      <xsl:value-of select="$page"/>
      <xsl:text>')</xsl:text>
    </xsl:attribute>
	  <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="a[matches(string(@href), '^[A-Za-z\-]+\.html$')]">
  <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
  <xsl:message>** obsolete hyperlink in <xsl:value-of select="document-uri(/)"/>:  <xsl:copy-of select="."/></xsl:message>
  <xsl:variable name="section" select="substring-before(string(@href), '.html')"/>
  <xsl:copy copy-namespaces="no">
    <xsl:copy-of select="@* except @href"/>
    <xsl:attribute name="class" select="'bodylink'"/>
    <xsl:attribute name="href">
      <xsl:text>javascript:topage('</xsl:text>
      <xsl:value-of select="$section"/>
      <xsl:text>', 'intro')</xsl:text>
    </xsl:attribute>
	<xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="body">
  <!--<xsl:call-template name="make-menu"/>-->
  <xsl:apply-templates select="page"/>
</xsl:template>

<xsl:template match="page">
  <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
  <xsl:variable name="pgid" select="(h2/@id, position())[1]"/>
  <xsl:if test="count(p) gt 10">
    <xsl:message>** Warning: long page <xsl:value-of select="$this-doc, h2/@id"/></xsl:message>
  </xsl:if>
  <xsl:result-document href="{$this-doc}/{$pgid}.html">
    <xsl:call-template name="make-page">
	  <xsl:with-param name="title" select="if (h2 = 'Introduction') then ../h1 else h2"/>
    </xsl:call-template>
  </xsl:result-document>
</xsl:template>

<xsl:template name="make-page">
  <xsl:param name="title" as="xs:string" required="yes"/>
  <xsl:variable name="path-prefix" as="xs:string" 
                select="if (self::page) then '../'
				        else if (self::subpage) then '../../'
						else ''"/>
  <xsl:variable name="paras" select=".//p except .//subpage//p"/>
  <xsl:variable name="est-length" select="max((ceiling(sum($paras/string-length()) idiv 4) + 
                                               count($paras) * 20 +
											   (if (subpageindex) then count(subpage)*40 else 0), 1000))"/>
  <xsl:variable name="est-length" select="if (@size) then $est-length * @size else $est-length"/>
<!--<xsl:comment>Est sizes <xsl:value-of select="sum($paras/string-length()) idiv 4, count($paras) * 20, 
(if (subpageindex) then count(subpage)*40 else 0)"/></xsl:comment>-->											    
    <html>
    <head>
			<xsl:comment>
				<!--<xsl:value-of select="$this-doc, $pgid" separator="/"/>-->
				Generated at <xsl:value-of select="current-dateTime()"/>
			</xsl:comment>
    <title>Saxonica: XSLT and XQuery Processing: <xsl:value-of select="$title"/></title>
    <meta name="coverage" content="Worldwide"/>
    <meta name="copyright" content="Copyright Saxonica Ltd"/>
    <meta name="title" content="Saxonica: XSLT and XQuery Processing: {$title}"/>
    <meta name="robots" content="noindex,nofollow"/>
    <link rel="stylesheet" href="{$path-prefix}saxondocs.css" type="text/css"/>

    </head>
    <body class="main">
      <div id="rhDkBlueArea" style="position:absolute; width:123px; height:{$est-length}px; z-index:2; right: 0px; top: 0px; border: 1px none #000000; background-color: #C1CEDE; layer-background-color: #C1CEDE; visibility: visible;"></div>
      <div id="rhMdBlueArea" style="position:absolute; width:217px; height:{$est-length}px; z-index:2; right: 340px; top: 0px; border: 1px none #000000; background-color: #E4EEF0; layer-background-color: #E4EEF0; visibility: visible;"></div>
      <div id="lhLightArea" style="position:absolute; width:34px; height:{$est-length}px; z-index:2; left: 66px; top: 0px; border: 1px none #000000; background-color: #f6fffb; layer-background-color: #E4EEF0; visibility: visible;"></div>
      <div id="lhDkBlueArea" style="position:absolute; width:66px; height:{$est-length}px; z-index:2; left: 0px; top: 0px; border: 1px none #000000; background-color: #C1CEDE; layer-background-color: #C1CEDE; visibility: visible;"></div>
      <div id="LogoArea" style="position:absolute; width:340px; height:72px; z-index:3; right: 0px; top: 0px; border: 1px none #000000; visibility: visible;">
	    <a href="{$path-prefix}index/intro.html"><img src="{$path-prefix}{$img}/saxonica_logo.gif" width="340" height="72" border="0" alt="Saxonica.com"/></a>
      </div>

      <div id="MenuArea" style="position:absolute; width:157px; z-index:4; right: 33px; top: 114px; visibility: visible; background-color: #f6fffb; layer-background-color: #f6fffb; border: 1px solid #3D5B96; padding-top:9px; padding-left:15px;padding-right:11px; padding-bottom:9px;"> 
         <xsl:call-template name="make-menu"/>
      </div>
      <div id="MainTextArea" style="position:absolute; height:100%; z-index:5; left: 130px; right: 260px; top: 110px; border: 1px none #000000; visibility: visible;">
		    <h1><xsl:value-of select="$title"/></h1>
			<xsl:apply-templates select="* except h1"/>
		    <table width="100%">
			  <tr><td>
				  <p align="right">
					<xsl:choose>
					<xsl:when test="following-sibling::subpage">
					  <a class="nav" href="{following-sibling::subpage[1]/@id}.html">Next</a>
					</xsl:when>
					<xsl:when test="../following-sibling::page">
					  <a class="nav" href="../{../following-sibling::page[1]/h2/@id}.html">Next</a>
					</xsl:when>
					<xsl:when test="child::subpage">
					  <a class="nav" href="{h2/@id}/{child::subpage[1]/@id}.html">Next</a>
					</xsl:when>
					<xsl:when test="following-sibling::page">
					  <a class="nav" href="{following-sibling::page[1]/h2/@id}.html">Next</a>
					</xsl:when>
					</xsl:choose>
				  </p>
			  </td></tr>
		    </table>	
	  </div>
	</body>
    </html>
</xsl:template>

<xsl:template match="subpage">
  <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
  <xsl:variable name="pgid" select="../h2/@id"/>
  <xsl:if test="count(p) gt 10">
    <xsl:message>** Warning: long sub-page <xsl:value-of select="$this-doc, $pgid, @id"/></xsl:message>
  </xsl:if>
  <xsl:result-document href="{$this-doc}/{$pgid}/{@id}.html">
    <xsl:call-template name="make-page">
      <xsl:with-param name="title" select="@title"/>
    </xsl:call-template>
  </xsl:result-document>
</xsl:template>

<xsl:template match="subpageindex">
<ul>
  <xsl:for-each select="../subpage">
  <li><p><a class="bodylink" href="{ancestor::page/h2/@id}/{@id}.html">
    <xsl:value-of select="@title"/></a>
    <xsl:if test="@summary">
	    <xsl:value-of select="':', @summary" separator=" "/>
    </xsl:if>
  </p></li>
  </xsl:for-each>
</ul>
</xsl:template>

<xsl:template match="pageindex">
<ul>
  <xsl:for-each select="../../page except parent::page">
  <li><p><a class="bodylink" href="{h2/@id}.html">
    <xsl:value-of select="h2"/></a>
  </p></li>
  </xsl:for-each>
</ul>
</xsl:template>

<xsl:function name="fn:path-prefix" as="xs:string">
  <xsl:param name="node" as="element(xref)"/>
  <xsl:sequence select="if ($node/ancestor::subpage) then '../../'
                                      else if ($node/ancestor::page) then '../'
									  else ''"/>
</xsl:function>

<xsl:template match="xref[@subpage]">
  <xsl:variable name="section" select="(@section, /html/@section)[1]"/>
  <xsl:variable name="page" select="(@page, ancestor::page/h2/@id)[1]"/>
  <a class="bodylink" href="{fn:path-prefix(.)}{$section}/{$page}/{@subpage}.html">
    <xsl:value-of select="."/>
    <xsl:if test=".=''">
      <xsl:message>*** Empty link!!! *** <xsl:copy-of select=".."/>(<xsl:value-of select="'section', document-uri(.), 'page', ancestor::page/h2"/>)</xsl:message>
    </xsl:if>  
  </a>
</xsl:template>

<xsl:template match="xref[@page and not(@subpage)]">
  <xsl:variable name="section" select="(@section, /html/@section)[1]"/>
  <xsl:variable name="page" select="(@page, ancestor::page/h2/@id)[1]"/>
  <a class="bodylink" href="{fn:path-prefix(.)}{$section}/{$page}.html">
    <xsl:value-of select="."/>
    <xsl:if test=".=''">
      <xsl:message>*** Empty link!!! *** <xsl:copy-of select=".."/>(<xsl:value-of select="'section', document-uri(.), 'page', ancestor::page/h2"/>)</xsl:message>
    </xsl:if>      
  </a>
</xsl:template>

<xsl:template match="xref[@section and not(@page)]" saxon:explain="no" xmlns:saxon="http://saxon.sf.net/">
  <a class="bodylink" href="{fn:path-prefix(.)}{@section}/intro.html">
    <xsl:value-of select="."/>
    <xsl:if test=".=''">
      <xsl:message>*** Empty link!!! *** <xsl:copy-of select=".."/>(<xsl:value-of select="'section', document-uri(.), 'page', ancestor::page/h2"/>)</xsl:message>
    </xsl:if>
  </a>
</xsl:template>

<xsl:template name="make-menu">
  <xsl:param name="this-doc" required="no" tunnel="yes"  as="xs:string"/>
  <xsl:variable name="this-page" select="ancestor-or-self::page[1]"/>
  <xsl:variable name="path-prefix" as="xs:string" 
                select="if (self::page) then '../'
				        else if (self::subpage) then '../../'
						else ''"/>
  <xsl:variable name="short-prefix" as="xs:string" 
                select="if (self::page) then ''
				        else if (self::subpage) then '../'
						else ''"/>
    <table width="164" border="0" bgcolor="#3D5B96" cellspacing="1" cellpadding="1">
	 <xsl:choose>
	    <xsl:when test="$destination='online'">
          <tr bgcolor="#f6fffb"><td style="padding-left:5px"><a href="{$path-prefix}index/intro.html">Main Menu</a></td></tr>
        </xsl:when>
		<xsl:otherwise>
         <tr bgcolor="#f6fffb"><td style="padding-left:5px"><a href="http://www.saxonica.com/">SAXONICA</a></td></tr>
        </xsl:otherwise>
	</xsl:choose>
    </table>
    <br/>
    <table border="0" cellspacing="0" cellpadding="1">
    <tr>
    <td class="title" colspan="2">Saxon Documentation</td></tr>
    <tr><td colspan="2"><img src="{$path-prefix}{$img}/spacer.gif" width="120" height="10" border="0" alt=""/></td></tr>
    <tr><td colspan="2"><a href="{$path-prefix}contents.html">Full Contents</a></td></tr>
    <tr><td colspan="2"><img src="{$path-prefix}{$img}/text_blue_dot.gif" width="164" height="1" border="0" alt=""/></td></tr>         
    <xsl:for-each select="document('catalog.xml')/cat:catalog/cat:section/@ref">
	  <xsl:variable name="target" select="document(concat(., '.xml'))"/>
      <tr>
	    <td colspan="2">
		  <a href="{$path-prefix}{.}/intro.html">
            <xsl:value-of select="($target//h1, 'Function Library')[1]"/>
          </a>
		</td>
      </tr>

	  <xsl:if test=". = $this-doc">
        <xsl:for-each select="$target//page">
          <tr>
          <td>
		    <xsl:choose>
			<xsl:when test=". is $this-page">&#xbb;&#xa0;</xsl:when>
		    <xsl:otherwise>
			  <img src="{$path-prefix}{$img}/spacer.gif" width="10" height="5" border="0" 
			                    alt="blank space"/>
            </xsl:otherwise>
			</xsl:choose>
		  </td>
          <td>
		    <!--<xsl:if test=". is $this-page">&#xbb;&#xa0;</xsl:if>-->
		    <a href="{$short-prefix}{h2/@id}.html"><xsl:value-of select="h2"/></a></td>
		  </tr>
        </xsl:for-each>
      </xsl:if>
      <tr><td colspan="2"><img src="{$path-prefix}{$img}/text_blue_dot.gif" width="164" height="1" border="0" alt=""/></td></tr>         
    </xsl:for-each>
    </table>
</xsl:template>

<xsl:template match="h2">
 <!-- <h1><xsl:apply-templates/></h1>-->
</xsl:template>

<xsl:template match="h3">
  <p class="subhead"><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="code[pre]">
  <div class="codeblock"><pre><code>
  <xsl:apply-templates select="pre/*"/>
  </code></pre></div>
</xsl:template>

<xsl:template match="pre">
  <div style="border: solid thin; background-color: #B1CCC7; padding: 2px" class="codeblock">
  <xsl:next-match/>
  </div>
</xsl:template>

<xsl:template match="example" priority="2">
  <div class="codeblock" style="border: solid thin; background-color: #B1CCC7; padding: 2px"><pre><code>
  <xsl:apply-templates/>
  </code></pre></div>
</xsl:template>

<xsl:template match="box" priority="2">
  <div class="boxed" style="border: solid thin; background-color: #B1CCC7; padding: 2px">
  <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="command" priority="2">
  <p class="command">
    <xsl:apply-templates/>
  </p>
</xsl:template>

<xsl:template match="defect" priority="1.5">
  <p><a href="http://sourceforge.net/tracker/index.php?func=detail&amp;aid={@id}&amp;group_id=29872&amp;atid=397617"
        target="_new" class="bodylink"><xsl:value-of select="@id"/></a>&#xa0;
		<xsl:apply-templates/>
  </p>
</xsl:template>

<!-- add <p> elements inside a <td> or <li> if not there already -->

<xsl:template match="td[not(p) and not(@align='center')]">
  <!-- the test on "align" is to avoid changing the knight's tour diagram -->
  <xsl:copy copy-namespaces="no">
  <xsl:copy-of select="@*"/>
  <p><xsl:apply-templates/></p>
  </xsl:copy>
</xsl:template>

<xsl:template match="li[not(p)]">
  <xsl:copy copy-namespaces="no">
  <xsl:copy-of select="@*"/>
  <p><xsl:apply-templates/></p>
  </xsl:copy>
</xsl:template>

<xsl:template match="fn:conformance">
  <xsl:variable name="temp">
    <xsl:document validation="strict">
      <xsl:apply-templates select="fn:functions" mode="f"/>
    </xsl:document>
  </xsl:variable>
  <xsl:apply-templates select="$temp//body"/>
</xsl:template>

<xsl:template name="generate-contents">
  <xsl:result-document href="contents.html">
    <html>
    <head>
	<xsl:comment>
		Generated at <xsl:value-of select="format-dateTime(current-dateTime(), '[D] [MNn] [Y0001] at [H01]:[m01]')"/>
	</xsl:comment>
    <title>Saxonica: XSLT and XQuery Processing: <xsl:value-of select="@title"/></title>
    <meta name="coverage" content="Worldwide"/>
    <meta name="copyright" content="Copyright Saxonica Ltd"/>
    <meta name="title" content="Saxonica: XSLT and XQuery Processing: {@title}"/>
    <meta name="robots" content="noindex,nofollow"/>
    <link rel="stylesheet" href="saxondocs.css" type="text/css"/>

    </head>
    <body class="main">
	  <h1>Saxon Documentation</h1>
      <xsl:for-each select="$sections">
        <xsl:variable name="sname" select="string(.)"/>
        <xsl:variable name="sect" select="document(concat(., '.xml'))"/>
        <p class="subhead"><xsl:value-of select="($sect//h1)[1]"/></p>
        <xsl:choose>
        <xsl:when test="$sname = 'functions'">
          <xsl:for-each select="$sect">
            <xsl:call-template name="make-function-contents-page"/>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
        <ul>
          <xsl:for-each select="$sect/html/body/page">
            <xsl:variable name="h" select="h2[1]"/>
            <li><a class="toc2" href="{concat($sname, '/', $h/@id, '.html')}">
               <xsl:value-of select="$h"/>
               </a>
               <xsl:if test="subpage">
               <ul>
                 <xsl:for-each select="subpage">
                   <li><a href="{concat($sname, '/', $h/@id, '/', @id, '.html')}">
                     <xsl:value-of select="@title"/>
                   </a></li>
                 </xsl:for-each>
               </ul>
               </xsl:if>
            </li>
          </xsl:for-each>
        </ul>
        </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </body>
    </html>
  </xsl:result-document>
</xsl:template>  

<xsl:template match="html-example">
  <xsl:copy-of select="*"/>
</xsl:template>

</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="render&#x2D;page" userelativepaths="yes" externalpreview="no" url="changes.xml" htmlbaseurl="" outputurl="" processortype="saxon8" useresolver="no" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext="" validateoutput="no" validator="internal" customvalidator=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition><TemplateContext></TemplateContext><MapperFilter side="source"></MapperFilter></MapperMetaTag>
</metaInformation>
-->