/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtils {
    public static void copyDir(String src, String dest) throws IOException, InterruptedException {
        FileUtils.copyDir(new File(src), new File(dest));
    }

    public static void copyDir(File src, File dest) throws IOException {
        dest.mkdirs();
        for (File file : src.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.copyDir(file, new File(dest, file.getName()));
                continue;
            }
            FileUtils.copyFile(file, new File(dest, file.getName()));
        }
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileUtils.copyFile(new File(src), new File(dest));
    }

    public static boolean renameFile(String oldPath, String newPath) {
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        if (newFile.exists()) {
            newFile.delete();
        }
        return oldFile.renameTo(newFile);
    }

    public static void copyFile(File src, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        dest.createNewFile();
        FileChannel sourceChannel = new FileInputStream(src).getChannel();
        FileChannel targetChannel = new FileOutputStream(dest).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
    }

    public static String cleanFileName(String fileName) {
        if (fileName == null) {
            return fileName;
        }
        return fileName.replaceAll("[\\\\/:*?\"<>|]", "");
    }
}

