/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.util.BrowserType;
import net.sf.sahi.util.FileUtils;
import net.sf.sahi.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserTypesLoader {
    private static Map<String, BrowserType> browserTypes = new HashMap<String, BrowserType>();

    public static void loadBrowserTypes() {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(new File(BrowserTypesLoader.getBrowserTypesFilePath()));
            Element root = document.getDocumentElement();
            NodeList childNodes = root.getElementsByTagName("browserType");
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element el = (Element)childNodes.item(i);
                BrowserType browserType = new BrowserType(el);
                BrowserTypesLoader.addBrowserType(browserType);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static String getBrowserTypesFilePath() {
        String path = Configuration.getBrowserTypesPath();
        if (new File(path).exists()) {
            return path;
        }
        String xmlPath = Utils.concatPaths(Configuration.getConfigPath(), "browser_types/" + Utils.getOSFamily() + ".xml");
        try {
            FileUtils.copyFile(xmlPath, path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }

    public static void addBrowserType(BrowserType browserType) {
        browserTypes.put(browserType.name(), browserType);
    }

    public BrowserType getBrowserType(HttpRequest request) {
        String browserTypeParam = request.getParameter("browserType");
        return BrowserTypesLoader.getBrowserType(browserTypeParam);
    }

    public static BrowserType getBrowserType(String name) {
        if (Utils.isBlankOrNull(name)) {
            return null;
        }
        return browserTypes.get(name);
    }

    public static Map<String, BrowserType> getBrowserTypes() {
        return browserTypes;
    }

    public static Map<String, BrowserType> getAvailableBrowserTypes(boolean printMessage) {
        if (printMessage) {
            System.out.println("-----");
            System.out.println("Reading browser types from: " + BrowserTypesLoader.getBrowserTypesFilePath());
        }
        HashMap<String, BrowserType> availableBrowserTypes = new HashMap<String, BrowserType>();
        Iterator<String> iterator = browserTypes.keySet().iterator();
        while (iterator.hasNext()) {
            BrowserType browserType = browserTypes.get(iterator.next());
            String expanded = Utils.expandSystemProperties(browserType.path());
            if (browserType.force() || new File(expanded).exists()) {
                availableBrowserTypes.put(browserType.name(), browserType);
                continue;
            }
            if (!printMessage) continue;
            System.out.println(browserType.displayName() + " was not found at " + expanded);
        }
        if (printMessage) {
            System.out.println("-----");
        }
        return availableBrowserTypes;
    }

    static {
        BrowserTypesLoader.loadBrowserTypes();
    }
}

