/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.test.TestLauncher;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteLoader {
    private String suitePath;
    private String base;
    private List<TestLauncher> listTest = new ArrayList<TestLauncher>();

    public SuiteLoader(String suitePath, String base) {
        this.suitePath = suitePath;
        this.base = base;
        this.loadScripts();
    }

    private void loadScripts() {
        File suite = new File(Configuration.getAbsoluteUserPath(this.suitePath));
        if (suite.isDirectory()) {
            this.processSuiteDir(suite);
        } else if (Utils.isSahiTestFile(this.suitePath)) {
            this.addTest(this.suitePath, this.base);
        } else {
            this.processSuiteFile();
        }
    }

    private void processSuiteDir(File suite) {
        File[] fileNames = suite.listFiles();
        for (int i = 0; i < fileNames.length; ++i) {
            File file = fileNames[i];
            if (file.isDirectory()) {
                this.processSuiteDir(file);
                continue;
            }
            String testName = Utils.getAbsolutePath(file);
            if (!Utils.isSahiTestFile(testName)) continue;
            this.addTest(testName, this.base);
        }
    }

    private void processSuiteFile() {
        String contents = new String(Utils.readFileAsString(Configuration.getAbsoluteUserPath(this.suitePath)));
        StringTokenizer tokens = new StringTokenizer(contents, "\n");
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            try {
                this.processLine(line.trim());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void processLine(String line) throws MalformedURLException {
        String startURL;
        String testName;
        if (line.startsWith("#") || line.startsWith("//") || line.trim().equals("")) {
            return;
        }
        int ix = line.indexOf(32);
        if (ix == -1) {
            ix = line.indexOf(9);
        }
        if (ix != -1) {
            testName = line.substring(0, ix).trim();
            startURL = line.substring(ix).trim();
        } else {
            testName = line;
            startURL = "";
        }
        if (!startURL.startsWith("http://") && !startURL.startsWith("https://")) {
            startURL = new URL(new URL(this.base), startURL).toString();
        }
        this.addTest(Utils.concatPaths(this.suitePath, testName, true), startURL);
    }

    public void addTest(String testName, String startURL) {
        TestLauncher sahiTest = new TestLauncher(testName, startURL);
        this.listTest.add(sahiTest);
    }

    public List<TestLauncher> getListTest() {
        return this.listTest;
    }
}

