/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.rhino;

import java.util.logging.Logger;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.report.HtmlReporter;
import net.sf.sahi.report.Report;
import net.sf.sahi.report.ResultType;
import net.sf.sahi.rhino.ScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.SahiTestSuite;
import net.sf.sahi.test.TestLauncher;
import net.sf.sahi.util.Utils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoScriptRunner
extends ScriptRunner
implements Runnable {
    private SahiScript script;
    Report report;
    TestLauncher launcher;
    private String recoveryScript;
    private static final Logger logger = Logger.getLogger("net.sf.sahi.rhino.ScriptRunner");
    private Scriptable scope;
    private Status scriptStatus = Status.INITIAL;
    protected String stackTrace = "";

    RhinoScriptRunner(String js) {
        this.setJS(js);
    }

    public RhinoScriptRunner(SahiScript script) {
        this(script, null, null, true);
    }

    public RhinoScriptRunner(SahiScript script, SahiTestSuite suite, TestLauncher launcher, boolean setDefaultReporters) {
        this.script = script;
        this.suite = suite;
        this.launcher = launcher;
        this.setReporter(setDefaultReporters);
        String jsString = script.jsString();
        this.setJS(jsString);
    }

    private void setJS(String jsString) {
        this.js = "_sahi.start();" + jsString;
    }

    public void setSession(Session session) {
        super.setSession(session);
        this.logFileNameBase = Utils.createLogFileName(this.script.getScriptName());
    }

    public void execute() {
        new Thread(this).start();
    }

    public void executeAndWait() {
        Thread thread = new Thread(this);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setRecoveryScript(String recoveryScript) {
        this.recoveryScript = recoveryScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block25: {
            this.report.startTimer();
            String lib = Configuration.getRhinoLibJS();
            Context cx = Context.enter();
            cx.setOptimizationLevel(Configuration.getRhinoOptimizationLevel());
            this.scope = cx.initStandardObjects();
            try {
                Object wrappedOut = Context.javaToJS((Object)this, (Scriptable)this.scope);
                ScriptableObject.putProperty((Scriptable)this.scope, (String)"ScriptRunner", (Object)wrappedOut);
                cx.evaluateString(this.scope, lib, "RhinoScriptRunner.run", 1, null);
                cx.evaluateString(this.scope, this.js, "RhinoScriptRunner.run", 1, null);
            }
            catch (RhinoException ee) {
                if (this.browserException != null) {
                    this.scriptStatus = Status.FAILURE;
                    this.report.addResult(this.browserException + "\n" + this.stackTrace, ResultType.ERROR, this.debugInfo, null);
                    this.browserException = null;
                } else {
                    this.scriptStatus = Status.FAILURE;
                    this.report.addResult("ERROR \n" + this.stackTrace, ResultType.ERROR, this.script.getLineDebugInfo(ee.lineNumber() - 1), ee.details());
                }
                this.setHasError();
                if (this.recoveryScript == null) break block25;
                try {
                    this.report.addResult("--- Recovery Start ---", ResultType.INFO, null, null);
                    cx.evaluateString(this.scope, this.recoveryScript, "RhinoScriptRunner.run", 1, null);
                }
                catch (RhinoException ee2) {
                    if (this.browserException != null) {
                        this.scriptStatus = Status.FAILURE;
                        this.report.addResult(this.browserException, ResultType.ERROR, this.debugInfo, null);
                    } else {
                        this.scriptStatus = Status.FAILURE;
                        this.report.addResult("ERROR ", ResultType.ERROR, this.script.getDebugInfo(ee2.lineNumber() - 1), ee2.details());
                    }
                }
                finally {
                    this.report.addResult("--- Recovery End ---", ResultType.INFO, null, null);
                }
            }
            catch (Exception e) {
                logger.warning(Utils.getStackTraceString(e, false));
                this.scriptStatus = Status.FAILURE;
                this.report.addResult("ERROR ", ResultType.ERROR, e.getMessage(), e.getMessage());
                this.setHasError();
            }
            finally {
                try {
                    cx.evaluateString(this.scope, "_sahi.callOnScriptEnd();", "RhinoScriptRunner.run", 1, null);
                }
                catch (Exception e2) {
                    this.report.addResult("ERROR ", ResultType.ERROR, e2.getMessage(), e2.getMessage());
                }
                Context.exit();
                if (this.scriptStatus == Status.INITIAL) {
                    this.scriptStatus = Status.SUCCESS;
                }
                this.stop();
                cx = null;
            }
        }
    }

    public void markStepDoneFromLib(String stepId, String typeName, String failureMessage) {
        this.markStepDone(stepId, ResultType.getType(typeName), failureMessage);
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public boolean needsStackTrace() {
        return this.browserRetries > 2 && "".equals(this.stackTrace);
    }

    public void markStepDone(String stepId, ResultType type, String failureMessage) {
        super.markStepDone(stepId, type, failureMessage);
        if (stepId.equals("" + this.counter)) {
            if (type == ResultType.ERROR) {
                this.scriptStatus = Status.FAILURE;
                if (!this.stopOnError) {
                    this.report.addResult(SahiScript.stripSahiFromFunctionNames(this.step), type, this.debugInfo, failureMessage + "\n" + this.stackTrace);
                }
            } else {
                if (type == ResultType.FAILURE) {
                    this.scriptStatus = Status.FAILURE;
                    failureMessage = failureMessage + "\n" + this.stackTrace;
                }
                this.report.addResult(SahiScript.stripSahiFromFunctionNames(this.step), type, this.debugInfo, failureMessage);
            }
        }
    }

    public String getScriptFilePath() {
        return this.getScript().getFilePath();
    }

    private void setReporter(boolean setDefaultReporters) {
        String reportFileNameBase = this.getScriptName();
        this.report = setDefaultReporters ? (this.suite != null ? new Report(reportFileNameBase, this.suite.getListReporter()) : new Report(reportFileNameBase, new HtmlReporter())) : new Report(reportFileNameBase);
    }

    public String getScriptName() {
        return this.script.getScriptName();
    }

    public SahiScript getScript() {
        return this.script;
    }

    public int getThreadNo() {
        if (this.launcher == null) {
            return 0;
        }
        return this.launcher.getThreadNo();
    }

    public Report getReport() {
        return this.report;
    }

    public void log(String message, String debugInfo, String resultType) {
        this.report.addResult(message, ResultType.getType(resultType), debugInfo, "");
    }

    public void logException(String message, String debugInfo, boolean isError) {
        if (isError) {
            this.setHasError();
        }
        this.report.addResult("Logging exception: ", isError ? ResultType.ERROR : ResultType.CUSTOM, debugInfo, message);
    }

    public void setHasError() {
        this.setStatus(Status.FAILURE);
    }

    public void logExceptionWithLineNumber(String message, int lineNumber, boolean isFailure) {
        this.logException(message, this.script.getDebugInfo(lineNumber), isFailure);
    }

    public Status getScriptStatus() {
        return this.scriptStatus;
    }

    public boolean isPartOfSuite() {
        return this.suite != null;
    }

    public void stop() {
        super.stop();
        try {
            this.report.stopTimer();
            this.report.generateTestReport(this.getLogFileNameBase());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.suite != null) {
            this.suite.notifyComplete(this.launcher);
        }
    }

    public String eval(String js) {
        Object result;
        Context cx = Context.enter();
        try {
            result = cx.evaluateString(this.scope, "_sahi.toJSON(" + js + ")", "RhinoScriptRunner.eval", 1, null);
        }
        catch (Exception e) {
            result = e.getLocalizedMessage();
        }
        Context.exit();
        return result.toString();
    }
}

