/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.util.Utils;

public class NoCacheHttpResponse
extends HttpResponse {
    private static final Logger logger = Logger.getLogger("net.sf.sahi.response.NoCacheHttpResponse");
    private int status = 200;
    private String statusMessage = "OK";

    public NoCacheHttpResponse() {
        this("");
    }

    public NoCacheHttpResponse(String dataStr) {
        this.setNoCacheHeaders(Utils.getBytes(dataStr));
    }

    public NoCacheHttpResponse(int status, String statusMessage, String dataStr) {
        this.status = status;
        if (status != 200) {
            this.statusMessage = "";
        }
        this.statusMessage = statusMessage == null ? "" : statusMessage;
        this.setNoCacheHeaders(Utils.getBytes(dataStr));
    }

    protected void setNoCacheHeaders(byte[] data) {
        this.setNoCacheHeaders(data, null);
    }

    protected void setNoCacheHeaders(byte[] data, String contentType) {
        this.setData(data);
        this.setFirstLine("HTTP/1.1 " + this.status + " " + this.statusMessage);
        if (contentType == null) {
            this.setHeader("Content-Type", "text/html");
        } else {
            this.setHeader("Content-Type", contentType);
        }
        this.setHeader("Cache-control", "no-store");
        this.setHeader("Pragma", "no-cache");
        this.setHeader("Expires", "-1");
        this.setHeader("Content-Length", "" + this.data().length);
        this.resetRawHeaders();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(new String(this.rawHeaders()));
        }
    }

    public NoCacheHttpResponse(HttpResponse httpResponse) {
        this.setNoCacheHeaders(httpResponse.data(), httpResponse.contentTypeHeader());
    }
}

