/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import net.sf.sahi.config.Configuration;

public class MimeType {
    private static Properties properties = new Properties();

    public static String get(String fileExtension, String defaultValue) {
        fileExtension = fileExtension == null ? "" : fileExtension.toLowerCase();
        return properties.getProperty(fileExtension, defaultValue);
    }

    public static String getMimeTypeOfFile(String fileName) {
        return MimeType.getMimeTypeOfFile(fileName, "text/plain");
    }

    public static String getMimeTypeOfFile(String fileName, String defaultValue) {
        return MimeType.get(MimeType.getExtension(fileName), defaultValue);
    }

    static String getExtension(String fileName) {
        int ix = fileName.lastIndexOf(46);
        if (ix == -1) {
            return "";
        }
        return fileName.substring(ix);
    }

    static {
        try {
            properties.load(new FileInputStream(Configuration.getMimeTypesMappingFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

