/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import net.sf.sahi.StreamHandler;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.util.TrafficLogger;
import net.sf.sahi.util.Utils;

public class HttpResponse
extends StreamHandler {
    protected HttpResponse() {
    }

    public HttpResponse(InputStream in, HttpURLConnection connection) {
        this.setHeaders(connection);
        this.setFirstLine(connection);
        this.setContentLength(-1);
        try {
            this.populateData(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setFirstLine(HttpURLConnection connection) {
        Map<String, List<String>> connheaders = connection.getHeaderFields();
        List<String> firstLines = connheaders.get(null);
        if (firstLines == null) {
            return;
        }
        for (String line : firstLines) {
            if (line.indexOf("HTTP") == -1) continue;
            this.setFirstLine(line);
        }
    }

    private void setHeaders(HttpURLConnection connection) {
        String key;
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            this.addHeader(key, connection.getHeaderField(i));
            ++i;
        }
    }

    public String contentTypeHeader() {
        return this.getLastSetValueOfHeader("Content-Type");
    }

    public void keepAlive(boolean keepAliveEnabled) {
        this.setFirstLine(this.firstLine().replaceAll("HTTP/1.0", "HTTP/1.1"));
        this.removeHeader("Content-length");
        int len = this.data() != null ? this.getModifiedContentLength() : 0;
        this.setHeader("Content-Length", "" + len);
        this.removeHeader("Connection");
        this.removeHeader("Accept-ranges");
        this.setHeader("Connection", keepAliveEnabled ? "Keep-Alive" : "close");
        this.resetRawHeaders();
    }

    public void proxyKeepAlive(boolean keepAliveEnabled) {
        this.setFirstLine(this.firstLine().replaceAll("HTTP/1.0", "HTTP/1.1"));
        this.removeHeader("Connection");
        this.removeHeader("Accept-ranges");
        this.removeHeader("Accept-Ranges");
        this.setHeader("Accept-Ranges", "none");
        this.setHeader("Proxy-Connection", keepAliveEnabled ? "Keep-Alive" : "close");
    }

    public boolean isAttachment() {
        if (Configuration.downloadIfContentDispositionIsAttachment()) {
            String contentDisposition = this.getLastSetValueOfHeader("Content-Disposition");
            if (contentDisposition == null) {
                return false;
            }
            return contentDisposition.toLowerCase().indexOf("attachment") != -1;
        }
        return false;
    }

    public void sendHeaders(OutputStream out, boolean isKeepAlive) throws IOException {
        BufferedOutputStream outputStreamToBrowser = new BufferedOutputStream(out);
        this.modifyHeaders(isKeepAlive);
        this.resetRawHeaders();
        TrafficLogger.storeResponseHeader(this.rawHeaders(), "modified");
        ((OutputStream)outputStreamToBrowser).write(this.rawHeaders());
        ((OutputStream)outputStreamToBrowser).flush();
    }

    public void modifyHeaders(boolean isKeepAlive) {
        this.proxyKeepAlive(isKeepAlive);
        this.removeHeader("Transfer-Encoding");
        this.removeHeader("Transfer-encoding");
        this.setContentLength(this.getModifiedContentLength());
    }

    int getModifiedContentLength() {
        return this.data() == null ? 0 : this.data().length;
    }

    public void sendBody(OutputStream out) throws IOException {
        BufferedOutputStream bufferedOut = new BufferedOutputStream(out);
        byte[] data = this.data();
        if (data != null) {
            int start = 0;
            int limit = Utils.BUFFER_SIZE;
            for (int left = data.length; left > 0; left -= limit) {
                if (left < limit) {
                    limit = left;
                }
                ((OutputStream)bufferedOut).write(data, start, limit);
                ((OutputStream)bufferedOut).flush();
                start += limit;
            }
        }
        ((OutputStream)bufferedOut).flush();
        TrafficLogger.storeResponseBody(data, "modified");
    }

    public void cleanUp() {
    }
}

