/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.io.UnsupportedEncodingException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheFilter;
import net.sf.sahi.stream.filter.HTMLModifierFilter;
import net.sf.sahi.stream.filter.JSModifierFilter;

public class HttpModifiedResponse2
extends HttpResponse {
    boolean isSSL = false;
    private String fileExtension;
    private String charset;
    private String dataString;

    public HttpModifiedResponse2(HttpResponse response, boolean isSSL, String fileExtension, int responseCode) {
        this.fileExtension = fileExtension;
        this.copyFrom(response);
        this.isSSL = isSSL;
        if (responseCode < 300 || responseCode >= 400) {
            boolean html = this.isHTML();
            boolean js = this.isJs();
            if (html || js) {
                this.charset();
                byte[] data = this.data();
                if (data == null) {
                    this.dataString = "";
                } else {
                    try {
                        this.dataString = new String(data, this.charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        this.dataString = new String(data);
                    }
                }
                if (html) {
                    HTMLModifierFilter htmlModifierFilter = new HTMLModifierFilter(this.charset, this.isXHTML(), isSSL);
                    htmlModifierFilter.modifyHeaders(response);
                    this.dataString = htmlModifierFilter.modify(this.dataString);
                }
                JSModifierFilter jsModifierFilter = new JSModifierFilter(this.charset);
                this.dataString = jsModifierFilter.modify(this.dataString);
                try {
                    this.setData(this.dataString.getBytes(this.charset));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (html) {
                    new NoCacheFilter().modifyHeaders(response);
                }
            }
        }
    }

    public HttpModifiedResponse2(HttpResponse response, boolean isSSL, String fileExtension) {
        this(response, isSSL, fileExtension, 200);
    }

    private boolean isJs() {
        String contentType = this.contentTypeHeader();
        if (contentType != null && contentType.toLowerCase().indexOf("javascript") != -1) {
            return true;
        }
        String fileExtensionLC = this.fileExtension.toLowerCase();
        return "js".equals(fileExtensionLC) || "js.dsp".equals(fileExtensionLC) || fileExtensionLC.endsWith(".js") || fileExtensionLC.endsWith("js.dsp");
    }

    private boolean isXHTML() {
        if (Configuration.forceTreatAsXHTML()) {
            return true;
        }
        String s = this.getSampleContent();
        return s.indexOf("<?xml") != -1 || s.indexOf("<!doctype") != -1;
    }

    private boolean isHTML() {
        if (this.isJs()) {
            return false;
        }
        String contentType = this.contentTypeHeader();
        if (contentType != null && (contentType.toLowerCase().indexOf("text/html") != -1 || contentType.toLowerCase().indexOf("application/xhtml+xml") != -1)) {
            return true;
        }
        if (contentType == null || contentType.toLowerCase().indexOf("text/plain") != -1 || contentType.toLowerCase().indexOf("text/xml") != -1) {
            return this.hasHtmlContent();
        }
        return false;
    }

    private boolean hasHtmlContent() {
        String s = this.getSampleContent();
        return s.indexOf("<html") != -1 || s.indexOf("<body") != -1 || s.indexOf("<table") != -1 || s.indexOf("<script") != -1 || s.indexOf("<form") != -1;
    }

    public String charset() {
        if (this.charset == null) {
            String charsetEqTo;
            int ix;
            this.charset = "iso-8859-1";
            String lookIn = this.contentTypeHeader();
            if (lookIn == null) {
                lookIn = this.getSampleContent("iso-8859-1");
            }
            if ((ix = lookIn.indexOf(charsetEqTo = "charset=")) != -1) {
                int endIx = lookIn.indexOf(34, ix);
                if (endIx == -1) {
                    endIx = lookIn.length();
                }
                this.charset = lookIn.substring(ix + charsetEqTo.length(), endIx).trim();
            }
            if (this.charset.endsWith(";")) {
                this.charset = this.charset.substring(0, this.charset.length() - 1);
            }
            try {
                new String(new byte[0], this.charset);
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Defaulting to charset iso-8859-1");
                this.charset = "iso-8859-1";
            }
        }
        return this.charset;
    }

    String getSampleContent() {
        return this.getSampleContent(this.charset());
    }

    String getSampleContent(String charset) {
        String sampleContent = null;
        try {
            byte[] data;
            int limit = Configuration.sampleLength();
            if (this.contentLength() < limit) {
                limit = this.contentLength();
            }
            sampleContent = (data = this.data()) == null ? "" : new String(data, 0, limit, charset).toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sampleContent;
    }
}

