/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.report;

import java.util.List;
import net.sf.sahi.report.Formatter;
import net.sf.sahi.report.ResultType;
import net.sf.sahi.report.TestResult;
import net.sf.sahi.report.TestSummary;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TM6Formatter
implements Formatter {
    @Override
    public String getFileName(String scriptName) {
        int ix = scriptName.indexOf("__");
        String fileName = ix == -1 ? scriptName : scriptName.substring(0, ix);
        return fileName + ".xml";
    }

    @Override
    public String getFooter() {
        return "</report>";
    }

    @Override
    public String getSuiteLogFileName() {
        return "";
    }

    @Override
    public String getHeader() {
        return "<report>";
    }

    @Override
    public String getResultData(List<TestResult> listResult) {
        long lastTime = -1L;
        StringBuffer sb = new StringBuffer();
        if (listResult != null && listResult.size() > 0) {
            for (int i = 0; i < listResult.size(); ++i) {
                TestResult result = listResult.get(i);
                long timeDiff = 100L;
                if (lastTime != -1L) {
                    timeDiff = result.time.getTime() - lastTime;
                }
                lastTime = result.time.getTime();
                sb.append(this.getStringResult(result, timeDiff)).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getStartScript() {
        return "";
    }

    @Override
    public String getStopScript() {
        return "";
    }

    @Override
    public String getSummaryData(TestSummary summary) {
        return "";
    }

    public String getStringResult(TestResult result, long timeDiff) {
        StringBuffer sb = new StringBuffer();
        String fullMsg = result.message;
        String stepName = result.message;
        int slashNIx = fullMsg.indexOf("\n");
        String extra = "";
        if (slashNIx != -1) {
            stepName = fullMsg.substring(0, slashNIx);
            if (slashNIx + 1 < fullMsg.length()) {
                extra = fullMsg.substring(slashNIx + 1);
            }
        }
        if (ResultType.CUSTOM1.equals(result.type)) {
            return "";
        }
        sb.append("<step name=\"").append(Utils.escapeForXML(stepName)).append("\"");
        if (ResultType.FAILURE.equals(result.type)) {
            sb.append(" warn=\"").append(Utils.escapeForXML(result.failureMsg)).append("\"");
        }
        if (ResultType.ERROR.equals(result.type)) {
            sb.append(" failure=\"").append(Utils.escapeForXML(extra)).append("\"");
        }
        sb.append(" dur=\"").append(timeDiff).append("\"");
        sb.append(" />");
        return sb.toString();
    }

    @Override
    public String getSummaryFooter() {
        return "";
    }

    @Override
    public String getSummaryHeader() {
        return "";
    }
}

