/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.report;

import java.util.ArrayList;
import java.util.List;
import net.sf.sahi.report.ResultType;
import net.sf.sahi.report.SahiReporter;
import net.sf.sahi.report.TestResult;
import net.sf.sahi.report.TestSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    protected List<TestResult> listResult = new ArrayList<TestResult>();
    protected String scriptName;
    protected List<SahiReporter> listReporter;
    protected TestSummary testSummary;
    private long startTime;
    private long endTime;

    public Report(String scriptName, List<SahiReporter> listReporter) {
        this.scriptName = scriptName;
        this.listReporter = listReporter;
    }

    public Report(String scriptName) {
        this.scriptName = scriptName;
        this.listReporter = new ArrayList<SahiReporter>();
    }

    public Report(String scriptName, SahiReporter reporter) {
        this.scriptName = scriptName;
        this.addReporter(reporter);
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public List<SahiReporter> getListReporter() {
        return this.listReporter;
    }

    public void setListReporter(List<SahiReporter> listReporter) {
        this.listReporter = listReporter;
    }

    public void addReporter(SahiReporter reporter) {
        if (this.listReporter == null) {
            this.listReporter = new ArrayList<SahiReporter>();
        }
        this.listReporter.add(reporter);
    }

    public List<TestResult> getListResult() {
        return this.listResult;
    }

    void addResult(List<TestResult> listResult) {
        this.listResult.addAll(listResult);
    }

    public void addResult(String message, String type, String debugInfo, String failureMsg) {
        this.listResult.add(new TestResult(message, ResultType.getType(type), debugInfo, failureMsg));
    }

    public void addResult(String message, ResultType type, String debugInfo, String failureMsg) {
        this.listResult.add(new TestResult(message, type, debugInfo, failureMsg));
    }

    public TestSummary summarizeResults(String logFileNameBase) {
        TestSummary summary = new TestSummary();
        boolean fail = false;
        summary.setScriptName(this.scriptName);
        summary.setSteps(this.listResult.size());
        summary.setLogFileName(logFileNameBase);
        if (this.listResult.size() == 0) {
            fail = true;
        } else {
            for (TestResult result : this.listResult) {
                if (ResultType.FAILURE.equals(result.type)) {
                    summary.incrementFailures();
                    fail = true;
                    continue;
                }
                if (ResultType.ERROR.equals(result.type)) {
                    summary.incrementErrors();
                    fail = true;
                    continue;
                }
                if (!ResultType.SUCCESS.equals(result.type)) continue;
                summary.incrementSuccesses();
            }
        }
        summary.setTimeTaken(this.getTimeTaken());
        summary.setFail(fail);
        return summary;
    }

    public TestSummary getTestSummary(String logFileNameBase) {
        if (this.testSummary == null) {
            this.testSummary = this.summarizeResults(logFileNameBase);
        }
        return this.testSummary;
    }

    void setTestSummary(TestSummary testSummary) {
        this.testSummary = testSummary;
    }

    public void generateTestReport(String logFileTS) {
        for (SahiReporter reporter : this.listReporter) {
            reporter.generateTestReport(this, logFileTS);
        }
    }

    public void stopTimer() {
        this.endTime = System.currentTimeMillis();
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
    }

    public long getTimeTaken() {
        return this.endTime - this.startTime;
    }
}

