/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.report;

import java.util.List;
import net.sf.sahi.report.Formatter;
import net.sf.sahi.report.ResultType;
import net.sf.sahi.report.TestResult;
import net.sf.sahi.report.TestSummary;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitFormatter
implements Formatter {
    @Override
    public String getFileName(String scriptName) {
        return "TEST-" + scriptName + ".xml";
    }

    @Override
    public String getFooter() {
        return "</testcase></testsuite>";
    }

    @Override
    public String getSuiteLogFileName() {
        return "";
    }

    @Override
    public String getHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    }

    @Override
    public String getResultData(List<TestResult> listResult) {
        StringBuffer sb = new StringBuffer();
        if (listResult != null && listResult.size() > 0) {
            for (int i = 0; i < listResult.size(); ++i) {
                TestResult result = listResult.get(i);
                sb.append(this.getStringResult(result)).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getStartScript() {
        return "";
    }

    @Override
    public String getStopScript() {
        return "";
    }

    @Override
    public String getSummaryData(TestSummary summary) {
        StringBuffer sb = new StringBuffer();
        int testCases = 1;
        int failureCount = summary.getFailures() == 0 ? 0 : (summary.getErrors() > 0 ? 0 : 1);
        sb.append("\n<testsuite errors=\"").append(summary.getErrors() > 0 ? 1 : 0).append("\" failures=\"").append(failureCount).append("\" name=\"").append(Utils.escapeQuotesForXML(summary.getSuiteName() + "." + summary.getScriptName().replace(".sah", ""))).append("\" tests=\"").append(testCases).append("\" time=\"").append(new Double(summary.getTimeTaken()) / 1000.0).append("\">\n").append("<testcase classname=\"").append(Utils.escapeQuotesForXML(summary.getSuiteName() + "." + summary.getScriptName().replace(".sah", ""))).append("\" name=\"").append(Utils.escapeQuotesForXML(summary.getScriptName())).append("\" time=\"").append(new Double(summary.getTimeTaken()) / 1000.0).append("\">");
        return sb.toString();
    }

    public String getStringResult(TestResult result) {
        if (!ResultType.FAILURE.equals(result.type) && !ResultType.ERROR.equals(result.type)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (ResultType.FAILURE.equals(result.type) || ResultType.ERROR.equals(result.type)) {
            String tag = ResultType.FAILURE.equals(result.type) ? "failure" : "error";
            sb.append("\n<" + tag + " message=\"Assertion Failed\">");
            if (!Utils.isBlankOrNull(result.failureMsg)) {
                sb.append("<![CDATA[").append(result.failureMsg).append("]]>");
            }
            sb.append("</" + tag + ">\n");
        }
        return sb.toString();
    }

    @Override
    public String getSummaryFooter() {
        return "";
    }

    @Override
    public String getSummaryHeader() {
        return "";
    }
}

