/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.util.ClassLoadHelper;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBClient {
    public String driverName;
    public String jdbcurl;
    public String username;
    public String password;
    public String sql;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String driverName, String jdbcurl, String username, String password, String sql) {
        Statement stmt = null;
        Connection connection = null;
        try {
            ClassLoadHelper.getClass(driverName);
            connection = DriverManager.getConnection(jdbcurl, username, password);
            stmt = connection.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    stmt.close();
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void execute(HttpRequest request) {
        this.init(request);
        this.execute(this.driverName, this.jdbcurl, this.username, this.password, this.sql);
    }

    public String select(String driverName, String jdbcurl, String username, String password, String sql) {
        try {
            return this.getJSObject(this.getResult(driverName, jdbcurl, username, password, sql));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "exception: " + Utils.getStackTraceString(e);
        }
    }

    public HttpResponse select(HttpRequest request) {
        this.init(request);
        String s = this.select(this.driverName, this.jdbcurl, this.username, this.password, this.sql);
        return new SimpleHttpResponse(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ArrayList<String>> getResult(String driverName, String jdbcurl, String username, String password, String sql) throws ClassNotFoundException, SQLException {
        ClassLoadHelper.getClass(driverName);
        Connection connection = DriverManager.getConnection(jdbcurl, username, password);
        Statement stmt = connection.createStatement();
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            ArrayList<String> columnNames = new ArrayList<String>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            for (int i = 1; i < numColumns + 1; ++i) {
                String columnName = rsmd.getColumnName(i);
                columnNames.add(columnName);
            }
            list.add(columnNames);
            while (rs.next()) {
                ArrayList<String> record = new ArrayList<String>();
                for (String columnName : columnNames) {
                    String value = rs.getString(columnName);
                    record.add(value);
                }
                list.add(record);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        return list;
    }

    String getJSObject(ArrayList<ArrayList<String>> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("{result: [[");
        boolean isFirst1 = true;
        Iterator<ArrayList<String>> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (isFirst1) {
                isFirst1 = false;
            } else {
                sb.append(",[");
            }
            ArrayList<String> record = iterator.next();
            for (int i = 0; i < record.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                String value = record.get(i);
                sb.append("\"" + Utils.makeString(value) + "\"");
            }
            sb.append("]");
        }
        sb.append("]}");
        return sb.toString();
    }

    private void init(HttpRequest request) {
        this.driverName = request.getParameter("driver");
        this.jdbcurl = request.getParameter("jdbcurl");
        this.username = request.getParameter("username");
        this.password = request.getParameter("password");
        this.sql = request.getParameter("sql");
        System.out.println("Driver: " + this.driverName);
        System.out.println("JDBC URL: " + this.jdbcurl);
        System.out.println("Username: " + this.username);
        System.out.println("Password: " + this.password);
        System.out.println("SQL: " + this.sql);
    }
}

