/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.playback;

import java.io.File;
import java.util.ArrayList;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScript
extends SahiScript {
    private String userDirRelativePath;

    public FileScript(String fileName) {
        super(fileName, new ArrayList<String>(), new File(fileName).getName());
    }

    private void setUserDirRelativePath(String fileName) {
        String userDirPath;
        String s = Utils.makePathOSIndependent(Utils.getAbsolutePath(fileName));
        if (s.startsWith(userDirPath = Utils.makePathOSIndependent(Configuration.getUserDataDir()))) {
            this.userDirRelativePath = s.substring(userDirPath.length());
            if (this.userDirRelativePath.startsWith("/")) {
                this.userDirRelativePath = this.userDirRelativePath.substring(1);
            }
        }
    }

    public FileScript(String fileName, ArrayList<String> parents) {
        super(fileName, parents, new File(fileName).getName());
    }

    @Override
    protected void loadScript(String fileName) {
        this.setUserDirRelativePath(fileName);
        try {
            this.setScript(Utils.readFileAsString(fileName));
        }
        catch (Exception e) {
            this.setScript("throw \"Script: " + Utils.escapeDoubleQuotesAndBackSlashes(fileName) + " does not exist.\";\n");
        }
    }

    @Override
    String getFQN(String scriptName) {
        if (scriptName.indexOf("http") == 0) {
            return scriptName;
        }
        return Utils.getAbsolutePath(Utils.getRelativeFile(new File(this.path), scriptName));
    }

    SahiScript getNewInstance(String scriptName, ArrayList<String> parents) {
        FileScript fileScript = new FileScript(this.getFQN(scriptName), parents);
        fileScript.parents = parents;
        return fileScript;
    }

    @Override
    protected String getDebugFilePath() {
        if (this.userDirRelativePath != null) {
            return this.userDirRelativePath;
        }
        return super.getDebugFilePath();
    }
}

