/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.issue;

import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.sahi.issue.Issue;
import net.sf.sahi.issue.IssueCreator;
import net.sf.sahi.issue.IssueFormatter;
import net.sf.sahi.report.SahiReporter;
import net.sf.sahi.test.TestLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueReporter
extends SahiReporter {
    private List<IssueCreator> listIssueCreator = new ArrayList<IssueCreator>();

    public void addIssueCreator(IssueCreator issueCreator) {
        this.listIssueCreator.add(issueCreator);
    }

    public IssueReporter(String suiteName) {
        super(new IssueFormatter());
        this.suiteName = suiteName;
    }

    @Override
    protected void createWriter() throws IOException {
        this.suiteWriter = new StringWriter();
    }

    @Override
    public boolean createSuiteLogFolder() {
        return false;
    }

    public void reportIssue(List<TestLauncher> tests) {
        Issue issue = this.prepareIssue(tests);
        this.createIssue(issue);
    }

    void createIssue(Issue issue) {
        try {
            for (IssueCreator issueCreator : this.listIssueCreator) {
                issueCreator.login();
                issueCreator.createIssue(issue);
                issueCreator.logout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Issue prepareIssue(List<TestLauncher> tests) {
        this.generateSuiteReport(tests);
        StringWriter sw = (StringWriter)this.suiteWriter;
        String summary = this.suiteName + " failed on " + new SimpleDateFormat("ddMMMyy_HH:mm:ss").format(new Date());
        return new Issue(summary, sw.getBuffer().toString());
    }
}

