/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.util.HashMap;
import net.sf.sahi.command.RecordedSteps;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.session.Session;

public class StepWiseRecorder {
    static HashMap<String, RecordedSteps> recorders = new HashMap();

    public void start(HttpRequest request) {
        RecordedSteps recordedSteps = recorders.get(request.session().id());
        if (recordedSteps != null) {
            return;
        }
        recordedSteps = new RecordedSteps();
        Session session = request.session();
        recorders.put(session.id(), recordedSteps);
    }

    public void record(HttpRequest request) {
        RecordedSteps recordedSteps = recorders.get(request.session().id());
        String step = request.getParameter("step");
        if (recordedSteps == null || !request.session().isRecording()) {
            return;
        }
        recordedSteps.record(step);
    }

    public SimpleHttpResponse getSteps(HttpRequest request) {
        RecordedSteps recordedSteps = recorders.get(request.session().id());
        if (recordedSteps == null) {
            return new SimpleHttpResponse("");
        }
        return new SimpleHttpResponse(recordedSteps.getNewStepsAsString());
    }

    public SimpleHttpResponse getAllSteps(HttpRequest request) {
        RecordedSteps recordedSteps = recorders.get(request.session().id());
        if (recordedSteps == null) {
            return new SimpleHttpResponse("");
        }
        return new SimpleHttpResponse(recordedSteps.getAllStepsAsString());
    }

    public void clear(HttpRequest request) {
        RecordedSteps recordedSteps = recorders.get(request.session().id());
        if (recordedSteps != null) {
            recordedSteps.clear();
        }
    }

    public void stop(HttpRequest request) {
        Session session = request.session();
        session.setIsRecording(false);
    }
}

