/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.util.Properties;
import net.sf.sahi.command.Hits;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.rhino.ScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.test.SahiTestSuite;
import net.sf.sahi.util.Utils;

public class SessionState {
    public HttpResponse ping(HttpRequest request) {
        return new SimpleHttpResponse(request.session().getInfoJSON());
    }

    public HttpResponse isPlaying(HttpRequest request) {
        Session session = request.session();
        return new SimpleHttpResponse(session.isPlaying() ? "1" : "0");
    }

    public HttpResponse domainfix(HttpRequest request) {
        String domainFixInfo = Configuration.getDomainFixInfo();
        Properties props = new Properties();
        props.setProperty("domainInfo", domainFixInfo);
        return new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/domainfix.js", props, false, true);
    }

    public HttpResponse isRecording(HttpRequest request) {
        Session session = request.session();
        return new SimpleHttpResponse(session.isRecording() ? "1" : "0");
    }

    public HttpResponse execute(HttpRequest request) {
        Session session = request.session();
        Properties props = new Properties();
        props.setProperty("sessionId", session.id());
        props.setProperty("isWindowOpen", "" + session.isWindowOpen());
        props.setProperty("isSahiPaused", "" + session.isPaused());
        props.setProperty("isSahiPlaying", "" + session.isPlaying());
        props.setProperty("isSahiRecording", "" + session.isRecording());
        props.setProperty("hotkey", "" + Configuration.getHotKey());
        props.setProperty("interval", "" + Configuration.getTimeBetweenSteps());
        props.setProperty("onErrorInterval", "" + Configuration.getTimeBetweenStepsOnError());
        props.setProperty("maxRetries", "" + Configuration.getMaxReAttemptsOnError());
        props.setProperty("maxWaitForLoad", "" + Configuration.getMaxCyclesForPageLoad());
        props.setProperty("strictVisibilityCheck", "" + Configuration.isStrictVisibilityCheckEnabled());
        props.setProperty("waitReadyStates", Configuration.xhrReadyStatesToWaitFor());
        props.setProperty("controllerMode", "" + Configuration.getControllerMode());
        props.setProperty("escapeUnicode", "" + Configuration.getEscapeUnicode());
        props.setProperty("commonDomain", "" + Configuration.getCommonDomain());
        props.setProperty("chromeExplicitCheckboxRadioToggle", "" + Configuration.getChromeExplicitCheckboxRadioToggle());
        props.setProperty("ignorableIdsPattern", Configuration.getIgnorableIdsPattern());
        props.setProperty("strictVisibilityCheck", "" + session.getVariable("strictVisibilityCheck"));
        props.setProperty("isSingleSession", "" + session.getVariable("isSingleSession"));
        String waitCondition = session.getVariable("waitCondition");
        if (Utils.isBlankOrNull(waitCondition)) {
            waitCondition = "";
        }
        props.setProperty("waitCondition", "" + Utils.escapeDoubleQuotesAndBackSlashes(waitCondition));
        String waitTime = session.getVariable("waitConditionTime");
        if (Utils.isBlankOrNull(waitTime)) {
            waitTime = "-1";
        }
        props.setProperty("waitConditionTime", "" + waitTime);
        props.setProperty("stabilityIndex", "" + Configuration.getStabilityIndex());
        ScriptRunner scriptRunner = session.getScriptRunner();
        if (scriptRunner != null && scriptRunner.getScript() != null) {
            props.setProperty("scriptPath", Utils.escapeDoubleQuotesAndBackSlashes(Utils.escapeDoubleQuotesAndBackSlashes(scriptRunner.getScript().getFilePath())));
            props.setProperty("scriptName", scriptRunner.getScriptName());
        } else {
            props.setProperty("scriptPath", "");
            props.setProperty("scriptName", "");
        }
        NoCacheHttpResponse httpResponse = new NoCacheHttpResponse(new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/state.js", props, false, true));
        this.addSahisidCookie(httpResponse, session);
        return httpResponse;
    }

    public void setVar(HttpRequest request) {
        Session session = request.session();
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        boolean append = "1".equals(request.getParameter("append"));
        Hits.increment("SessionState_setVar :: " + name);
        if (this.setVarOnSuite(request)) {
            String val;
            SahiTestSuite suite = request.session().getSuite();
            if (append && (val = suite.getVariable(name)) != null) {
                value = val + " + " + value;
            }
            suite.setVariable(name, value);
        } else {
            String val;
            if (append && (val = session.getVariable(name)) != null) {
                value = val + " + " + value;
            }
            this.setVar(name, value, session);
        }
    }

    private boolean setVarOnSuite(HttpRequest request) {
        boolean isGlobal = "1".equals(request.getParameter("isglobal"));
        return Configuration.spanVariablesAcrossSuite() && isGlobal && request.session().getSuite() != null;
    }

    public void setVar(String name, String value, Session session) {
        session.setVariable(name, value);
    }

    public HttpResponse getVar(HttpRequest request) {
        Session session = request.session();
        String name = request.getParameter("name");
        Hits.increment("SessionState_getVar :: " + name);
        boolean isDelete = "1".equals(request.getParameter("isdelete"));
        String value = null;
        if (this.setVarOnSuite(request)) {
            SahiTestSuite suite = request.session().getSuite();
            value = suite.getVariable(name);
            if (isDelete) {
                suite.setVariable(name, null);
            }
        } else {
            value = session.getVariable(name);
            if (isDelete) {
                session.setVariable(name, null);
            }
        }
        NoCacheHttpResponse httpResponse = new NoCacheHttpResponse(value != null ? Utils.encode(value) : "null");
        return httpResponse;
    }

    private HttpResponse addSahisidCookie(HttpResponse httpResponse, Session session) {
        httpResponse.addHeader("Set-Cookie", "sahisid=" + session.id() + "; path=/; ");
        httpResponse.addHeader("P3P", "policyref=\"http://" + Configuration.getCommonDomain() + "/p3p.xml\", CP=\"NON DSP COR CURa ADMa DEVa CUSa TAIa OUR SAMa IND\"");
        httpResponse.resetRawHeaders();
        return httpResponse;
    }

    public void setCredentials(HttpRequest request) {
        Session session = request.session();
        session.addRequestCredentials(request.getParameter("authRealm"), request.getParameter("authUser"), request.getParameter("authPassword"));
    }

    public void removeAllCredentials(HttpRequest request) {
        Session session = request.session();
        session.removeAllRequestCredentials();
    }
}

