/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.session.Session;
import net.sf.sahi.util.Utils;

public class Recorder {
    public void start(HttpRequest request) {
        this.startRecorder(request);
    }

    public void record(HttpRequest request) {
        Session session = request.session();
        if (session.isRecording()) {
            session.getRecorder().record(request.getParameter("step"));
        }
    }

    public void stop(HttpRequest request) {
        Session session = request.session();
        if (session.isRecording()) {
            session.getRecorder().stop();
        }
        session.setIsRecording(false);
    }

    private void startRecorder(HttpRequest request) {
        Session session = request.session();
        String dir = request.getParameter("dir");
        String fileName = request.getParameter("file");
        if (fileName.indexOf(".") == -1) {
            fileName = fileName + ".sah";
        }
        net.sf.sahi.record.Recorder recorder = session.getRecorder();
        recorder.setDir(dir);
        recorder.start(Utils.concatPaths(dir, fileName));
        session.setIsRecording(true);
    }
}

