/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.util.Utils;

public class CommandInvoker {
    private static final int NORMAL_TERMINATION = 0;
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";

    public HttpResponse execute(HttpRequest request) throws InterruptedException {
        String command = request.getParameter("command");
        boolean isSynchronous = Boolean.toString(true).equals(request.getParameter("sync"));
        String exitStatus = this.executeSystemCommand(command, isSynchronous);
        return new SimpleHttpResponse(exitStatus);
    }

    public String getCommandForOS(String command) {
        String cmd = "";
        if (Utils.isWindows95()) {
            cmd = "command.com /C " + command;
        } else if (Utils.isWindows()) {
            cmd = "cmd.exe /C " + command;
        }
        return cmd;
    }

    private String executeSystemCommand(String command, boolean isSynchronous) throws InterruptedException {
        String cmd = "";
        try {
            cmd = command;
            System.out.println("Executing: " + cmd);
            Process process = Runtime.getRuntime().exec(Utils.getCommandTokens(cmd));
            return isSynchronous ? this.getExitStatus(process) : SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            return FAILURE;
        }
    }

    private String getExitStatus(Process process) throws InterruptedException {
        return 0 == process.waitFor() ? SUCCESS : FAILURE;
    }
}

